/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import de.resolution.atlasuser.api.group.AtlasGroupAdapter;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.builtin.scim.ScimConnector;
import de.resolution.usersync.builtin.scim.ScimConnectorConfiguration;
import de.resolution.usersync.builtin.scim.ScimConnectorConfigurationImpl;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractConnectorFactory;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="scimConnectorFactory")
@JsonAutoDetect
public class ScimConnectorFactory
extends AbstractConnectorFactory<ScimConnector, ScimConnectorConfiguration> {
    public static final String NAME = "SCIM 2.0";
    private static final String DESCRIPTION = "This is a connector for SCIM.";
    private final AtlasGroupAdapter atlasGroupAdapter;

    @Inject
    public ScimConnectorFactory(ConnectorService connectorService, AtlasGroupAdapter atlasGroupAdapter, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
        this.atlasGroupAdapter = atlasGroupAdapter;
    }

    @Override
    @Nonnull
    public ScimConnector create(@Nonnull ScimConnectorConfiguration connectorConfiguration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return new ScimConnector(this.connectorService, this.atlasUserAdapter, this.atlasGroupAdapter, connectorConfiguration, newConnector, lastUpdated);
    }

    @Override
    @Nonnull
    public ScimConnectorConfigurationImpl createEmptyConfiguration(@Nonnull String uniqueId) {
        ScimConnectorConfigurationImpl mutableConfig = new ScimConnectorConfigurationImpl();
        mutableConfig.setName("new SCIM 2.0");
        mutableConfig.setUniqueId(uniqueId);
        return mutableConfig;
    }

    @Override
    @Nonnull
    public Class<ScimConnector> getConnectorClass() {
        return ScimConnector.class;
    }

    @Override
    @Nonnull
    public Class<ScimConnectorConfiguration> getConfigurationClass() {
        return ScimConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editScimConnector.json";
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull ScimConnectorConfiguration config) {
        ValidationResult validationResult = super.validate(config);
        if (config.getMaxSyncResultAge() <= 0L) {
            validationResult.add("maxSyncResultAge", "The value must be greater than 0", null);
        }
        return validationResult;
    }
}

