/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.api;

import java.util.Set;

public interface ApplicationInformation {
    public Application getApplication();

    public Set<SubApplication> getSubApplications();

    public String getApplicationDisplayName();

    public String getApplicationVersion();

    default public boolean isJira() {
        return this.getApplication() == Application.JIRA;
    }

    default public boolean isConfluence() {
        return this.getApplication() == Application.CONFLUENCE;
    }

    default public boolean isBitbucket() {
        return this.getApplication() == Application.BITBUCKET;
    }

    default public boolean isBamboo() {
        return this.getApplication() == Application.BAMBOO;
    }

    default public boolean isFeCru() {
        return this.getApplication() == Application.FECRU;
    }

    default public boolean isCrowd() {
        return this.getApplication() == Application.CROWD;
    }

    default public boolean isJiraServicedesk() {
        return this.getSubApplications().contains((Object)SubApplication.JIRA_SERVICE_DESK);
    }

    default public boolean isJiraSoftware() {
        return this.getSubApplications().contains((Object)SubApplication.JIRA_SOFTWARE);
    }

    public String getApplicationBaseUrl();

    public String getApplicationContextPath();

    public String getApplicationLoginUrl();

    public String getApplicationServerId();

    public static enum Application {
        OTHER,
        JIRA,
        CONFLUENCE,
        BITBUCKET,
        BAMBOO,
        FECRU,
        CROWD;

    }

    public static enum SubApplication {
        JIRA_SOFTWARE,
        JIRA_SERVICE_DESK;

    }
}

