/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SetSameSiteCookieAttributeToNoneAttributeFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SetSameSiteCookieAttributeToNoneAttributeFilter.class);
    private static final String SAMESITE_ATTRIBUTE_NAME = "SameSite";
    private static final String SECURE_ATTRIBUTE_NAME = "Secure";
    public static final String SET_COOKIE = "Set-Cookie";
    private static final String ALREADY_FILTERED = SetSameSiteCookieAttributeToNoneAttributeFilter.class.getName() + "_already_filtered";
    private final RunningConfiguration configuration;

    @Inject
    public SetSameSiteCookieAttributeToNoneAttributeFilter(RunningConfiguration configuration) {
        this.configuration = configuration;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(ALREADY_FILTERED) != null) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(ALREADY_FILTERED, (Object)"yes");
        if (!this.configuration.isSetSameSiteAttributeOnSessionCookie()) {
            logger.debug("Setting SameSiteAttribute is disabled");
            chain.doFilter(request, response);
            return;
        }
        if (this.configuration.getSessionCookieName() == null || this.configuration.getSessionCookieName().trim().isEmpty()) {
            logger.debug("Session cookie name is null or empty");
            chain.doFilter(request, response);
            return;
        }
        if (!"https".equalsIgnoreCase(request.getScheme())) {
            logger.debug("Request is not HTTPS");
            chain.doFilter(request, response);
            return;
        }
        this.appendSameSite((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)new SameSiteResponseProxy((HttpServletResponse)response));
    }

    private void appendSameSite(HttpServletResponse response) {
        Collection<String> cookieHeaders = SetSameSiteCookieAttributeToNoneAttributeFilter.updateCookieHeaders(this.configuration.getSessionCookieName(), response.getHeaders(SET_COOKIE));
        boolean firstHeader = true;
        for (String cookieHeaderToSet : cookieHeaders) {
            if (firstHeader) {
                logger.trace("Setting {}: {}", (Object)SET_COOKIE, (Object)cookieHeaderToSet);
                response.setHeader(SET_COOKIE, cookieHeaderToSet);
            } else {
                logger.trace("Adding {}: {}", (Object)SET_COOKIE, (Object)cookieHeaderToSet);
                response.addHeader(SET_COOKIE, cookieHeaderToSet);
            }
            firstHeader = false;
        }
    }

    public static Collection<String> updateCookieHeaders(String cookieName, Collection<String> setCookieHeaders) {
        ArrayList<String> updatedHeaders = new ArrayList<String>(setCookieHeaders.size());
        for (String cookieHeader : setCookieHeaders) {
            if (cookieHeader == null || cookieHeader.trim().isEmpty()) continue;
            List<HttpCookie> parsedCookies = null;
            try {
                parsedCookies = HttpCookie.parse(cookieHeader);
            }
            catch (IllegalArgumentException e) {
                logger.trace("Cookie header [{}] violates the cookie specification and will be ignored", (Object)cookieHeader);
            }
            if (parsedCookies == null || parsedCookies.size() != 1) continue;
            String currentCookieName = parsedCookies.get(0).getName();
            String cookieHeaderToSet = cookieHeader;
            if (cookieName.equals(currentCookieName)) {
                if (!cookieHeader.contains(SAMESITE_ATTRIBUTE_NAME)) {
                    cookieHeaderToSet = String.format("%s; %s", cookieHeaderToSet, "SameSite=None");
                }
                if (!cookieHeaderToSet.contains(SECURE_ATTRIBUTE_NAME)) {
                    cookieHeaderToSet = String.format("%s; %s", cookieHeaderToSet, SECURE_ATTRIBUTE_NAME);
                }
            }
            updatedHeaders.add(cookieHeaderToSet);
        }
        return updatedHeaders;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    private class SameSiteResponseProxy
    extends HttpServletResponseWrapper {
        @Nonnull
        private final HttpServletResponse response;

        public SameSiteResponseProxy(HttpServletResponse resp) {
            super(resp);
            this.response = resp;
        }

        public void sendError(int sc) throws IOException {
            SetSameSiteCookieAttributeToNoneAttributeFilter.this.appendSameSite(this.response);
            super.sendError(sc);
        }

        public PrintWriter getWriter() throws IOException {
            SetSameSiteCookieAttributeToNoneAttributeFilter.this.appendSameSite(this.response);
            return super.getWriter();
        }

        public void sendError(int sc, String msg) throws IOException {
            SetSameSiteCookieAttributeToNoneAttributeFilter.this.appendSameSite(this.response);
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            SetSameSiteCookieAttributeToNoneAttributeFilter.this.appendSameSite(this.response);
            super.sendRedirect(location);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            SetSameSiteCookieAttributeToNoneAttributeFilter.this.appendSameSite(this.response);
            return super.getOutputStream();
        }
    }
}

