/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira;

import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.resolution.atlasplugins.samlsso.JiraServiceDeskDetector;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationDefaultSetter;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent(value="configurationDefaultSetter")
public class JiraConfigurationDefaultSetter
extends ConfigurationDefaultSetter {
    private static final Logger logger = LoggerFactory.getLogger(JiraConfigurationDefaultSetter.class);
    public static final String OLD_APPLINKS_NONSSO_DESTINATION = "/plugins/servlet/applinks.*";
    public static final String NEW_APPLINKS_NONSSO_DESTINATION = ".*/plugins/servlet/applinks.*";

    @Inject
    public JiraConfigurationDefaultSetter(@JiraImport ApplicationProperties applicationProperties, DirectoryAdapter directoryAdapter, JiraServiceDeskDetector jiraServiceDeskDetector) {
        super(applicationProperties, directoryAdapter, jiraServiceDeskDetector);
    }

    @Override
    public void addSamlDefaults(@Nonnull ConfigurationData configurationData, boolean newConfig) {
        if (newConfig && configurationData.nonSsoDestinations.isEmpty()) {
            logger.info("Setting nonSsoDestinations to default {}", (Object)".*/secure/johnson/events/dismiss,.*/plugins/servlet/applinks.*,.*applicationlinks.*");
            configurationData.nonSsoDestinations = Utils.splitString(".*/secure/johnson/events/dismiss,.*/plugins/servlet/applinks.*,.*applicationlinks.*");
        }
        if (configurationData.nonSsoDestinations.remove(OLD_APPLINKS_NONSSO_DESTINATION)) {
            logger.warn("Replacing application-links nonsso-destination {} with {}", (Object)OLD_APPLINKS_NONSSO_DESTINATION, (Object)NEW_APPLINKS_NONSSO_DESTINATION);
            configurationData.nonSsoDestinations.add(NEW_APPLINKS_NONSSO_DESTINATION);
        }
        if (newConfig && configurationData.enforceSsoDestinations.isEmpty()) {
            logger.info("Setting enforce SSO destinations to {}", (Object)"/,/default\\.jsp\\??.*,/secure/Dashboard\\.jspa\\??.*,/secure/MyJiraHome\\.jspa\\??.*,/plugins/servlet/mobile.*");
            configurationData.enforceSsoDestinations = Utils.splitString("/,/default\\.jsp\\??.*,/secure/Dashboard\\.jspa\\??.*,/secure/MyJiraHome\\.jspa\\??.*,/plugins/servlet/mobile.*");
        }
        super.addSamlDefaults(configurationData, newConfig);
    }

    @Override
    @Nonnull
    public List<String> getDefaultEnforceSsoUrls() {
        return Utils.splitString("/,/default\\.jsp\\??.*,/secure/Dashboard\\.jspa\\??.*,/secure/MyJiraHome\\.jspa\\??.*,/plugins/servlet/mobile.*");
    }

    @Override
    @Nonnull
    public List<String> getDefaultNonSsoUrls() {
        return Utils.splitString(".*/secure/johnson/events/dismiss,.*/plugins/servlet/applinks.*,.*applicationlinks.*");
    }
}

