/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bitbucket;

import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureContext;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.bitbucket.BitbucketSamlSsoService;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;

public class BitbucketAuthenticationErrorServlet
extends BasicServlet {
    private static final long serialVersionUID = 1L;

    @Inject
    public BitbucketAuthenticationErrorServlet(BitbucketSamlSsoService samlSsoService, TemplateRenderer renderer) {
        super(samlSsoService, renderer);
    }

    @Override
    public void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("loginurl", this.samlSsoService.getRelativeNossoLoginPageUrl());
        ctx.put("ssourl", this.samlSsoService.getRelativeInitiateSSOUrl());
        HttpAuthenticationFailureContext failureContext = (HttpAuthenticationFailureContext)req.getSession(false).getAttribute("failureContext");
        if (failureContext != null) {
            ctx.put("userid", failureContext.getUsername());
            AuthenticationException authenticationException = failureContext.getAuthenticationException();
            ctx.put("message", authenticationException.getMessage());
            ctx.put("stacktrace", ExceptionUtils.getStackTrace((Throwable)authenticationException));
            req.getSession(false).removeAttribute("failureContext");
        } else {
            ctx.put("message", "The login failed for an unknown reason. Maybe you hit refresh on this error page, or you probably do not have permission to access Bitbucket. Please try again to login by clicking on the login link or the Bitbucket logo, or contact your administrator if the issue persists.");
        }
        String result = this.renderer.renderFragment(this.runningConfiguration.getErrorPageTemplate(), ctx);
        resp.setContentType("text/html;charset=utf-8");
        resp.getWriter().write(result);
    }
}

