window.AJS.toInit(function() {

    var $ = window.AJS.$;
    var trackerid = AJS.$('meta[name=trackerid]').attr("content");
    var ackToken  = AJS.$('meta[name=ackToken]').attr("content");
    var baseurl   = AJS.$('meta[name=baseurl]').attr("content");

    var $okButton     = $('#additional-auth-ok-button');
    var $cancelButton = $('#additional-auth-cancel-button');
    var $contentDiv   = $("#additional-auth-content");

    var updateLocalStorageAndClose = function() {
        // Putting the trackerid into the local storage. The value is not really
        // relevant, but the window requesting the additional authentication can listen for
        // storage events and use it as a trigger to reload the authentication status
        window.localStorage.setItem("additionalSAMLAuthentication", trackerid + "_" + Date.now());
        window.close();
    }

    $cancelButton.click(function() {
        $contentDiv.empty();
        $contentDiv.append($('<div class="aui-message aui-message-info">Confirmation was cancelled. Please close this window now.</div>'));
        updateLocalStorageAndClose();

    });

    $okButton.click(function() {
        $okButton.disabled = true;
        $contentDiv.empty();
        $contentDiv.append($('<div class="aui-message aui-message-info">Sending confirmation...</div>'));
        AJS.$.ajax({
            url: baseurl + "/rest/samlsso-admin/1.0/additionalauth/ack/" + ackToken,
            type: 'PUT',
            dataType: "json",
            success: function (data) {
                console.log("Confirmation was successful", data);
                $contentDiv.empty();
                $contentDiv.append($('<div class="aui-message aui-message-info">Confirmation done. Please close this window now.</div>'));
                updateLocalStorageAndClose();
            },
            error: function (xhr, errorText, err) {
                console.error("Error confirming: " + errorText, err);
                $contentDiv.empty();
                $contentDiv.append($('<div class="aui-message aui-message-error">Sending confirmation failed!</div>'));
            }
        });
    });
});
