/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.SingleLogoutService;
import com.resolution.atlasplugins.samlsso.SingleLogoutServiceException;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@UnrestrictedAccess
public class LogoutServlet
extends BasicServlet {
    private static final long serialVersionUID = -6848231299782192696L;
    private final SingleLogoutService singleLogoutService;

    public LogoutServlet(SamlSsoService samlSsoComponent, TemplateRenderer renderer, SingleLogoutService singleLogoutService) {
        super(samlSsoComponent, renderer);
        this.singleLogoutService = singleLogoutService;
    }

    @Override
    public void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.samlSsoService.isReady()) {
            this.sendError(resp, null, "SAML SingleSignOn is not initialized, check the configuration", null);
            return;
        }
        try {
            this.singleLogoutService.doSingleLogout(req, resp);
        }
        catch (SingleLogoutServiceException e) {
            this.sendError(resp, null, e.getMessage(), e);
        }
    }
}

