/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira;

import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.resolution.atlasplugins.samlsso.cluster.AbstractClusterNotificator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@JiraComponent(value="clusterNotificator")
public class JiraClusterNotificator
extends AbstractClusterNotificator
implements ClusterMessageConsumer,
DisposableBean {
    private static final String MESSAGE_CHANNEL = "SamlSsoChannel";
    private final ClusterMessagingService clusterMessagingService = (ClusterMessagingService)ComponentAccessor.getComponent(ClusterMessagingService.class);
    public static final Logger logger = LoggerFactory.getLogger(JiraClusterNotificator.class);

    public JiraClusterNotificator() {
        this.clusterMessagingService.registerListener(MESSAGE_CHANNEL, (ClusterMessageConsumer)this);
        logger.debug("Initialized JiraClusterNotificator");
    }

    public void receive(String channel, String message, String senderId) {
        logger.debug("Received message {} from {} over channel {}", new Object[]{message, senderId, channel});
        if (channel.equals(MESSAGE_CHANNEL)) {
            super.notifiyListeners(message);
        }
    }

    @Override
    public void send(String message) {
        logger.debug("Sending message {}", (Object)message);
        this.clusterMessagingService.sendRemote(MESSAGE_CHANNEL, message);
    }

    public void destroy() {
        logger.debug("Unregistering from ClusterMessagingService");
        this.clusterMessagingService.unregisterListener((ClusterMessageConsumer)this);
    }
}

