/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/redirection")
@Component
public class EnableRedirectionRestResource {
    private final RunningConfiguration pluginConfiguration;
    private final PrivilegeChecker privilegeChecker;

    @Autowired
    public EnableRedirectionRestResource(PrivilegeChecker privilegeChecker, RunningConfiguration pluginConfiguration) {
        this.privilegeChecker = privilegeChecker;
        this.pluginConfiguration = pluginConfiguration;
    }

    @GET
    @Produces(value={"application/json"})
    public Response status() throws JsonProcessingException {
        boolean status = this.pluginConfiguration.isRedirectToSso();
        String message = status ? "Redirection is enabled" : "Redirection is disabled";
        return Response.ok((Object)Utils.asJson(new EnableRedirectionResult(message, status))).cacheControl(Utils.ccNoCache).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/off")
    public Response disableRedirection(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException, JsonProcessingException {
        this.privilegeChecker.checkSysAdmin(request);
        if (!this.pluginConfiguration.isRedirectToSso()) {
            return Response.notModified().cacheControl(Utils.ccNoCache).build();
        }
        this.pluginConfiguration.setOverrideLoginUrl(false);
        this.pluginConfiguration.store();
        this.pluginConfiguration.fireConfigurationUpdated();
        return Response.ok((Object)Utils.asJson(new EnableRedirectionResult("Redirection has been disabled", false))).cacheControl(Utils.ccNoCache).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/on")
    public Response enableRedirection(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException, JsonProcessingException {
        this.privilegeChecker.checkSysAdmin(request);
        if (this.pluginConfiguration.isRedirectToSso()) {
            return Response.notModified().cacheControl(Utils.ccNoCache).build();
        }
        if (this.pluginConfiguration.isValid()) {
            this.pluginConfiguration.setOverrideLoginUrl(true);
            this.pluginConfiguration.store();
            this.pluginConfiguration.fireConfigurationUpdated();
            return Response.ok((Object)Utils.asJson(new EnableRedirectionResult("Redirection has been enabled.", true))).cacheControl(Utils.ccNoCache).build();
        }
        return Response.serverError().entity((Object)Utils.asJson(new EnableRedirectionResult("Configuration is invalid, redirection has NOT been enabled.", false))).cacheControl(Utils.ccNoCache).build();
    }

    public static class EnableRedirectionResult {
        private final String message;
        private final boolean status;

        public EnableRedirectionResult(String message, boolean status) {
            this.message = message;
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isStatus() {
            return this.status;
        }
    }
}

