/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.rest;

import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ForbiddenException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.exceptions.UnauthorizedException;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.license.LicenseStatus;
import de.resolution.commons.net.IPRangeChecker;
import de.resolution.commons.util.StringUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.builtin.scim.ScimConnector;
import de.resolution.usersync.builtin.scim.ScimConnectorConfiguration;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.external.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.external.api.exception.ConnectorNotFoundException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractResource {
    protected static final String PATH_PARAM_ID = "id";
    protected static final String PATH_PARAM_CONNECTOR_ID = "connectorId";
    protected static final String QUERY_PARAM_ATTRIBUTES = "attributes";
    protected static final String QUERY_PARAM_EXCLUDE_ATTRIBUTES = "excludedAttributes";
    protected static final String QUERY_PARAM_FILTER = "filter";
    protected static final String QUERY_PARAM_START_INDEX = "startIndex";
    protected static final String QUERY_PARAM_COUNT = "count";
    private final ConnectorService connectorService;
    private final PrivilegeChecker privilegeChecker;
    private final LicenseChecker licenseChecker;

    protected AbstractResource(ConnectorService connectorService, PrivilegeChecker privilegeChecker, LicenseChecker licenseChecker) {
        this.connectorService = connectorService;
        this.privilegeChecker = privilegeChecker;
        this.licenseChecker = licenseChecker;
    }

    @Nonnull
    protected ScimConnector checkPrivilegesAndGetConnector(@Nonnull HttpServletRequest request, @Nullable String connectorId) throws ScimException {
        ScimConnector scimConnector = this.loadConnector(connectorId);
        LicenseStatus licenseStatus = this.licenseChecker.checkLicense();
        if (!licenseStatus.isLicensed()) {
            throw new ForbiddenException("User Sync is not licensed");
        }
        if (!IPRangeChecker.isInRange((HttpServletRequest)request, ((ScimConnectorConfiguration)scimConnector.getConfiguration()).getAllowedIPs())) {
            throw new ForbiddenException("Request coming from an invalid IP or IP range");
        }
        switch (((ScimConnectorConfiguration)scimConnector.getConfiguration()).getAuthMethod()) {
            case BASIC: {
                try {
                    this.privilegeChecker.checkSysAdmin(request);
                    break;
                }
                catch (InsufficientUserPrivilegeException e) {
                    throw new ForbiddenException(e.getMessage(), null, (Throwable)e);
                }
            }
            case TOKEN: {
                this.validateBearerToken(request, ((ScimConnectorConfiguration)scimConnector.getConfiguration()).getToken());
                break;
            }
            default: {
                throw new UnauthorizedException("Invalid authentication method");
            }
        }
        return scimConnector;
    }

    private void validateBearerToken(@Nonnull HttpServletRequest request, @Nonnull String tokenFromConfig) throws ScimException {
        String authorizationHeader = request.getHeader("Authorization");
        String valuePrefix = "Bearer ";
        if (authorizationHeader == null || authorizationHeader.isEmpty()) {
            throw new UnauthorizedException("The request did not contain a valid bearer token");
        }
        if (!authorizationHeader.startsWith(valuePrefix)) {
            throw new UnauthorizedException("The request did not contain a valid bearer token");
        }
        String receivedToken = authorizationHeader.substring(valuePrefix.length());
        if (!tokenFromConfig.equals(receivedToken)) {
            throw new UnauthorizedException("Invalid bearer token");
        }
    }

    @Nonnull
    private ScimConnector loadConnector(@Nullable String connectorId) throws ScimException {
        Object connector;
        if (StringUtil.isNullOrEmpty((String)connectorId)) {
            throw new BadRequestException("Undefined connectorId", "invalidValue");
        }
        try {
            connector = this.connectorService.getConnectorByUniqueId(connectorId).getConnector();
        }
        catch (ConnectorNotFoundException e) {
            throw new BadRequestException("Unknown connectorId", "invalidValue");
        }
        catch (ConnectorFactoryNotAvailableException e) {
            throw new ServerErrorException("Connector factory not available", null, (Throwable)e);
        }
        catch (ConfigurationFailedException e) {
            throw new ServerErrorException("Unable to load connector configuration", null, (Throwable)e);
        }
        if (connector instanceof ScimConnector) {
            return (ScimConnector)connector;
        }
        throw new BadRequestException("Connector is of type " + connector.getTypeDisplayName() + ", but " + "SCIM 2.0" + " was expected.", "invalidValue");
    }
}

