/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import com.resolution.samlwrapper.api.exception.SAMLWrapperException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class MetaDataServlet
extends BasicServlet {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataServlet.class);
    private static final long serialVersionUID = 1935293655352567609L;

    @Autowired
    public MetaDataServlet(SamlSsoService samlSsoComponent, @ComponentImport TemplateRenderer renderer) {
        super(samlSsoComponent, renderer);
    }

    private int parseIdpId(HttpServletRequest request) {
        String idpIdParameter = request.getParameter("idp");
        if (idpIdParameter != null && !idpIdParameter.trim().isEmpty()) {
            try {
                return Integer.parseInt(idpIdParameter);
            }
            catch (NumberFormatException e) {
                logger.warn("Could not parse IdP-parameter {}, using {}", (Object)idpIdParameter, (Object)-1);
            }
        }
        return -1;
    }

    @Override
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            int idpId = this.parseIdpId(request);
            String responseString = this.samlSsoService.generateSamlMetadata(idpId);
            response.setStatus(200);
            response.setContentType("text/xml;charset=utf-8");
            response.getWriter().write(responseString);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (SAMLWrapperException e) {
            logger.error("Generating Metadata failed", (Throwable)e);
            this.sendError(response, null, e.getMessage(), e);
        }
    }
}

