/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.metadata.reload;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.SamlIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.metadata.MetadataIntoConfigurationMerger;
import com.resolution.atlasplugins.samlsso.configuration.metadata.MultiIdPMetadataMergeResult;
import com.resolution.atlasplugins.samlsso.configuration.metadata.MultiMetadataStatus;
import com.resolution.samlwrapper.api.IdPMetadata;
import com.resolution.samlwrapper.api.SAMLWrapper;
import com.resolution.samlwrapper.api.exception.MetadataException;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.validate.api.ValidationResult;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReloadMetadataJobRunner
implements JobRunner,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ReloadMetadataJobRunner.class);
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)ReloadMetadataJobRunner.class.getCanonicalName());
    private final RunningConfiguration pluginConfiguration;
    private final SAMLWrapper samlWrapper;
    private final SchedulerService schedulerService;
    private final MetadataIntoConfigurationMerger metadataIntoConfigurationMerger;

    @Autowired
    public ReloadMetadataJobRunner(@ComponentImport SchedulerService schedulerService, RunningConfiguration pluginConfiguration, SAMLWrapper samlWrapper, MetadataIntoConfigurationMerger metadataIntoConfigurationMerger) {
        this.pluginConfiguration = pluginConfiguration;
        this.samlWrapper = samlWrapper;
        this.metadataIntoConfigurationMerger = metadataIntoConfigurationMerger;
        this.schedulerService = schedulerService;
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        logger.info("Created and registered ReloadMetadataJobRunner");
    }

    public void destroy() {
        logger.debug("Unregistering {} from JobRunner", (Object)JOB_RUNNER_KEY);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        logger.debug("Starting metadata reload");
        this.updateMetadata();
        return JobRunnerResponse.success();
    }

    public void updateMetadata() {
        ConfigurationData currentConfigurationData;
        boolean fetchedMetadataFromAtLeastOneIdP = false;
        ConfigurationData configurationData = this.pluginConfiguration.getConfigurationData();
        for (CommonIdpConfigurationData idpConfig : configurationData.idpConfigurations) {
            if (idpConfig instanceof SamlIdpConfigurationData) {
                logger.debug("Checking metadata for SAML IdP {}", (Object)idpConfig.id);
                fetchedMetadataFromAtLeastOneIdP = this.reloadSamlMetadata((SamlIdpConfigurationData)idpConfig) || fetchedMetadataFromAtLeastOneIdP;
                continue;
            }
            logger.debug("Skipping metadata reload for non-SAML IdP {}", (Object)idpConfig.id);
        }
        if (fetchedMetadataFromAtLeastOneIdP) {
            logger.debug("Metadata was fetched, storing configuration");
            this.pluginConfiguration.update(configurationData);
        } else {
            logger.debug("No metadata fetch happened, no need to store config");
        }
        try {
            MultiIdPMetadataMergeResult mergeResult = this.reloadCommonMetadata(configurationData);
            if (mergeResult.isChanged()) {
                logger.warn("\n=================================================\nCommon IdP Metadata has changed:\nAdded IdPs:   {}\nChanged IdPs: {}\nRemoved IdPs: {}\n=================================================", new Object[]{mergeResult.getAddedIds(), mergeResult.getChangedIds(), mergeResult.getRemovedIds()});
            } else {
                logger.info("Common IdP Metadata is not changed");
            }
            if (mergeResult.getValidationResult().isValid()) {
                ConfigurationData changedConfig = mergeResult.getConfigurationData();
                changedConfig.multiMetadataStatus = new MultiMetadataStatus(mergeResult);
                this.pluginConfiguration.update(changedConfig);
            } else {
                currentConfigurationData = this.pluginConfiguration.getConfigurationData();
                currentConfigurationData.multiMetadataStatus = new MultiMetadataStatus(mergeResult);
                this.pluginConfiguration.update(currentConfigurationData);
            }
        }
        catch (MetadataException e) {
            logger.warn("Failed to load common metadata", (Throwable)e);
            currentConfigurationData = this.pluginConfiguration.getConfigurationData();
            MultiIdPMetadataMergeResult failedResult = new MultiIdPMetadataMergeResult(false, currentConfigurationData, ValidationResult.create(), "Failed to load Metadata: " + e.getMessage(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            currentConfigurationData.multiMetadataStatus = new MultiMetadataStatus(failedResult);
            this.pluginConfiguration.update(currentConfigurationData);
        }
    }

    private MultiIdPMetadataMergeResult reloadCommonMetadata(@Nonnull ConfigurationData configurationData) throws MetadataException {
        if (!configurationData.commonMetadataAutoReload) {
            return MultiIdPMetadataMergeResult.createdUnchanged(configurationData, "Common Metadata Reloading is not enabled");
        }
        if (StringUtil.isNullOrEmpty((String)configurationData.commonMetadataUrl)) {
            return MultiIdPMetadataMergeResult.createdUnchanged(configurationData, "Common Metadata URL is not set");
        }
        Collection metadataCollection = this.samlWrapper.readMultipleIdPMetadata(configurationData.commonMetadataUrl, false, configurationData.commonMetadataCertificate, configurationData.commonMetadataIdpsToSkip);
        return this.metadataIntoConfigurationMerger.mergeMultiIdpMetadata(configurationData, metadataCollection);
    }

    private boolean reloadSamlMetadata(SamlIdpConfigurationData samlConfig) {
        boolean fetched;
        block5: {
            fetched = false;
            if (samlConfig.metadataurl != null && !samlConfig.metadataurl.isEmpty() && !samlConfig.useMetadataxml && samlConfig.autoReloadMetadata) {
                fetched = true;
                try {
                    logger.debug("Checking metadata for IdP {} {} for updates on URL {}", new Object[]{samlConfig.id, samlConfig.name, samlConfig.metadataurl});
                    samlConfig.lastMetadataReload = System.currentTimeMillis();
                    IdPMetadata idPMetadata = this.samlWrapper.readIdPMetadata(samlConfig.metadataurl, samlConfig.metadataignorecert, samlConfig.metadataSignatureCertificate);
                    boolean hasChanged = this.metadataIntoConfigurationMerger.mergeIdpMetadata(samlConfig, idPMetadata);
                    if (hasChanged) {
                        samlConfig.metadataReloadStatus = SamlIdpConfigurationData.MetadataReloadStatus.UPDATED;
                        break block5;
                    }
                    samlConfig.metadataReloadStatus = SamlIdpConfigurationData.MetadataReloadStatus.ACTUAL;
                }
                catch (MetadataException e) {
                    logger.error("Reloading metadata for IdP {} {} failed", new Object[]{samlConfig.id, samlConfig.name, e});
                    samlConfig.metadataReloadStatus = SamlIdpConfigurationData.MetadataReloadStatus.FAILED;
                }
            } else {
                logger.debug("Metadata reloading is not enabled for IdP {} {}", (Object)samlConfig.id, (Object)samlConfig.name);
            }
        }
        return fetched;
    }
}

