/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bamboo;

import com.atlassian.bamboo.event.EmailEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.Email;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.resolution.atlasplugins.samlsso.SendEmailService;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent
public class BambooSendEmailServiceImpl
implements SendEmailService {
    private static final Logger logger = LoggerFactory.getLogger(BambooSendEmailServiceImpl.class);
    private final RunningConfiguration pluginConfiguration;
    private final EventPublisher eventPublisher;

    @Autowired
    public BambooSendEmailServiceImpl(@BambooImport EventPublisher eventPublisher, RunningConfiguration pluginConfiguration) {
        this.eventPublisher = eventPublisher;
        this.pluginConfiguration = pluginConfiguration;
    }

    @Override
    public void sendEmail(String address, String subject, String body) {
        if (this.pluginConfiguration.getAllowedNotificationEmailAddresses().contains(address)) {
            Email email = new Email(address);
            email.setBody(body);
            email.setSubject(subject);
            this.eventPublisher.publish((Object)new EmailEvent((Object)this, email));
        } else {
            logger.warn("{} is not in the list of allowed addresses, not sending", (Object)address);
        }
    }
}

