/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.SingleLogoutServiceException;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2RunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.samlwrapper.api.LogoutHandler;
import com.resolution.samlwrapper.api.SAMLWrapper;
import com.resolution.samlwrapper.api.exception.LogoutHandlerException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class SingleLogoutService {
    private final SAMLWrapper samlWrapper;
    private final AuthenticationTrackerRepository trackerRepository;
    private static final Logger logger = LoggerFactory.getLogger(SingleLogoutService.class);
    private final LogoutHandler logoutHandler;
    private final SamlSsoService samlSsoService;

    @Autowired
    public SingleLogoutService(SAMLWrapper samlWrapper, AuthenticationTrackerRepository authenticationTrackerRepository, LogoutHandler logoutHandler, SamlSsoService samlSsoService) {
        this.samlWrapper = samlWrapper;
        this.trackerRepository = authenticationTrackerRepository;
        this.logoutHandler = logoutHandler;
        this.samlSsoService = samlSsoService;
    }

    public void doSingleLogout(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp) throws SingleLogoutServiceException {
        AuthenticationTracker tracker = this.getTrackerFromRequest(req).orElseThrow(() -> new SingleLogoutServiceException("No user session present"));
        if (tracker.getProtocolType().equals("OAU2") || tracker.getProtocolType().equals("OIDC")) {
            try {
                this.handleOidcAndOauthLogout(req, resp, tracker);
            }
            catch (LogoutHandlerException | IOException | ServletException e) {
                throw new SingleLogoutServiceException((Exception)e);
            }
        }
        try {
            this.samlWrapper.initiateSingleLogout(req, resp, this.logoutHandler, (SAMLAuthenticationTracker)tracker);
        }
        catch (Exception e) {
            throw new SingleLogoutServiceException(e);
        }
    }

    public void doServiceManagementSingleLogout(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp, @Nonnull LogoutHandler logoutHandler, @Nonnull AuthenticationTracker tracker, @Nonnull String sessionIndex, @Nonnull String nameId, @Nonnull String idpId) throws SingleLogoutServiceException {
        if (tracker.getProtocolType().equals("OAU2") || tracker.getProtocolType().equals("OIDC")) {
            try {
                this.handleOidcAndOauthLogout(req, resp, tracker);
            }
            catch (LogoutHandlerException | IOException | ServletException e) {
                throw new SingleLogoutServiceException((Exception)e);
            }
        }
        try {
            this.samlWrapper.initiateSingleLogout(req, resp, logoutHandler, (SAMLAuthenticationTracker)tracker, sessionIndex, nameId, idpId);
        }
        catch (Exception e) {
            throw new SingleLogoutServiceException(e);
        }
    }

    @Nonnull
    private Optional<AuthenticationTracker> getTrackerFromRequest(@Nonnull HttpServletRequest req) {
        AuthenticationTracker tracker;
        HttpSession session = req.getSession(false);
        if (session == null) {
            return Optional.empty();
        }
        Object trackerObject = session.getAttribute("tracker");
        if (trackerObject == null) {
            tracker = (AuthenticationTracker)this.trackerRepository.create();
            tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "No tracker found in session, created a new one", new Object[0]);
        } else if (trackerObject instanceof String) {
            String trackerId = (String)trackerObject;
            tracker = (AuthenticationTracker)this.trackerRepository.get(trackerId, true);
        } else if (trackerObject instanceof AuthenticationTracker) {
            tracker = (AuthenticationTracker)trackerObject;
            tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Found AuthenticationTracker-Object in session", new Object[0]);
        } else {
            tracker = (AuthenticationTracker)this.trackerRepository.create();
            tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Tracker in session has unexpected class {}, created a new one", new Object[]{trackerObject.getClass().getCanonicalName()});
        }
        return Optional.of(tracker);
    }

    private void handleOidcAndOauthLogout(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp, @Nonnull AuthenticationTracker tracker) throws LogoutHandlerException, IOException, ServletException {
        this.logoutHandler.logout(req, resp, (SAMLAuthenticationTracker)tracker);
        OAuth2RunningIdpConfiguration config = (OAuth2RunningIdpConfiguration)this.samlSsoService.getRunningConfiguration().getRunningIdpConfiguration(tracker.getClientId());
        if (config == null) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Cannot load idpConfiguration", new Object[0]);
            return;
        }
        if (config.isSingleLoutoutEnabled()) {
            HttpUrl url = HttpUrl.parse((String)config.getEndSessionEndpoint());
            if (url == null) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "SLO url is not valid", new Object[0]);
                return;
            }
            HttpUrl.Builder builder = url.newBuilder();
            if (tracker.getIdToken() != null) {
                builder.addQueryParameter("id_token_hint", tracker.getIdToken());
            }
            String redirectTarget = builder.build().toString();
            tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Single Log Out will be performed, redirecting to {}", new Object[]{redirectTarget});
            resp.sendRedirect(redirectTarget);
        } else {
            this.logoutHandler.showLoggedOutPage(req, resp, (SAMLAuthenticationTracker)tracker);
        }
    }
}

