function createPresetsForLinchpin(attributesFromLinchpin, attributeMappingOptions, displayNames) {

    if (attributesFromLinchpin === null || _.isEmpty(attributesFromLinchpin)) {
        console.error("The input from linchpin is not as expected. See ", attributesFromLinchpin)
        return {attributeMappingOptions: attributeMappingOptions, displayNames: displayNames};
    }

    if (attributeMappingOptions === null || displayNames === null) {
        console.error("This function is not called correctly.")
        return {attributeMappingOptions: attributeMappingOptions, displayNames: displayNames};
    }

    const idpAttributesFromLinchpin = attributesFromLinchpin.filter(function (i) {
        return i.hasOwnProperty("idpField") && i.idpField === true && i.hasOwnProperty("userFieldBK") && i.hasOwnProperty("labelPropertyKey");
    });

    if (idpAttributesFromLinchpin.length === 0) {
        return {attributeMappingOptions: attributeMappingOptions, displayNames: displayNames};
    }

    let options = [];

    idpAttributesFromLinchpin.forEach(function (attr) {
        const name = attr.userFieldBK;
        const label = attr.labelPropertyKey + " (" + name + ")";
        const type = "LINCHPIN"


        const value = {
            type: type,
            name: name
        }
        options.push({label: label, value: value})
        displayNames[value.name] = label
    })

    let linchpinMapping = {
        groupLabel: "Linchpin",
        options: options
    };

    // check if linchpin preset already exist

    if (attributeMappingOptions.some(function (element) {
        return element.groupLabel === "Linchpin"
    })) {
        // if array already contains a linchpin mapping, replace it completely
        const index = _.findIndex(attributeMappingOptions, function (e) {
            return e.groupLabel === "Linchpin"
        })

        if (index === -1) {
            console.error("Something went horribly wrong. There should be a linchpin group, but cannot find the index")
            attributeMappingOptions.push(linchpinMapping);
        } else {
            // replace the old linchpins with the new ones
            attributeMappingOptions[index] = linchpinMapping;
        }

    } else {
        // there is no linchpin group
        attributeMappingOptions.push(linchpinMapping);
    }

    return {attributeMappingOptions: attributeMappingOptions, displayNames: displayNames};
}
