/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.atlasuser.api.AtlasUserStatusObject;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.DirectoryNotFoundException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserFunction;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.AttributeIndex;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.task.api.Task;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.api.AttributeTransformationResult;
import de.resolution.retransform.api.AttributeTransformer;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.AttributeTransformationConfigTranslator;
import de.resolution.retransform.frontend.ResourceLoader;
import de.resolution.retransform.frontend.TargetTypeMap;
import de.resolution.usersync.api.ConnectorGroup;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.IdentifierForSingleUserSync;
import de.resolution.usersync.api.RequiredGroupChecker;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncSingleUserResult;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.SyncUserResult;
import de.resolution.usersync.api.TransformationResults;
import de.resolution.usersync.api.cleanup.CleanupBehaviour;
import de.resolution.usersync.api.cleanup.CleanupDecider;
import de.resolution.usersync.api.cleanup.CleanupFunction;
import de.resolution.usersync.api.cleanup.GroovyCleanupDecider;
import de.resolution.usersync.api.cleanup.TimestampBasedCleanupDecider;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.GeneralSyncException;
import de.resolution.usersync.api.exception.SyncCanceledException;
import de.resolution.usersync.api.exception.UserFindFailedException;
import de.resolution.usersync.impl.requiredgroups.LocalRequiredGroupChecker;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerHolder;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import de.resolution.usersync.util.MemoryInfo;
import de.resolution.usersync.util.UserSyncUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnector<T extends ConnectorConfiguration>
implements Connector<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnector.class);
    private final long lastUpdated;
    @Nonnull
    protected final T configuration;
    @Nonnull
    protected final ConnectorService connectorService;
    @Nonnull
    protected final AtlasUserAdapter atlasUserAdapter;
    protected final Map<String, AttributeTransformer> attributeTransformerMap;
    protected final AttributeTransformer disableNotFoundUserAttributeTransformer;
    private final TargetTypeMap attributeMappingTemplates;
    private final boolean newConnector;
    private final CleanupDecider cleanupDecider;
    @Nonnull
    private final RequiredGroupCheckerHolder requiredGroupCheckerHolder;

    protected AbstractConnector(@Nonnull ConnectorService connectorService, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull T configuration, boolean newConnector, long lastUpdated, @Nullable String pathToAttributeMappingTemplate) throws ConfigurationFailedException {
        this.lastUpdated = lastUpdated;
        this.connectorService = connectorService;
        this.atlasUserAdapter = atlasUserAdapter;
        this.configuration = configuration;
        this.newConnector = newConnector;
        this.attributeTransformerMap = this.createAttributeTransformerMap(true, true, true);
        if (pathToAttributeMappingTemplate == null) {
            this.attributeMappingTemplates = new TargetTypeMap();
        } else {
            try {
                String json = ResourceLoader.load(pathToAttributeMappingTemplate);
                this.attributeMappingTemplates = (TargetTypeMap)new ObjectMapper().readValue(json, TargetTypeMap.class);
            }
            catch (IOException e) {
                throw new ResourceLoader.LoadingFailedException("Loading AttributeMappingTemplates from file " + pathToAttributeMappingTemplate + " failed", e);
            }
        }
        this.disableNotFoundUserAttributeTransformer = AttributeTransformationConfigTranslator.translate((AttributeTransformationConfig)configuration.getDisableNotFoundLookupTransformation(), (boolean)false, null);
        if (configuration.isUseGroovyCleanupDecider()) {
            try {
                this.cleanupDecider = new GroovyCleanupDecider(configuration.getGroovyCleanupDeciderCode());
            }
            catch (GroovyCleanupDecider.GroovyScriptException e) {
                throw new ConfigurationFailedException("Failed to create GroovyCleanupDecider", e);
            }
        } else {
            this.cleanupDecider = new TimestampBasedCleanupDecider();
        }
        this.requiredGroupCheckerHolder = RequiredGroupChecker.create(this.configuration);
    }

    protected Map<String, AttributeTransformer> createAttributeTransformerMap(boolean considerStaticValues, boolean considerWhitelist, boolean considerBlacklist) {
        HashMap<String, List<String>> dropWithoutMatch = new HashMap<String, List<String>>();
        if (!this.configuration.getRequiredGroups().isEmpty()) {
            dropWithoutMatch.put("ATTR_GROUPS", this.configuration.getRequiredGroups());
        }
        HashMap<String, List<String>> whitelists = new HashMap<String, List<String>>();
        if (!this.configuration.getGroupsToAssignFilter().isEmpty()) {
            whitelists.put("ATTR_GROUPS", this.configuration.getGroupsToAssignFilter());
        }
        HashMap<String, List<String>> blacklists = new HashMap<String, List<String>>();
        if (!this.configuration.getGroupsToAssignNever().isEmpty()) {
            blacklists.put("ATTR_GROUPS", this.configuration.getGroupsToAssignNever());
        }
        HashMap<String, List<String>> constantValues = new HashMap<String, List<String>>();
        if (!this.configuration.getGroupsToAssignAlways().isEmpty()) {
            constantValues.put("ATTR_GROUPS", this.configuration.getGroupsToAssignAlways());
        }
        if (!this.configuration.getGroupsToKeep().isEmpty()) {
            constantValues.put("ATTR_GROUPS_TO_KEEP", this.configuration.getGroupsToKeep());
        }
        return new AttributeTransformationConfigTranslator(this.configuration.getAttributeTransformationConfigs()).withProfilePrefix(this.connectorService.getApplicationPrefix()).withDefaultTopLevelKey("con").withDropAllIfValuesDontMatchAnyOfThese(dropWithoutMatch).withRemoveValuesNotMatchingAnyOfThese((Map)(considerWhitelist ? whitelists : new HashMap<String, List<String>>())).withRemoveValuesMatchingAnyOfThese((Map)(considerBlacklist ? blacklists : new HashMap<String, List<String>>())).withAddTheseStaticValues((Map)(considerStaticValues ? constantValues : new HashMap<String, List<String>>())).withHandleValuesAsExpressions(true).withAtlasUserAdapter(this.atlasUserAdapter).translate();
    }

    protected abstract void doSync(@Nonnull SyncFunction var1, @Nonnull SyncStatusFacade var2);

    protected void trackMemoryUsage(@Nonnull SyncStatus syncStatus, @Nullable String message) {
        if (this.configuration.isTrackMemoryUsage()) {
            if (message != null) {
                syncStatus.addMessage(MemoryInfo.asString() + " " + message);
            } else {
                syncStatus.addMessage(MemoryInfo.asString());
            }
        }
    }

    protected void trackMemoryUsage(@Nonnull SyncStatusFacade syncStatusFacade, @Nullable String message) {
        SyncStatus syncStatus = syncStatusFacade.getSyncStatus();
        if (syncStatus != null) {
            this.trackMemoryUsage(syncStatusFacade.getSyncStatus(), message);
        }
    }

    @Nonnull
    public AttributeTransformationResult transformLookupAttribute(@Nullable Map<String, ?> connectorAttributes, @Nullable Map<String, ?> auxAttributes, @Nonnull String findByAttributeName) throws TransformationFailedException {
        if (this.isApplyTransformations()) {
            AttributeTransformer findByAttributeTransformer = this.attributeTransformerMap.get(findByAttributeName);
            if (findByAttributeTransformer == null) {
                throw new TransformationFailedException("No AttributeTransformer found for lookup-attribute " + findByAttributeName);
            }
            MapStructuredData attributesForLookup = StructuredData.create();
            attributesForLookup.put((Object)"con", connectorAttributes);
            attributesForLookup.put((Object)"saml", auxAttributes);
            return findByAttributeTransformer.transform((StructuredData)attributesForLookup);
        }
        return TransformationResults.createPasstrough(connectorAttributes, auxAttributes, findByAttributeName);
    }

    @Nonnull
    public TransformationResults applyTransformations(@Nullable Map<String, ?> connectorAttributes, @Nullable Map<String, ?> auxAttributes, @Nullable Map<String, ?> existingAttributes) throws TransformationFailedException {
        return this.applyTransformations(connectorAttributes, auxAttributes, existingAttributes, this.attributeTransformerMap);
    }

    @Nonnull
    public TransformationResults applyTransformations(@Nullable Map<String, ?> connectorAttributes, @Nullable Map<String, ?> auxAttributes, @Nullable Map<String, ?> existingAttributes, @Nonnull Map<String, AttributeTransformer> attributeTransformerMap) throws TransformationFailedException {
        MapStructuredData attributes = StructuredData.create();
        if (connectorAttributes != null) {
            attributes.put((Object)"con", connectorAttributes);
        }
        if (auxAttributes != null) {
            attributes.put((Object)"saml", auxAttributes);
        }
        if (existingAttributes != null) {
            attributes.put((Object)"existing", existingAttributes);
        }
        HashMap<String, AttributeTransformationResult> transformationResults = new HashMap<String, AttributeTransformationResult>();
        HashMap<String, List<String>> transformedAttributes = new HashMap<String, List<String>>();
        for (Map.Entry<String, AttributeTransformer> transformationEntry : attributeTransformerMap.entrySet()) {
            try {
                AttributeTransformationResult transformerResult = transformationEntry.getValue().transform((StructuredData)attributes);
                transformationResults.put(transformationEntry.getKey(), transformerResult);
                if (transformerResult.isDropAll()) {
                    return TransformationResults.create(transformationResults);
                }
                if (transformerResult.isDrop()) continue;
                List resultList = transformerResult.getValues();
                transformedAttributes.put(transformationEntry.getKey(), resultList);
            }
            catch (TransformationFailedException e) {
                throw new TransformationFailedException(transformationEntry.getKey() + ": " + e.getMessage());
            }
        }
        return TransformationResults.create(transformationResults, transformedAttributes);
    }

    @Override
    public void sync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatus syncStatus) {
        syncStatus.setStatus(Task.Status.RUNNING);
        syncStatus.setSyncStatusResult(SyncStatus.Result.PENDING);
        if (!this.configuration.isSyncEnabled()) {
            syncStatus.addMessage("Sync is disabled in connector configuration.");
            syncStatus.setStatus(Task.Status.DONE);
            syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
            return;
        }
        this.trackMemoryUsage(syncStatus, "starting sync");
        syncStatus.setStatusMessage("Building index...");
        try {
            syncFunction.buildIndex();
            if (syncStatus.getStatus() == Task.Status.CANCELLING) {
                syncStatus.addMessage("Building index was cancelled.");
                syncStatus.setStatus(Task.Status.CANCELLED);
                return;
            }
        }
        catch (Exception e) {
            syncStatus.setStatus(Task.Status.DONE);
            syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
            logger.error("Building index failed", (Throwable)e);
            syncStatus.addMessage(e.getClass().getCanonicalName() + ": " + e.getMessage());
            return;
        }
        this.trackMemoryUsage(syncStatus, "after building index");
        long startTime = new Date().getTime();
        try {
            this.doSync(syncFunction, syncStatus.facade());
        }
        catch (SyncCanceledException e) {
            syncStatus.addMessage(e.getMessage());
            syncStatus.setStatus(e.getStatus());
            return;
        }
        this.trackMemoryUsage(syncStatus, "After updating users");
        syncStatus.addMessage("Sync in connector took " + (new Date().getTime() - startTime) + " milliseconds.");
        if (syncStatus.getStatus() == Task.Status.CANCELLING) {
            syncStatus.addMessage("Cancelling was requested, skipping cleanup.");
            syncStatus.setStatus(Task.Status.CANCELLED);
            return;
        }
        if (syncStatus.getStatus() == Task.Status.CANCELLED) {
            syncStatus.addMessage("Sync was cancelled, skipping cleanup.");
            return;
        }
        if (syncStatus.getSyncStatusResult() == SyncStatus.Result.FAILED) {
            syncStatus.addMessage("Sync result is FAILED, skipping cleanup.");
        } else {
            block15: {
                long cleanupStartTime = new Date().getTime();
                if (this.configuration.getCleanupBehaviour() == CleanupBehaviour.NONE && !this.configuration.isRemoveAllGroupAssignmentsOnCleanup()) {
                    syncStatus.addMessage("Cleanup is disabled");
                } else {
                    CleanupFunction cleanupFunction = new CleanupFunction(syncFunction.getTimestamp(), this.configuration.getCleanupBehaviour(), this.getCleanupDecider(), syncFunction.getAtlasUserAdapter(), Collections.emptyList(), this.configuration.isRemoveAllGroupAssignmentsOnCleanup(), this.configuration.getGroupsOrRegexNotBeRemoved(), this.configuration.getSlowdownDelayInMs());
                    try {
                        this.atlasUserAdapter.applyToAll(this.configuration.getDirectoryId(), (AtlasUserFunction)cleanupFunction, (AtlasUserStatusObject)syncStatus, syncStatus.isSimulate());
                        syncStatus.addMessage("Cleanup took " + (new Date().getTime() - cleanupStartTime) + " milliseconds.");
                        this.trackMemoryUsage(syncStatus, "after cleanup");
                    }
                    catch (AtlasUserOperationFailedException | DirectoryNotFoundException e) {
                        syncStatus.addMessage("Cleanup failed: " + e.getMessage());
                        logger.error("Cleanup failed", e);
                        if (syncStatus.getSyncStatusResult() == SyncStatus.Result.FAILED) break block15;
                        syncStatus.setSyncStatusResult(SyncStatus.Result.PARTIALLY_FAILED);
                    }
                }
            }
            if (syncStatus.getSyncStatusResult() != SyncStatus.Result.FAILED && syncStatus.getSyncStatusResult() != SyncStatus.Result.PARTIALLY_FAILED) {
                syncStatus.setSyncStatusResult(SyncStatus.Result.SUCCESS);
            }
            syncStatus.setStatus(Task.Status.DONE);
        }
        syncFunction.getLinchpinEventSender().sendSyncHappenedEvent(syncStatus, this);
        syncStatus.setStatusMessage("");
        this.trackMemoryUsage(syncStatus, "after sync");
    }

    @Nonnull
    protected abstract FindUserResult findUser(@Nonnull String var1, @Nullable MapStructuredData var2);

    @Override
    @Nullable
    public MapStructuredData loadUserAttributesFromBackend(@Nonnull String identifier, MapStructuredData additionalData) throws TransformationFailedException, UserFindFailedException {
        FindUserResult findUserResult = this.findUser(identifier, additionalData);
        if (findUserResult.getStatus() != SyncSingleUserResult.Status.FOUND) {
            return null;
        }
        MapStructuredData existingUserAttributes = this.loadExistingUserAttributes(findUserResult.getAttributesFromConnector().asMap(), additionalData, null, this.configuration.getFindByAttributeName());
        MapStructuredData ret = StructuredData.create();
        ret.put("con", findUserResult.getAttributesFromConnector());
        ret.put((Object)"saml", Collections.emptyMap());
        ret.put("existing", (StructuredData)existingUserAttributes);
        return ret;
    }

    @Override
    @Nonnull
    public SyncSingleUserResult syncSingleUser(@Nonnull String identifier, @Nullable MapStructuredData auxData, @Nullable Map<String, Set<String>> attributesToOverride, @Nullable String overridingPrimaryAttribute, boolean simulate) {
        FindUserResult findUserResult = this.findUser(identifier, auxData);
        if (logger.isDebugEnabled()) {
            logger.debug("FindUserResult: {}", (Object)JSONUtil.asJson((Object)findUserResult));
        }
        if (findUserResult.getStatus() == SyncSingleUserResult.Status.NOT_FOUND) {
            return this.disableNotFoundUser(identifier, auxData, simulate);
        }
        if (findUserResult.getStatus() == SyncSingleUserResult.Status.NOT_UNIQUE) {
            return SyncSingleUserResult.createNotUnique();
        }
        if (findUserResult.getStatus() == SyncSingleUserResult.Status.FAILED) {
            return SyncSingleUserResult.createFailure(findUserResult.getException());
        }
        String findByAttributeName = overridingPrimaryAttribute;
        if (overridingPrimaryAttribute == null) {
            findByAttributeName = this.configuration.getFindByAttributeName();
        } else {
            logger.debug("Overriding primary attribute with {}", (Object)findByAttributeName);
        }
        if (findUserResult.getStatus() == SyncSingleUserResult.Status.PREFILTERED) {
            try {
                logger.debug("User is prefiltered by the connector, disabling user if existing...");
                StructuredData userData = findUserResult.getAttributesFromConnector();
                MapStructuredData existingUser = this.loadExistingUserAttributes(userData.asMap(), null, null, findByAttributeName);
                if (existingUser != null) {
                    StructuredData findByValueData = existingUser.get((Object)findByAttributeName);
                    if (findByValueData != null && !findByValueData.asList().isEmpty()) {
                        String findByValue = Objects.requireNonNull(findByValueData.asList().first()).asString();
                        logger.debug("Disabling found user {}:{}", (Object)findByAttributeName, (Object)findByValue);
                        AtlasUserResult disableResult = this.disableUser(findByValue, simulate);
                        return SyncSingleUserResult.createPreFiltered(userData.asMap(), disableResult);
                    }
                    return SyncSingleUserResult.createPreFiltered(userData.asMap());
                }
                return SyncSingleUserResult.createPreFiltered(findUserResult.getAttributesFromConnector().asMap());
            }
            catch (TransformationFailedException | UserFindFailedException e) {
                return SyncSingleUserResult.createFailure((Exception)e);
            }
        }
        try {
            long timestamp = System.currentTimeMillis();
            SyncUserResult syncUserResult = this.syncUser(findUserResult.getAttributesFromConnector().asMap(), auxData, null, attributesToOverride, findByAttributeName, timestamp, false, simulate);
            if (syncUserResult.getOperation() == AtlasUserResult.Operation.FILTERED) {
                MapStructuredData existingUser = this.loadExistingUserAttributes(findUserResult.getAttributesFromConnector().asMap(), null, null, findByAttributeName);
                if (existingUser == null) {
                    return SyncSingleUserResult.createFiltered(Collections.emptyMap(), syncUserResult.getTransformationResults());
                }
                StructuredData findByValueData = existingUser.get((Object)findByAttributeName);
                if (findByValueData != null && !findByValueData.asList().isEmpty()) {
                    String findByValue = Objects.requireNonNull(findByValueData.asList().first()).asString();
                    logger.debug("Disabling found user {}:{}", (Object)findByAttributeName, (Object)findByValue);
                    AtlasUserResult disableResult = this.disableUser(findByValue, simulate);
                    return SyncSingleUserResult.createFiltered(Collections.emptyMap(), disableResult, syncUserResult.getTransformationResults());
                }
                return SyncSingleUserResult.createFiltered(Collections.emptyMap(), syncUserResult.getTransformationResults());
            }
            return SyncSingleUserResult.createFoundOrFailed(findUserResult, syncUserResult);
        }
        catch (TransformationFailedException e) {
            return SyncSingleUserResult.createFailure("Attribute transformation failed", (Exception)((Object)e));
        }
        catch (UserFindFailedException e) {
            return SyncSingleUserResult.createFailure("Loading user failed", e);
        }
    }

    @Override
    @Nullable
    public String getAuthorizationCodeUrl() {
        return null;
    }

    @Nonnull
    protected SyncSingleUserResult disableNotFoundUser(@Nonnull String identifier, @Nullable MapStructuredData auxData, boolean simulate) {
        if (this.configuration.isDisableNotFoundUser()) {
            MapStructuredData data = StructuredData.create();
            data.put((Object)"identifier", (Object)identifier);
            data.put("aux", (StructuredData)auxData);
            try {
                AttributeTransformationResult transformationResult = this.disableNotFoundUserAttributeTransformer.transform((StructuredData)data);
                if (logger.isDebugEnabled()) {
                    logger.debug("Transformation result for disabling user: {}", (Object)JSONUtil.asJson((Object)transformationResult));
                }
                if (transformationResult.isDrop() || transformationResult.isDropAll() || transformationResult.isEmpty()) {
                    logger.debug("Transformation result for disabling existing user is drop or empty, just returning not found");
                    return SyncSingleUserResult.createNotFound();
                }
                String findByAttributeValue = transformationResult.getFirstValue();
                if (findByAttributeValue == null) {
                    logger.debug("Transforming data or disabling existing user returned null");
                    return SyncSingleUserResult.createNotFound();
                }
                AtlasUserReference reference = AtlasUserReference.create((String)this.configuration.getDisableNotFoundUserLookupAttribute(), (Object)findByAttributeValue, (long)this.configuration.getDirectoryId());
                AtlasUser userToUpdate = AtlasUser.builder().findBy(reference).with("ATTR_ACTIVE", false).build();
                AtlasUserResult disableResult = this.atlasUserAdapter.update(userToUpdate, this.getAttributeTransformerMap().keySet(), simulate);
                return SyncSingleUserResult.createNotFound(disableResult);
            }
            catch (TransformationFailedException e) {
                return SyncSingleUserResult.createNotFound("User was not found by the connector and transforming the data for disabling an existing user failed", (Exception)((Object)e));
            }
        }
        logger.debug("Disabling not-found user is disabled");
        return SyncSingleUserResult.createNotFound();
    }

    @Nullable
    protected MapStructuredData loadExistingUserAttributes(@Nullable MapStructuredData connectorAttributes, @Nullable MapStructuredData auxAttributes, @Nullable AttributeIndex attributeIndex, @Nonnull String findByAttributeName) throws TransformationFailedException, UserFindFailedException {
        logger.debug("Loading existing user by attribute {}", (Object)findByAttributeName);
        AttributeTransformationResult lookupAttributeTransformationResult = this.transformLookupAttribute((Map<String, ?>)connectorAttributes, (Map<String, ?>)auxAttributes, findByAttributeName);
        String findByAttributeValue = lookupAttributeTransformationResult.getFirstValue();
        if (findByAttributeValue == null) {
            throw new TransformationFailedException("Transformation for " + findByAttributeName + " returned no value");
        }
        if (lookupAttributeTransformationResult.isDrop()) {
            throw new UserFindFailedException("Lookup attribute must not be dropped during transformation");
        }
        if (lookupAttributeTransformationResult.isDropAll()) {
            throw new UserFindFailedException("Lookup attribute transformation returned dropAll");
        }
        AtlasUserReference reference = AtlasUserReference.create((String)findByAttributeName, (Object)findByAttributeValue, (long)this.configuration.getDirectoryId());
        AtlasUserResult readResult = this.atlasUserAdapter.readFirstUniqueUser(reference, attributeIndex, this.getAttributeTransformerMap().keySet());
        Optional userOpt = readResult.getResultingUser();
        if (userOpt.isPresent()) {
            return StructuredData.create((Map)((AtlasUser)userOpt.get()).getAttributes()).asMap();
        }
        if (readResult.isNotFound()) {
            return StructuredData.create();
        }
        throw new UserFindFailedException("Loading existing user failed " + JSONUtil.asJson((Object)readResult));
    }

    @Override
    @Nonnull
    public SyncUserResult syncUser(@Nullable MapStructuredData connectorAttributes, @Nullable MapStructuredData auxAttributes, @Nullable AttributeIndex attributeIndex, @Nullable Map<String, ? extends Collection<String>> attributesToOverride, long timestamp, boolean slowdown, boolean simulate) throws TransformationFailedException, UserFindFailedException {
        return this.syncUser(connectorAttributes, auxAttributes, attributeIndex, attributesToOverride, null, timestamp, slowdown, simulate);
    }

    @Override
    @Nonnull
    public SyncUserResult syncUser(@Nullable MapStructuredData connectorAttributes, @Nullable MapStructuredData auxAttributes, @Nullable AttributeIndex attributeIndex, @Nullable Map<String, ? extends Collection<String>> attributesToOverride, @Nullable String overrideFindByAttributeName, long timestamp, boolean slowdown, boolean simulate) throws TransformationFailedException, UserFindFailedException {
        TransformationResults transformationResults;
        String findByAttributeName;
        block14: {
            MapStructuredData existingUserAttributes;
            findByAttributeName = overrideFindByAttributeName;
            if (findByAttributeName == null) {
                findByAttributeName = this.configuration.getFindByAttributeName();
            }
            logger.debug("syncUser(): findByAttributeName is {}", (Object)findByAttributeName);
            try {
                existingUserAttributes = this.loadExistingUserAttributes(connectorAttributes, auxAttributes, attributeIndex, findByAttributeName);
            }
            catch (TransformationFailedException | UserFindFailedException e) {
                if (connectorAttributes != null) {
                    StructuredData untransformedFindByValue = connectorAttributes.get((Object)findByAttributeName);
                    return SyncUserResult.create(null, null, untransformedFindByValue + ": " + e.getMessage());
                }
                return SyncUserResult.create(null, null, "Failed to load existing user attributes: " + e.getMessage());
            }
            if (this.isApplyTransformations()) {
                try {
                    transformationResults = this.applyTransformations((Map<String, ?>)connectorAttributes, (Map<String, ?>)auxAttributes, (Map<String, ?>)existingUserAttributes);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Connector attributes:   {}", (Object)JSONUtil.asJson((Object)connectorAttributes));
                        logger.trace("Transformation results: {}", (Object)JSONUtil.asJson((Object)transformationResults));
                    }
                    if (transformationResults.isDropAll()) {
                        return SyncUserResult.create(transformationResults);
                    }
                    break block14;
                }
                catch (TransformationFailedException e) {
                    String msgPrefix = "";
                    if (connectorAttributes != null) {
                        msgPrefix = findByAttributeName + ": " + connectorAttributes.get((Object)findByAttributeName) + ": ";
                    }
                    return SyncUserResult.create(null, null, msgPrefix + "Transformation failed: " + e.getMessage(), AtlasUserResult.Operation.FAILED);
                }
            }
            transformationResults = TransformationResults.createPassthrough(connectorAttributes, auxAttributes);
        }
        HashMap<String, Collection<String>> userAttributes = new HashMap<String, Collection<String>>(transformationResults.getTransformedAttributes());
        if (attributesToOverride != null) {
            userAttributes.putAll(attributesToOverride);
        }
        try {
            Collection findByValues = (Collection)userAttributes.get(findByAttributeName);
            String findByAttributeValue = (String)findByValues.iterator().next();
            AtlasUser atlasUser = this.createAtlasUser(userAttributes, findByAttributeName, findByAttributeValue);
            AtlasUserResult atlasUserResult = this.atlasUserAdapter.createOrUpdate(atlasUser, this.configuration.getCopyBehaviour(), timestamp, attributeIndex, this.attributeTransformerMap.keySet(), simulate);
            if (slowdown) {
                this.slowdown();
            }
            return SyncUserResult.create(transformationResults, atlasUserResult);
        }
        catch (NullPointerException | NoSuchElementException e) {
            throw new TransformationFailedException("No value available for findByAttribute " + findByAttributeName);
        }
    }

    protected void slowdown() {
        if (this.configuration.getSlowdownDelayInMs() > 0) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Pausing for {} ms to reduce system load", (Object)this.configuration.getSlowdownDelayInMs());
                }
                Thread.sleep(this.configuration.getSlowdownDelayInMs());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected AtlasUser createAtlasUser(@Nonnull Map<String, ? extends Collection<String>> userAttributes, @Nonnull String findByAttributeName, String findByAttributeValue) {
        AtlasUserBuilder atlasUserBuilder = AtlasUser.builder();
        atlasUserBuilder.findBy(findByAttributeName, (Object)findByAttributeValue).in(this.configuration.getDirectoryId());
        userAttributes.forEach((arg_0, arg_1) -> ((AtlasUserBuilder)atlasUserBuilder).with(arg_0, arg_1));
        atlasUserBuilder.with("ATTR_IS_ANONYMIZED", Collections.emptyList());
        return atlasUserBuilder.build();
    }

    public static boolean matchesRequiredConnectorGroups(List<String> requiredGroups, Collection<String> actualGroups) {
        if (logger.isDebugEnabled()) {
            logger.debug("Required groups: {}", (Object)String.join((CharSequence)",", requiredGroups));
            logger.debug("Actual grous: {}", (Object)String.join((CharSequence)",", actualGroups));
        }
        if (requiredGroups.isEmpty()) {
            return true;
        }
        boolean result = requiredGroups.stream().map(Pattern::compile).anyMatch(pattern -> actualGroups.stream().anyMatch(grp -> pattern.matcher((CharSequence)grp).matches()));
        if (result) {
            logger.debug("Required groups matched");
        } else {
            logger.debug("Required groups did not match");
        }
        return result;
    }

    protected boolean matchesLocalRequiredGroupChecker(Collection<ConnectorGroup> connectorGroups) {
        return AbstractConnector.matchesLocalRequiredGroupChecker(connectorGroups, this.getRequiredGroupCheckerHolder());
    }

    protected static boolean matchesLocalRequiredGroupChecker(ConnectorGroup connectorGroup, RequiredGroupCheckerHolder requiredGroupCheckerHolder) {
        return AbstractConnector.matchesLocalRequiredGroupChecker(Collections.singletonList(connectorGroup), requiredGroupCheckerHolder);
    }

    protected static boolean matchesLocalRequiredGroupChecker(Collection<ConnectorGroup> connectorGroups, RequiredGroupCheckerHolder requiredGroupCheckerHolder) {
        Optional<LocalRequiredGroupChecker> localRequiredGroupChecker;
        if (logger.isDebugEnabled()) {
            logger.debug("Actual groups: {}", (Object)JSONUtil.asJson(connectorGroups));
        }
        if (!(localRequiredGroupChecker = requiredGroupCheckerHolder.getLocalRequiredGroupChecker()).isPresent()) {
            return true;
        }
        boolean isRequiredGroup = connectorGroups.stream().anyMatch(connectorGroup -> ((LocalRequiredGroupChecker)localRequiredGroupChecker.get()).isRequiredGroup((ConnectorGroup)connectorGroup));
        if (isRequiredGroup) {
            logger.debug("Required connector groups matched");
        } else {
            logger.debug("Required connector groups did not match");
        }
        return isRequiredGroup;
    }

    @Nonnull
    public AtlasUserResult disableUser(@Nonnull String findByAttributeValue, boolean simulate) {
        AtlasUser atlasUserToDisable;
        AtlasUserResult findResult;
        if (logger.isDebugEnabled()) {
            logger.debug("Disabling user {}:{} in directory {}", new Object[]{this.configuration.getFindByAttributeName(), findByAttributeValue, this.configuration.getDirectoryId()});
        }
        if (UserSyncUtils.checkSuccess(findResult = this.atlasUserAdapter.readFirstUniqueUser((atlasUserToDisable = AtlasUser.builder().findBy(this.configuration.getFindByAttributeName(), (Object)findByAttributeValue).in(this.configuration.getDirectoryId()).with("ATTR_ACTIVE", false).build()).getReference()))) {
            return this.atlasUserAdapter.update(atlasUserToDisable, this.getAttributeTransformerMap().keySet(), simulate);
        }
        return AtlasUserResult.builder((AtlasUserReference)atlasUserToDisable.getReference()).errorType(AtlasUserResult.ErrorType.NOT_FOUND).build();
    }

    @Override
    @Nonnull
    public TargetTypeMap getAttributeMappingTemplates() {
        return this.attributeMappingTemplates;
    }

    @Override
    public long getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    @Nonnull
    public T getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nonnull
    public ConnectorConfiguration getSanitizedConfiguration() {
        return this.configuration.sanitize();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getConfiguration().getName();
    }

    @Override
    @Nonnull
    public String getUniqueId() {
        return this.configuration.getUniqueId();
    }

    @Override
    public boolean isCanSync() {
        return true;
    }

    @Override
    public boolean isCanSyncSingleUser() {
        return true;
    }

    @Override
    public boolean isCanBeScheduled() {
        return true;
    }

    @Override
    public boolean isAllowCustomAttributeMapping() {
        return true;
    }

    @Override
    public boolean isAllowSelectingFindByAttribute() {
        return true;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isCleanupConfigurable() {
        return true;
    }

    @Override
    public boolean isSelectableGroupAttribute() {
        return false;
    }

    @Override
    public boolean isSelectableDirectory() {
        return false;
    }

    @Override
    public boolean isIncludeAllDirectories() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isAllowGroupConfiguration() {
        return true;
    }

    @Override
    public boolean isCanCopyUsers() {
        return true;
    }

    @Override
    @Nonnull
    public String getAttributeNameForSingleUserSearch() {
        return "ATTR_NAME";
    }

    @Override
    public Optional<String> getConnectorStorageValue(String key) {
        return this.connectorService.getConnectorStorageManager().get(this.getUniqueId(), key);
    }

    @Override
    public void setConnectorStorageValue(String key, String value) {
        this.connectorService.getConnectorStorageManager().set(this.getUniqueId(), key, value);
    }

    @Override
    public boolean removeConnectorStorageValue(String key) {
        return this.connectorService.getConnectorStorageManager().remove(this.getUniqueId(), key);
    }

    @Override
    public Map<String, String> getAllConnectorStorageValues() {
        return this.connectorService.getConnectorStorageManager().getAll(this.getUniqueId());
    }

    @Override
    public boolean isApplyTransformations() {
        return true;
    }

    @Override
    public boolean isAuthorizationRequired() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.connectorService.validate(this).isValid();
    }

    @Override
    public boolean isNew() {
        return this.newConnector;
    }

    @Override
    public ValidationResult checkIdentifierForSingleUserSync(IdentifierForSingleUserSync identifier, @Nonnull ValidationResult result) {
        return result;
    }

    @Override
    @Nonnull
    public Map<String, AttributeTransformer> getAttributeTransformerMap() {
        return this.attributeTransformerMap;
    }

    @Override
    public boolean isCanOverrideDefaultConnectTimeoutForOkHttp() {
        return false;
    }

    @Override
    public boolean isCanHaveRequiredGroups() {
        return true;
    }

    @Nullable
    protected String getAttributeValueFromUser(@Nonnull String findByAttributeName, @Nonnull String findByAttributeValue, @Nonnull String attributeName) {
        AtlasUser existingUser;
        Optional attributeValue;
        AtlasUserResult atlasUserResult = this.atlasUserAdapter.readFirstUniqueUser(AtlasUserReference.create((String)findByAttributeName, (Object)findByAttributeValue, (long)this.configuration.getDirectoryId()));
        Optional optionalAtlasUser = atlasUserResult.getResultingUser();
        if (optionalAtlasUser.isPresent() && (attributeValue = (existingUser = (AtlasUser)optionalAtlasUser.get()).get(attributeName)).isPresent()) {
            return (String)attributeValue.get();
        }
        return null;
    }

    @Override
    public boolean isCanFetchRequiredConnectorGroups() {
        return false;
    }

    @Override
    public boolean isCanUseRequiredConnectorGroupsGroovy() {
        return false;
    }

    @Override
    public boolean isCanUseRequiredConnectorGroupsServerFilter() {
        return false;
    }

    @Override
    public Set<ConnectorGroup> fetchRequiredConnectorGroups(@Nonnull RequiredGroupCheckerHolder requiredGroupCheckers, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        logger.warn("This default-implementation for fetchRequiredGroupIds returns an empty set.");
        return Collections.emptySet();
    }

    @Override
    @Nonnull
    public RequiredGroupCheckerHolder getRequiredGroupCheckerHolder() {
        return this.requiredGroupCheckerHolder;
    }

    @Override
    public boolean isHasProvisioningSettings() {
        return true;
    }

    @Override
    public boolean isAllowCreatingNewDirectory() {
        return true;
    }

    @Override
    @Nonnull
    public CleanupDecider getCleanupDecider() {
        return this.cleanupDecider;
    }

    @Override
    @Nonnull
    public List<ConnectionTestResultEntity.EndpointResult> doConnectionTest() {
        return Collections.emptyList();
    }
}

