/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.onelogin;

import de.resolution.commons.util.Elvis;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.usersync.builtin.onelogin.OneLoginConnector;
import de.resolution.usersync.builtin.onelogin.OneLoginConnectorConfiguration;
import de.resolution.usersync.spi.AbstractOAuthConnectorConfiguration;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OneLoginConnectorConfigurationImpl
extends AbstractOAuthConnectorConfiguration
implements OneLoginConnectorConfiguration {
    private static final String DEFAULT_FIND_BY_ATTRIBUTE_NAME = "onelogin_ID";
    private static final List<AttributeTransformationConfig> DEFAULT_TRANSFORMATION_CONFIGS = new ArrayList<AttributeTransformationConfig>();
    static final AttributeTransformationConfig ACTIVE_TRANSFORMATION = new AttributeTransformationConfig(Source.createGroovy((String)"(con.status ?: 1) in [1, 4, 5, 7, 8]"), new Target(Target.Type.SYSTEM, "ATTR_ACTIVE"), false, true);
    @Nonnull
    private String baseUrl = "https://api.us.onelogin.com";
    private boolean useGroupAsGroup;
    private boolean useMemberOfAsGroup = true;
    private boolean useRolesAsGroup;
    private int minRemainingRateLimit = 0;

    public OneLoginConnectorConfigurationImpl() {
    }

    public OneLoginConnectorConfigurationImpl(OneLoginConnectorConfiguration other) {
        super(other);
        this.setBaseUrl(other.getBaseUrl());
        this.setUseGroupAsGroup(other.isUseGroupAsGroup());
        this.setUseMemberOfAsGroup(other.isUseMemberOfAsGroup());
        this.setUseRolesAsGroup(other.isUseRolesAsGroup());
        this.setMinRemainingRateLimit(other.getMinRemainingRateLimit());
    }

    @Override
    @Nonnull
    public List<AttributeTransformationConfig> createDefaultAttributeTransformationConfigs() {
        return DEFAULT_TRANSFORMATION_CONFIGS;
    }

    @Override
    @Nonnull
    public String getDefaultFindByAttributeName() {
        return DEFAULT_FIND_BY_ATTRIBUTE_NAME;
    }

    @Override
    @Nonnull
    public OneLoginConnectorConfigurationImpl sanitize() {
        OneLoginConnectorConfigurationImpl sanitizedConfig = new OneLoginConnectorConfigurationImpl(this);
        sanitizedConfig.setClientSecret("<<SENSITIVE DATA REMOVED>>");
        return sanitizedConfig;
    }

    @Override
    @Nonnull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(@Nullable String baseUrl) {
        this.baseUrl = (String)Elvis.ifNull((Object)baseUrl, (Object)"");
    }

    @Override
    public boolean isUseGroupAsGroup() {
        return this.useGroupAsGroup;
    }

    public void setUseGroupAsGroup(boolean useGroupAsGroup) {
        this.useGroupAsGroup = useGroupAsGroup;
    }

    @Override
    public boolean isUseMemberOfAsGroup() {
        return this.useMemberOfAsGroup;
    }

    public void setUseMemberOfAsGroup(boolean useMemberOfAsGroup) {
        this.useMemberOfAsGroup = useMemberOfAsGroup;
    }

    @Override
    public boolean isUseRolesAsGroup() {
        return this.useRolesAsGroup;
    }

    public void setUseRolesAsGroup(boolean useRolesAsGroup) {
        this.useRolesAsGroup = useRolesAsGroup;
    }

    @Override
    public int getMinRemainingRateLimit() {
        return this.minRemainingRateLimit;
    }

    public void setMinRemainingRateLimit(int minRemainingRateLimit) {
        this.minRemainingRateLimit = minRemainingRateLimit;
    }

    @Override
    public Class<? extends Connector<? extends ConnectorConfiguration>> tellConnectorClass() {
        return OneLoginConnector.class;
    }

    static {
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"id"), new Target(Target.Type.CROWD, DEFAULT_FIND_BY_ATTRIBUTE_NAME), true, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"username"), new Target(Target.Type.SYSTEM, "ATTR_NAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createFieldCombiner((String)"{firstname} {lastname}"), new Target(Target.Type.SYSTEM, "ATTR_FULLNAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"email"), new Target(Target.Type.SYSTEM, "ATTR_EMAIL"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(ACTIVE_TRANSFORMATION);
        DEFAULT_TRANSFORMATION_CONFIGS.add(GROUP_TRANSFORMATION);
    }
}

