/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bitbucket.userauth;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import com.resolution.atlasplugins.samlsso.userauth.AbstractRemoteDirectoryAdapter;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent
public class BitbucketRemoteDirectoryAdapter
extends AbstractRemoteDirectoryAdapter {
    private final UserAdminService userAdminService;
    private final SecurityService securityService;

    @Autowired
    public BitbucketRemoteDirectoryAdapter(@BitbucketImport DirectoryInstanceLoader directoryInstanceLoader, @BitbucketImport CrowdService crowdService, @BitbucketImport UserAdminService userService, @BitbucketImport SecurityService securityService) {
        super(directoryInstanceLoader, crowdService);
        this.userAdminService = userService;
        this.securityService = securityService;
    }

    @Override
    protected boolean isFirstLogin(Principal principal) {
        return (Boolean)this.securityService.withPermission(Permission.SYS_ADMIN, "Create new user").call((Operation)((UncheckedOperation)() -> {
            DetailedUser user = this.userAdminService.getUserDetails(principal.getName());
            return user != null && user.getLastAuthenticationTimestamp() != null;
        }));
    }
}

