/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.resolution.commons.util.Elvis;
import de.resolution.commons.util.PasswordUtil;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.usersync.builtin.scim.ScimConnector;
import de.resolution.usersync.builtin.scim.ScimConnectorConfiguration;
import de.resolution.usersync.spi.AbstractConnectorConfigurationImpl;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class ScimConnectorConfigurationImpl
extends AbstractConnectorConfigurationImpl
implements ScimConnectorConfiguration {
    private static final List<AttributeTransformationConfig> DEFAULT_TRANSFORMATION_CONFIGS = new ArrayList<AttributeTransformationConfig>();
    @Nonnull
    private AuthMethod authMethod = AuthMethod.TOKEN;
    @Nonnull
    private String token = PasswordUtil.generateSecureRandomToken();
    @Nonnull
    private List<String> allowedIPs = new ArrayList<String>();
    private boolean isHideLocalDirectoryGroups = false;

    public ScimConnectorConfigurationImpl() {
    }

    public ScimConnectorConfigurationImpl(ScimConnectorConfiguration other) {
        super(other);
        this.setAuthMethod(other.getAuthMethod());
        this.setToken(other.getToken());
        this.setAllowedIPs(other.getAllowedIPs());
        this.setHideLocalDirectoryGroups(other.isHideLocalDirectoryGroups());
    }

    @Override
    @Nonnull
    public String getDefaultFindByAttributeName() {
        return "SCIM_EXTERNAL_ID";
    }

    @Override
    @Nonnull
    public List<AttributeTransformationConfig> createDefaultAttributeTransformationConfigs() {
        return DEFAULT_TRANSFORMATION_CONFIGS;
    }

    @Override
    @Nonnull
    public ScimConnectorConfigurationImpl sanitize() {
        ScimConnectorConfigurationImpl copy = new ScimConnectorConfigurationImpl(this);
        copy.setToken("<<SENSITIVE DATA REMOVED>>");
        return copy;
    }

    @Override
    public Class<? extends Connector<? extends ConnectorConfiguration>> tellConnectorClass() {
        return ScimConnector.class;
    }

    @Override
    @Nonnull
    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(@Nullable AuthMethod authMethod) {
        this.authMethod = (AuthMethod)((Object)Elvis.ifNull((Object)((Object)authMethod), (Object)((Object)AuthMethod.TOKEN)));
    }

    @Override
    @Nonnull
    public String getToken() {
        return this.token;
    }

    public void setToken(@Nullable String token) {
        this.token = (String)Elvis.ifNull((Object)token, (Object)PasswordUtil.generateSecureRandomToken());
    }

    @Override
    @Nonnull
    public List<String> getAllowedIPs() {
        return this.allowedIPs;
    }

    public void setAllowedIPs(@Nullable List<String> allowedIPs) {
        this.allowedIPs = (List)Elvis.ifNull(allowedIPs, new ArrayList());
    }

    @Override
    public boolean isHideLocalDirectoryGroups() {
        return this.isHideLocalDirectoryGroups;
    }

    public void setHideLocalDirectoryGroups(boolean hideLocalDirectoryGroups) {
        this.isHideLocalDirectoryGroups = hideLocalDirectoryGroups;
    }

    static {
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"externalId"), new Target(Target.Type.CROWD, "SCIM_EXTERNAL_ID"), true, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"userName"), new Target(Target.Type.SYSTEM, "ATTR_NAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"displayName"), new Target(Target.Type.SYSTEM, "ATTR_FULLNAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createGroovy((String)"if(con.containsKey(\"emails\")) {\n    for(email in con.emails) {\n        return email.value\n    }    \n}\nreturn DROP"), new Target(Target.Type.SYSTEM, "ATTR_EMAIL"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createGroovy((String)"if(con.containsKey(\"groups\")) {\n    return con.groups.collect {it.value}    \n}\nreturn DROP"), new Target(Target.Type.SYSTEM, "ATTR_GROUPS"), false, false));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"active"), new Target(Target.Type.SYSTEM, "ATTR_ACTIVE"), false, true));
    }

    public static enum AuthMethod {
        BASIC,
        TOKEN;

    }
}

