/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.cronexpressionrest;

import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.caesium.cron.parser.CronExpressionParser;
import com.atlassian.scheduler.config.Schedule;
import de.resolution.reconfigure.cronexpressionrest.CronExpressionValidator;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
@ConfluenceComponent
@BitbucketComponent
public class CaesiumCronExpressionValidator
implements CronExpressionValidator {
    private final SchedulerService schedulerService;
    private static final Logger logger = LoggerFactory.getLogger(CaesiumCronExpressionValidator.class);

    @Autowired
    public CaesiumCronExpressionValidator(@ComponentImport SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Override
    public boolean isValid(String cronExpression) {
        return CronExpressionParser.isValid((String)cronExpression);
    }

    @Override
    public long getNextScheduledSyncAsLong(String cronString) {
        if (cronString == null || cronString.trim().isEmpty()) {
            logger.debug("Cron string is null or empty");
            return -1L;
        }
        if (!this.isValid(cronString)) {
            logger.debug("Parsing CRON expression {} failed.", (Object)cronString);
            return -1L;
        }
        try {
            Date result = this.schedulerService.calculateNextRunTime(Schedule.forCronExpression((String)cronString));
            if (result != null) {
                logger.debug("Calculating next run successful");
                return result.getTime();
            }
            logger.debug("Error getting next run for expression {}", (Object)cronString);
            return -1L;
        }
        catch (SchedulerServiceException e) {
            logger.warn("Error getting next scheduled sync", (Throwable)e);
            return -1L;
        }
    }
}

