/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum IdPType {
    ADFS(Arrays.asList(ProtocolType.SAML, ProtocolType.OIDC), "AD FS", Category.POPULAR, 1),
    AZURE(Arrays.asList(ProtocolType.SAML, ProtocolType.OIDC), "Entra ID (formerly Azure AD)", Category.POPULAR, 2),
    GSUITE(Arrays.asList(ProtocolType.SAML, ProtocolType.OIDC), "Google Cloud Identity (G Suite)", Category.POPULAR, 3),
    OKTA(Arrays.asList(ProtocolType.SAML, ProtocolType.OIDC), "Okta", Category.POPULAR, 4),
    GLUU(Collections.singletonList(ProtocolType.SAML), "Gluu Server", Category.ONPREMISE, 99),
    KEYCLOAK(Arrays.asList(ProtocolType.SAML, ProtocolType.OIDC), "Keycloak", Category.ONPREMISE, 99),
    OPENAM(Collections.singletonList(ProtocolType.SAML), "OpenAM", Category.ONPREMISE, 99),
    PINGFEDERATE(Collections.singletonList(ProtocolType.SAML), "Ping Federate", Category.ONPREMISE, 99),
    CROWD(Collections.singletonList(ProtocolType.SAML), "Atlassian Crowd DC", Category.ONPREMISE, 99),
    AUTH0(Collections.singletonList(ProtocolType.SAML), "Auth0", Category.CLOUD, 3),
    AUTHANVIL(Collections.singletonList(ProtocolType.SAML), "AuthAnvil", Category.CLOUD, 4),
    ONELOGIN(Collections.singletonList(ProtocolType.SAML), "OneLogin", Category.CLOUD, 5),
    PINGONE(Arrays.asList(ProtocolType.SAML, ProtocolType.OIDC), "Ping One", Category.CLOUD, 6),
    CENTRIFY(Collections.singletonList(ProtocolType.SAML), "Centrify", Category.CLOUD, 99),
    DUO(Collections.singletonList(ProtocolType.SAML), "Duo Access Gateway", Category.CLOUD, 99),
    SALESFORCE(Collections.singletonList(ProtocolType.SAML), "Salesforce", Category.CLOUD, 99),
    WSO2(Collections.singletonList(ProtocolType.SAML), "WSO2", Category.CLOUD, 99),
    GITHUB(Collections.singletonList(ProtocolType.OAU2), "GitHub", Category.CLOUD, 99),
    TWITTER(Collections.singletonList(ProtocolType.OAU2), "Twitter", Category.CLOUD, 99),
    FACEBOOK(Collections.singletonList(ProtocolType.OIDC), "Facebook", Category.CLOUD, 99),
    APPLE(Collections.singletonList(ProtocolType.OIDC), "Sign in with Apple", Category.CLOUD, 99),
    ATLASSIAN(Collections.singletonList(ProtocolType.OAU2), "Atlassian", Category.CLOUD, 99),
    LINKEDIN(Collections.singletonList(ProtocolType.OAU2), "LinkedIn", Category.CLOUD, 99),
    OTHER(Arrays.asList(ProtocolType.SAML, ProtocolType.OIDC, ProtocolType.OAU2), "Other IdP", Category.OTHER, 999);

    private final String label;
    private final Category category;
    private final int order;
    private final List<ProtocolType> protocols;

    private IdPType(List<ProtocolType> protocols, String label, Category category, int order) {
        this.label = label;
        this.category = category;
        this.order = order;
        this.protocols = new ArrayList<ProtocolType>(protocols);
    }

    public String label() {
        return this.label;
    }

    public Category deployment() {
        return this.category;
    }

    public int order() {
        return this.order;
    }

    public List<ProtocolType> protocol() {
        return this.protocols;
    }

    public static enum Category {
        POPULAR("Popular"),
        CLOUD("Cloud"),
        ONPREMISE("On Premise"),
        OTHER("Other");

        private final String label;

        private Category(String label) {
            this.label = label;
        }

        public String label() {
            return this.label;
        }
    }
}

