/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.QueryUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.CollectionAndTotal;
import de.resolution.usersync.api.SyncUserResult;
import de.resolution.usersync.api.SyncUserResultRepository;
import de.resolution.usersync.impl.AoSyncUserResult;
import de.resolution.usersync.util.UserSyncUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="syncUserResultRepository")
@ExportAsService
public class SyncUserResultRepositoryImpl
implements SyncUserResultRepository {
    private static final Logger logger = LoggerFactory.getLogger(SyncUserResultRepositoryImpl.class);
    private final ActiveObjects ao;

    @Inject
    public SyncUserResultRepositoryImpl(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    @Nonnull
    public CollectionAndTotal<SyncUserResult> fetchResults(int syncStatusId, @Nullable List<AtlasUserResult.Operation> includeOperations, @Nullable String search, int offset, int count) {
        Query query = QueryUtil.create((QueryUtil.WherePart)QueryUtil.and((QueryUtil.WherePart[])new QueryUtil.WherePart[]{QueryUtil.where((String)"SYNC_STATUS_ID = ?", (Object[])new Object[]{syncStatusId}), QueryUtil.any((String)"OPERATION = ?", includeOperations), QueryUtil.or((QueryUtil.WherePart[])new QueryUtil.WherePart[]{QueryUtil.where((String)"INITIAL_USERNAME   LIKE ? ", (Object[])new Object[]{QueryUtil.containing((String)search)}), QueryUtil.where((String)"INPUT_USERNAME     LIKE ? ", (Object[])new Object[]{QueryUtil.containing((String)search)}), QueryUtil.where((String)"RESULTING_USERNAME LIKE ? ", (Object[])new Object[]{QueryUtil.containing((String)search)}), QueryUtil.where((String)"INITIAL_EMAIL   LIKE ? ", (Object[])new Object[]{QueryUtil.containing((String)search)}), QueryUtil.where((String)"INPUT_EMAIL     LIKE ? ", (Object[])new Object[]{QueryUtil.containing((String)search)}), QueryUtil.where((String)"RESULTING_EMAIL LIKE ? ", (Object[])new Object[]{QueryUtil.containing((String)search)}), QueryUtil.where((String)"INITIAL_DISPLAYNAME LIKE ? ", (Object[])new Object[]{QueryUtil.containing((String)search)}), QueryUtil.where((String)"INPUT_DISPLAYNAME   LIKE ? ", (Object[])new Object[]{QueryUtil.containing((String)search)}), QueryUtil.where((String)"INPUT_DISPLAYNAME   LIKE ? ", (Object[])new Object[]{QueryUtil.containing((String)search)}), QueryUtil.where((String)"INITIAL_FOREIGN_ID LIKE ? ", (Object[])new Object[]{QueryUtil.containing((String)search)}), QueryUtil.where((String)"INPUT_FOREIGN_ID LIKE ? ", (Object[])new Object[]{QueryUtil.containing((String)search)}), QueryUtil.where((String)"RESULTING_FOREIGN_ID LIKE ? ", (Object[])new Object[]{QueryUtil.containing((String)search)})})}));
        return (CollectionAndTotal)this.ao.executeInTransaction(() -> {
            int resultCount = this.ao.count(AoSyncUserResult.class, query);
            Query queryWithLimit = query.offset(offset).limit(count).order("ID");
            AoSyncUserResult[] aoResults = (AoSyncUserResult[])this.ao.find(AoSyncUserResult.class, queryWithLimit);
            List resultList = Arrays.stream(aoResults).map(aoResult -> SyncUserResult.fromJsonAndId(aoResult.getResultJson(), aoResult.getID())).collect(Collectors.toList());
            return new CollectionAndTotal(resultList, resultCount);
        });
    }

    @Override
    @Nonnull
    public CollectionAndTotal<SyncUserResult> fetchResults(int syncStatusId, int offset, int count) {
        return this.fetchResults(syncStatusId, null, null, offset, count);
    }

    @Override
    @Nonnull
    public CollectionAndTotal<SyncUserResult> fetchResults(int syncStatusId, @Nullable String search, int offset, int count) {
        return this.fetchResults(syncStatusId, null, search, offset, count);
    }

    @Override
    @Nonnull
    public CollectionAndTotal<SyncUserResult> fetchResults(int syncStatusId, @Nullable List<AtlasUserResult.Operation> includeOperations, int offset, int count) {
        return this.fetchResults(syncStatusId, includeOperations, null, offset, count);
    }

    @Override
    @Nullable
    public SyncUserResult findById(int id) {
        return (SyncUserResult)this.ao.executeInTransaction(() -> {
            AoSyncUserResult aoResult = (AoSyncUserResult)this.ao.get(AoSyncUserResult.class, (Object)id);
            if (aoResult == null) {
                return null;
            }
            return SyncUserResult.fromJsonAndId(aoResult.getResultJson(), aoResult.getID());
        });
    }

    @Override
    public int countUserSyncResults(int syncStatusId) {
        return (Integer)this.ao.executeInTransaction(() -> this.ao.count(AoSyncUserResult.class, "SYNC_STATUS_ID = ?", new Object[]{syncStatusId}));
    }

    @Override
    public void storeSyncUserResult(@Nonnull SyncUserResult result, int syncStatusId) {
        AtlasUserResult atlasUserResult = result.getAtlasUserResult();
        String initialUsername = null;
        String inputUsername = null;
        String resultingUsername = null;
        String initialEmail = null;
        String inputEmail = null;
        String resultingEmail = null;
        String initialDisplayname = null;
        String inputDisplayname = null;
        String resultingDisplayname = null;
        String initialForeignId = null;
        String inputForeignId = null;
        String resultingForeignId = null;
        if (atlasUserResult != null) {
            if (atlasUserResult.getInitialUser().isPresent()) {
                AtlasUser initialUser = (AtlasUser)atlasUserResult.getInitialUser().get();
                initialUsername = initialUser.getName();
                initialEmail = initialUser.get("ATTR_EMAIL").orElse(null);
                initialDisplayname = initialUser.get("ATTR_FULLNAME").orElse(null);
                initialForeignId = UserSyncUtils.readForeignId(initialUser);
            }
            if (atlasUserResult.getInputUser().isPresent()) {
                AtlasUser inputUser = (AtlasUser)atlasUserResult.getInputUser().get();
                inputUsername = inputUser.getName();
                inputEmail = inputUser.get("ATTR_EMAIL").orElse(null);
                inputDisplayname = inputUser.get("ATTR_FULLNAME").orElse(null);
                inputForeignId = UserSyncUtils.readForeignId(inputUser);
            }
            if (atlasUserResult.getResultingUser().isPresent()) {
                AtlasUser resultingUser = (AtlasUser)atlasUserResult.getResultingUser().get();
                resultingUsername = resultingUser.getName();
                resultingEmail = resultingUser.get("ATTR_EMAIL").orElse(null);
                resultingDisplayname = resultingUser.get("ATTR_FULLNAME").orElse(null);
                resultingForeignId = UserSyncUtils.readForeignId(resultingUser);
            }
        } else {
            logger.warn("SyncUserResult contains no atlasUserResult and is not stored");
        }
        if (initialUsername != null) {
            initialUsername = initialUsername.toLowerCase();
        }
        this.ao.create(AoSyncUserResult.class, new DBParam[]{new DBParam("SYNC_STATUS_ID", (Object)syncStatusId), new DBParam("RESULT_JSON", (Object)JSONUtil.asJson((Object)result)), new DBParam("OPERATION", (Object)result.getOperation().name()), new DBParam("SUCCESS", (Object)result.isSuccess()), new DBParam("INITIAL_USERNAME", (Object)StringUtil.nullOrToLowerCase((String)initialUsername)), new DBParam("INITIAL_EMAIL", (Object)StringUtil.nullOrToLowerCase((String)initialEmail)), new DBParam("INITIAL_DISPLAYNAME", (Object)StringUtil.nullOrToLowerCase((String)initialDisplayname)), new DBParam("INITIAL_FOREIGN_ID", (Object)StringUtil.nullOrToLowerCase((String)initialForeignId)), new DBParam("INPUT_USERNAME", (Object)StringUtil.nullOrToLowerCase((String)inputUsername)), new DBParam("INPUT_EMAIL", (Object)StringUtil.nullOrToLowerCase((String)inputEmail)), new DBParam("INPUT_DISPLAYNAME", (Object)StringUtil.nullOrToLowerCase((String)inputDisplayname)), new DBParam("INPUT_FOREIGN_ID", (Object)StringUtil.nullOrToLowerCase((String)inputForeignId)), new DBParam("RESULTING_USERNAME", (Object)StringUtil.nullOrToLowerCase((String)resultingUsername)), new DBParam("RESULTING_EMAIL", (Object)StringUtil.nullOrToLowerCase((String)resultingEmail)), new DBParam("RESULTING_DISPLAYNAME", (Object)StringUtil.nullOrToLowerCase((String)resultingDisplayname)), new DBParam("RESULTING_FOREIGN_ID", (Object)StringUtil.nullOrToLowerCase((String)resultingForeignId))});
    }
}

