/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.servlet.SamlSsoServlet;
import de.resolution.atlascompat.api.AtlasCompatApiFactory;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
public class EnableSloForSDCustomersFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(EnableSloForSDCustomersFilter.class);
    private static final String ALREADY_FILTERED = EnableSloForSDCustomersFilter.class.getName() + "_already_filtered";
    private final SamlSsoServlet samlSsoServlet;
    private final AtlasCompatApiFactory atlasCompatApiFactory;
    private final SamlSsoService samlSsoService;
    private Boolean servicedesk = null;

    @Autowired
    public EnableSloForSDCustomersFilter(SamlSsoServlet samlSsoServlet, AtlasCompatApiFactory atlasCompatApiFactory, SamlSsoService samlSsoService) {
        this.samlSsoServlet = samlSsoServlet;
        this.atlasCompatApiFactory = atlasCompatApiFactory;
        this.samlSsoService = samlSsoService;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(ALREADY_FILTERED) != null) {
            chain.doFilter(req, res);
        } else {
            req.setAttribute(ALREADY_FILTERED, (Object)"yes");
            if (this.servicedesk == null) {
                this.servicedesk = this.atlasCompatApiFactory.getJiraServiceDeskApi().isPresent();
            }
            if (Boolean.TRUE.equals(this.servicedesk)) {
                HttpServletRequest httpReq = (HttpServletRequest)req;
                if (this.samlSsoService.isLoggedInUser(httpReq)) {
                    logger.trace("Explicitly calling the SAMLSSOServlet to skip the ExternalCustomerLockoutFilter");
                    this.samlSsoServlet.processRequest(httpReq, (HttpServletResponse)res);
                } else {
                    logger.trace("No user logged in, calling the next filter");
                    chain.doFilter(req, res);
                }
            } else {
                logger.trace("This is no Service Desk, calling next filter");
                chain.doFilter(req, res);
            }
        }
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }
}

