/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ListResponse {
    private final Set<String> schemas;
    private final int totalResults;
    private final int itemsPerPage;
    private final int startIndex;
    @JsonProperty(value="Resources")
    private final Set<Object> resources;

    public ListResponse(int totalResults, int itemsPerPage, int startIndex, Set<Object> resources) {
        this.totalResults = totalResults;
        this.itemsPerPage = itemsPerPage;
        this.startIndex = startIndex;
        this.resources = resources;
        this.schemas = Collections.singleton("urn:ietf:params:scim:api:messages:2.0:ListResponse");
    }

    public static ListResponse createEmptyListResponse(int startIndex) {
        return new ListResponse(0, 0, startIndex, new HashSet<Object>());
    }

    public static ListResponse createSingleResourceListResponse(int startIndex, Object resource) {
        return new ListResponse(1, 1, startIndex, Collections.singleton(resource));
    }

    public static ListResponseBuilder builder() {
        return new ListResponseBuilder();
    }

    public Set<String> getSchemas() {
        return this.schemas;
    }

    public int getTotalResults() {
        return this.totalResults == -1 ? this.resources.size() : this.totalResults;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage == -1 ? this.resources.size() : this.itemsPerPage;
    }

    public int getStartIndex() {
        return this.startIndex == -1 ? 1 : this.startIndex;
    }

    public Set<Object> getResources() {
        return this.resources;
    }

    public static class ListResponseBuilder {
        private int totalResults = -1;
        private int itemsPerPage = -1;
        private int startIndex = 1;
        private final Set<Object> resources = new HashSet<Object>();

        public ListResponse build() {
            return new ListResponse(this.totalResults, this.itemsPerPage, this.startIndex, this.resources);
        }

        public ListResponseBuilder totalResults(int totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListResponseBuilder itemsPerPage(int itemsPerPage) {
            this.itemsPerPage = itemsPerPage;
            return this;
        }

        public ListResponseBuilder startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public ListResponseBuilder resource(Object resource) {
            this.resources.add(resource);
            return this;
        }
    }
}

