/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.tracker.activeobjects;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.resolution.atlasplugins.samlsso.ImmutableLoginInformation;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.OAuth2AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.activeobjects.ActiveObjectAuthenticationTrackerRepository;
import com.resolution.atlasplugins.samlsso.tracker.activeobjects.AoAuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.activeobjects.ExceptionInfoWrapper;
import com.resolution.atlasplugins.samlsso.tracker.activeobjects.RequestInfoWrapper;
import com.resolution.atlasplugins.samlsso.tracker.activeobjects.SamlMessageInformationWrapper;
import com.resolution.samlwrapper.api.ImmutableMessageWithTimestamp;
import com.resolution.samlwrapper.api.LoginInformation;
import com.resolution.samlwrapper.api.tracker.ExceptionInfo;
import com.resolution.samlwrapper.api.tracker.ImmutableExceptionInfo;
import com.resolution.samlwrapper.api.tracker.MessageWithTimestamp;
import com.resolution.samlwrapper.api.tracker.RequestInfo;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTrackerListener;
import com.resolution.samlwrapper.api.tracker.SAMLMessageInformation;
import com.resolution.samlwrapper.api.tracker.TrackerUtil;
import com.resolution.samlwrapper.api.tracker.formatter.FormattingTuple;
import com.resolution.samlwrapper.api.tracker.formatter.MessageFormatter;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.ImmutableAtlasUserResult;
import de.resolution.commons.util.StringUtil;
import de.resolution.retransform.api.AttributeTransformationResult;
import de.resolution.usersync.api.SyncSingleUserResult;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
public class AuthenticationTrackerActiveObjectsProxy
implements AuthenticationTracker,
OAuth2AuthenticationTracker {
    public static final int STRING_LENGTH = 255;
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationTrackerActiveObjectsProxy.class);
    private static final TypeReference<List<ImmutableMessageWithTimestamp>> TR_LIST_MESSAGEWITHTIMESTAMP = new TypeReference<List<ImmutableMessageWithTimestamp>>(){};
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter jsonWriter = objectMapper.writer();
    private static final String ERRORMSG = "Tracker Operation Failed!";
    @JsonIgnore
    private final ActiveObjectAuthenticationTrackerRepository repository;
    @JsonIgnore
    private final ActiveObjects activeObjects;
    private final String trackerId;

    public AuthenticationTrackerActiveObjectsProxy(String trackerId, ActiveObjectAuthenticationTrackerRepository repository) {
        this.repository = repository;
        this.trackerId = trackerId;
        this.activeObjects = repository.getActiveObjects();
    }

    public SAMLAuthenticationTracker.Status getStatus() {
        try {
            return this.getAo().getStatus();
        }
        catch (Exception e) {
            logger.error(ERRORMSG);
            return SAMLAuthenticationTracker.Status.ERROR;
        }
    }

    public void setStatus(SAMLAuthenticationTracker.Status newStatus) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                logger.debug("Setting status to {}", (Object)newStatus);
                AoAuthenticationTracker ao = this.getAo();
                ao.setStatus(newStatus);
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
        this.repository.notifiyStatusChange(this);
    }

    public String getStatusMessage() {
        try {
            return this.getAo().getStatusMessage();
        }
        catch (Exception e) {
            logger.error(ERRORMSG);
            return null;
        }
    }

    public void setStatusMessage(String statusMessage) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                logger.debug("Setting statusMessage to {}", (Object)statusMessage);
                AoAuthenticationTracker ao = this.getAo();
                ao.setStatusMessage(statusMessage);
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
        this.repository.notifiyStatusChange(this);
    }

    @Override
    public String getSelectionMethod() {
        try {
            return this.getAo().getSelectionMethod();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return ERRORMSG;
        }
    }

    @Override
    public void setSelectionMethod(String selectionMethod) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setSelectionMethod(Utils.nullForEmpty(selectionMethod));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    @Override
    public String getOriginalUrl() {
        try {
            return this.getAo().getOriginalUrl();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return ERRORMSG;
        }
    }

    @Override
    public void setOriginalUrl(String originalUrl) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setOriginalUrl(Utils.nullForEmpty(originalUrl));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    @Override
    public String getFullRedirectUrl() {
        try {
            return this.getAo().getFullRedirectUrl();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return ERRORMSG;
        }
    }

    @Override
    public void setFullRedirectUrl(String fullRedirectUrl) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setFullRedirectUrl(Utils.nullForEmpty(fullRedirectUrl));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    @Override
    public String getUserId() {
        try {
            return this.getAo().getUserId();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return ERRORMSG;
        }
    }

    @Override
    public void setUserId(String userId) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setUserId(Utils.nullForEmpty(Utils.truncate(userId, 255)));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    @Override
    public String getFullName() {
        try {
            return this.getAo().getFullName();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return ERRORMSG;
        }
    }

    @Override
    public void setFullName(String fullName) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setFullName(Utils.nullForEmpty(fullName));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    @Override
    public String getEmailAddress() {
        try {
            return this.getAo().getEmailAddress();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return ERRORMSG;
        }
    }

    @Override
    public void setEmailAddress(String emailAddress) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setEmailAddress(Utils.nullForEmpty(emailAddress));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    public void setNotificationMail(String emailAddress) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setNotificationMail(Utils.nullForEmpty(emailAddress));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    public String getNotificationMail() {
        try {
            return this.getAo().getNotificationMail();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return ERRORMSG;
        }
    }

    @Override
    public String getConfirmationMessage() {
        try {
            return this.getAo().getConfirmationMessage();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return ERRORMSG;
        }
    }

    @Override
    public void setConfirmationMessage(String confirmationMessage) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setConfirmationMessage(Utils.nullForEmpty(confirmationMessage));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    @Override
    public boolean isConfirmed() {
        try {
            return this.getAo().isConfirmed();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return false;
        }
    }

    @Override
    public void setConfirmed(boolean confirmed) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setConfirmed(confirmed);
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    @Override
    public boolean isCreatedUser() {
        try {
            return this.getAo().isCreatedUser();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return false;
        }
    }

    @Override
    public void setCreatedUser(boolean created) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setCreatedUser(created);
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    @Override
    public boolean isUpdatedUser() {
        try {
            return this.getAo().isUpdatedUser();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return false;
        }
    }

    @Override
    public void setUpdatedUser(boolean updated) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setUpdatedUser(updated);
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    public String getTrackerId() {
        return this.trackerId;
    }

    public SAMLAuthenticationTracker.SamlStatus getSamlStatus() {
        try {
            return this.getAo().getSamlStatus();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return SAMLAuthenticationTracker.SamlStatus.ERROR;
        }
    }

    public void setSamlStatus(SAMLAuthenticationTracker.SamlStatus status) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setSamlStatus(status);
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    public void add(SAMLMessageInformation samlMessageInformation) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                List<SAMLMessageInformation> messageInformations = this.readSAMLMessageInformations(ao.getSamlMessageInformationJson());
                int index = messageInformations.indexOf(samlMessageInformation);
                if (index >= 0) {
                    messageInformations.remove(index);
                    messageInformations.add(index, samlMessageInformation);
                    logger.debug("Replacing SAMLMessageInformation at position {}", (Object)index);
                } else {
                    messageInformations.add(samlMessageInformation);
                }
                SamlMessageInformationWrapper wrapper = new SamlMessageInformationWrapper();
                wrapper.samlMessageInformations = messageInformations;
                try {
                    String jsonToWrite = jsonWriter.writeValueAsString((Object)wrapper);
                    ao.setSamlMessageInformationJson(jsonToWrite);
                    this.save(ao);
                }
                catch (Exception e) {
                    logger.error("Creating SamlMessageInformation-JSON failed", (Throwable)e);
                }
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    public List<SAMLMessageInformation> getSAMLMessageInformations() {
        return this.readSAMLMessageInformations(this.getAo().getSamlMessageInformationJson());
    }

    public LoginInformation getLoginInformation() {
        try {
            return this.loadFromJson(this.getAo().getLoginInformationJson(), ImmutableLoginInformation.class);
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return null;
        }
    }

    public void setLoginInformation(LoginInformation loginInformation) {
        if (loginInformation != null) {
            try {
                String jsonString = jsonWriter.writeValueAsString((Object)loginInformation);
                if (jsonString != null) {
                    this.activeObjects.executeInTransaction(() -> {
                        AoAuthenticationTracker ao = this.getAo();
                        ao.setLoginInformationJson(Utils.nullForEmpty(jsonString));
                        this.save(ao);
                        return null;
                    });
                }
            }
            catch (Exception e) {
                if (!this.repository.isCatchExceptions()) {
                    throw new AoProxyRuntimeException(e);
                }
                logger.error(ERRORMSG, (Throwable)e);
            }
        }
    }

    @Override
    public void setUserLookupTransformerResult(AttributeTransformationResult userLookupTransformerResult) {
        if (userLookupTransformerResult != null) {
            try {
                String jsonString = jsonWriter.writeValueAsString((Object)userLookupTransformerResult);
                if (jsonString != null) {
                    this.activeObjects.executeInTransaction(() -> {
                        AoAuthenticationTracker ao = this.getAo();
                        ao.setULookupATCResultJson(Utils.nullForEmpty(jsonString));
                        this.save(ao);
                        return null;
                    });
                }
            }
            catch (Exception e) {
                if (!this.repository.isCatchExceptions()) {
                    throw new AoProxyRuntimeException(e);
                }
                logger.error(ERRORMSG, (Throwable)e);
            }
        }
    }

    @Override
    public AttributeTransformationResult getUserLookupTransformerResult() {
        try {
            return this.loadFromJson(this.getAo().getULookupATCResultJson(), AttributeTransformationResult.class);
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return null;
        }
    }

    @Override
    public void setConnectorLookupTransformerResult(AttributeTransformationResult connectorLookupTransformerResult) {
        if (connectorLookupTransformerResult != null) {
            try {
                String jsonString = jsonWriter.writeValueAsString((Object)connectorLookupTransformerResult);
                if (jsonString != null) {
                    this.activeObjects.executeInTransaction(() -> {
                        AoAuthenticationTracker ao = this.getAo();
                        ao.setCLookupATCResultJson(Utils.nullForEmpty(jsonString));
                        this.save(ao);
                        return null;
                    });
                }
            }
            catch (Exception e) {
                if (!this.repository.isCatchExceptions()) {
                    throw new AoProxyRuntimeException(e);
                }
                logger.error(ERRORMSG, (Throwable)e);
            }
        }
    }

    @Override
    public AttributeTransformationResult getConnectorLookupTransformerResult() {
        try {
            return this.loadFromJson(this.getAo().getCLookupATCResultJson(), AttributeTransformationResult.class);
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return null;
        }
    }

    @Override
    public void setAttributeTransformerResults(Map<String, AttributeTransformationResult> transformerResults) {
        if (transformerResults != null) {
            try {
                String jsonString = jsonWriter.writeValueAsString(transformerResults);
                if (jsonString != null) {
                    this.activeObjects.executeInTransaction(() -> {
                        AoAuthenticationTracker ao = this.getAo();
                        ao.setATResultJson(Utils.nullForEmpty(jsonString));
                        this.save(ao);
                        return null;
                    });
                }
            }
            catch (Exception e) {
                if (!this.repository.isCatchExceptions()) {
                    throw new AoProxyRuntimeException(e);
                }
                logger.error(ERRORMSG, (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, AttributeTransformationResult> getAttributeTransformerResults() {
        try {
            String attributeTransformerChainResultJson = this.getAo().getATResultJson();
            return this.loadFromJson(attributeTransformerChainResultJson, new TypeReference<HashMap<String, AttributeTransformationResult>>(){});
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return null;
        }
    }

    @Override
    public SyncSingleUserResult getUpdateFromConnectorResult() {
        try {
            String json = this.getAo().getConnectorResultJson();
            return this.loadFromJson(json, SyncSingleUserResult.class);
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return null;
        }
    }

    @Override
    public void setUpdateFromConnectorResult(SyncSingleUserResult connectorResult) {
        if (connectorResult != null) {
            try {
                String jsonString = jsonWriter.writeValueAsString((Object)connectorResult);
                if (jsonString != null) {
                    this.activeObjects.executeInTransaction(() -> {
                        AoAuthenticationTracker ao = this.getAo();
                        AtlasUserResult updateResult = connectorResult.getAtlasUserResult();
                        if (updateResult != null) {
                            if (updateResult.getOperation() == AtlasUserResult.Operation.ADDED) {
                                ao.setCreatedUser(true);
                            } else {
                                ao.setUpdatedUser(ao.isUpdatedUser() || updateResult.isModified());
                            }
                        }
                        ao.setConnectorResultJson(Utils.nullForEmpty(jsonString));
                        this.save(ao);
                        return null;
                    });
                }
            }
            catch (Exception e) {
                if (!this.repository.isCatchExceptions()) {
                    throw new AoProxyRuntimeException(e);
                }
                logger.error(ERRORMSG, (Throwable)e);
            }
        }
    }

    @Override
    public AtlasUserResult getUpdateFromSAMLResult() {
        try {
            return (AtlasUserResult)this.loadFromJson(this.getAo().getSAMLResultJson(), ImmutableAtlasUserResult.class);
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return null;
        }
    }

    @Override
    public void setUpdateFromSAMLResult(AtlasUserResult result) {
        if (result != null) {
            try {
                String jsonString = jsonWriter.writeValueAsString((Object)result);
                if (jsonString != null) {
                    this.activeObjects.executeInTransaction(() -> {
                        AoAuthenticationTracker ao = this.getAo();
                        if (result.getOperation() == AtlasUserResult.Operation.ADDED) {
                            ao.setCreatedUser(true);
                        } else {
                            ao.setUpdatedUser(ao.isUpdatedUser() || result.isModified());
                        }
                        ao.setSAMLResultJson(Utils.nullForEmpty(jsonString));
                        this.save(ao);
                        return null;
                    });
                }
            }
            catch (Exception e) {
                if (!this.repository.isCatchExceptions()) {
                    throw new AoProxyRuntimeException(e);
                }
                logger.error(ERRORMSG, (Throwable)e);
            }
        }
    }

    public List<ExceptionInfo> getExceptionInfos() {
        String jsonString = this.getAo().getExceptionInfoJson();
        return this.readExceptionInfos(jsonString);
    }

    private List<ExceptionInfo> readExceptionInfos(String jsonString) {
        if (jsonString != null && !jsonString.isEmpty()) {
            try {
                ExceptionInfoWrapper wrapper = (ExceptionInfoWrapper)objectMapper.readValue(jsonString, ExceptionInfoWrapper.class);
                return wrapper.exceptionInfos;
            }
            catch (Exception e) {
                if (!this.repository.isCatchExceptions()) {
                    throw new AoProxyRuntimeException(e);
                }
                logger.error("Reading exception infos from JSON failed, returning empty list, json is {}", (Object)jsonString, (Object)e);
            }
        }
        return new ArrayList<ExceptionInfo>();
    }

    public void add(Throwable exToAdd) {
        if (logger.isWarnEnabled()) {
            logger.warn("Adding ExceptionInfo for this Exception to {}:", (Object)StringUtil.sanitize((String)this.getTrackerId()), (Object)exToAdd);
        }
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker tracker = this.getAo();
                String jsonString = tracker.getExceptionInfoJson();
                List<ExceptionInfo> exceptionInfos = this.readExceptionInfos(jsonString);
                ImmutableExceptionInfo info = new ImmutableExceptionInfo(exToAdd);
                exceptionInfos.add((ExceptionInfo)info);
                ExceptionInfoWrapper wrapper = new ExceptionInfoWrapper();
                wrapper.exceptionInfos = exceptionInfos;
                try {
                    String jsonToWrite = jsonWriter.writeValueAsString((Object)wrapper);
                    tracker.setExceptionInfoJson(jsonToWrite);
                    this.save(tracker);
                }
                catch (Exception e) {
                    logger.error("Creating ExceptionInfo-JSON failed", (Throwable)e);
                }
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    private void add(String message, SAMLAuthenticationTracker.Level level) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker tracker = this.getAo();
                String jsonString = tracker.getMessageJson();
                List<MessageWithTimestamp> messages = this.readMessagesWithTimestamps(jsonString);
                messages.add(ImmutableMessageWithTimestamp.create((String)message, (SAMLAuthenticationTracker.Level)level));
                try {
                    String jsonToWrite = jsonWriter.writeValueAsString(messages);
                    tracker.setMessageJson(jsonToWrite);
                    this.save(tracker);
                }
                catch (Exception e) {
                    if (!this.repository.isCatchExceptions()) {
                        throw new AoProxyRuntimeException(e);
                    }
                    logger.error("Creating Messages-JSON failed", (Throwable)e);
                }
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    public void add(Logger destinationLogger, SAMLAuthenticationTracker.Level level, String message, Object ... args) {
        FormattingTuple tuple = MessageFormatter.arrayFormat((String)message, (Object[])args);
        this.add(tuple.getMessage(), level);
        if (tuple.getThrowable() != null) {
            this.add(tuple.getThrowable());
        }
        TrackerUtil.log((String)(this.trackerId + ": " + message), (SAMLAuthenticationTracker.Level)level, (Logger)destinationLogger, (Object[])args);
    }

    public List<MessageWithTimestamp> getMessages() {
        try {
            String jsonString = this.getAo().getMessageJson();
            return this.readMessagesWithTimestamps(jsonString);
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void add(RequestInfo requestInfo) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker tracker = this.getAo();
                String jsonString = tracker.getRequestInfoJson();
                List<RequestInfo> requestInfos = this.readRequestInfos(jsonString);
                requestInfos.add(requestInfo);
                RequestInfoWrapper wrapper = new RequestInfoWrapper();
                wrapper.requestInfos = requestInfos;
                try {
                    String jsonToWrite = jsonWriter.writeValueAsString((Object)wrapper);
                    tracker.setRequestInfoJson(jsonToWrite);
                    this.save(tracker);
                }
                catch (Exception e) {
                    if (!this.repository.isCatchExceptions()) {
                        throw new AoProxyRuntimeException(e);
                    }
                    logger.error("Creating RequestInfo-JSON failed", (Throwable)e);
                }
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    private List<MessageWithTimestamp> readMessagesWithTimestamps(String jsonString) {
        if (jsonString != null && !jsonString.isEmpty()) {
            try {
                List retList = (List)objectMapper.readValue(jsonString, TR_LIST_MESSAGEWITHTIMESTAMP);
                return new ArrayList<MessageWithTimestamp>(retList);
            }
            catch (Exception e) {
                if (!this.repository.isCatchExceptions()) {
                    throw new AoProxyRuntimeException(e);
                }
                logger.error("Reading messages from JSON failed, returning empty list", (Throwable)e);
            }
        }
        return new ArrayList<MessageWithTimestamp>();
    }

    public List<RequestInfo> getRequestInfos() {
        ArrayList<RequestInfo> ret = new ArrayList<RequestInfo>();
        try {
            String jsonString = this.getAo().getRequestInfoJson();
            return this.readRequestInfos(jsonString);
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error("Reading RequestInfos from JSON failed, returning empty list", (Throwable)e);
            return ret;
        }
    }

    private List<RequestInfo> readRequestInfos(String jsonString) {
        ArrayList<RequestInfo> ret = new ArrayList<RequestInfo>();
        if (jsonString != null && !jsonString.isEmpty()) {
            try {
                RequestInfoWrapper wrapper = (RequestInfoWrapper)objectMapper.readValue(jsonString, RequestInfoWrapper.class);
                return wrapper.requestInfos;
            }
            catch (Exception e) {
                if (!this.repository.isCatchExceptions()) {
                    throw new AoProxyRuntimeException(e);
                }
                logger.error("Reading RequestInfos from JSON failed, returning empty list", (Throwable)e);
            }
        }
        return ret;
    }

    private List<SAMLMessageInformation> readSAMLMessageInformations(String jsonString) {
        ArrayList<SAMLMessageInformation> ret = new ArrayList<SAMLMessageInformation>();
        if (jsonString == null || jsonString.isEmpty()) {
            return ret;
        }
        try {
            SamlMessageInformationWrapper wrapper = (SamlMessageInformationWrapper)objectMapper.readValue(jsonString, SamlMessageInformationWrapper.class);
            return wrapper.samlMessageInformations;
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error("Reading SamlMessageInformations from JSON failed, returning empty list", (Throwable)e);
            return ret;
        }
    }

    public long getCreated() {
        try {
            return this.getAo().getCreated();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return 0L;
        }
    }

    public long getLastModified() {
        try {
            return this.getAo().getLastModified();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return 0L;
        }
    }

    public String getCreatedUTCString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sssZ");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(this.getCreated());
    }

    public String getLastModifiedUTCString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sssZ");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(this.getLastModified());
    }

    public void setIncomingRelayState(String relayState) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setIncomingRelayState(Utils.nullForEmpty(relayState));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    public String getIncomingRelayState() {
        try {
            return this.getAo().getIncomingRelayState();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return ERRORMSG;
        }
    }

    public void setOutgoingRelayState(String relayState) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setOutgoingRelayState(Utils.nullForEmpty(relayState));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    public String getOutgoingRelayState() {
        try {
            return this.getAo().getOutgoingRelayState();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return ERRORMSG;
        }
    }

    public void setSamlRequestId(String requestId) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setSamlRequestId(Utils.nullForEmpty(Utils.truncate(requestId, 255)));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    public String getSamlRequestId() {
        try {
            return this.getAo().getSamlRequestId();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return ERRORMSG;
        }
    }

    public void setSamlLogoutRequestId(String logoutRequestId) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setSamlLogoutRequestId(Utils.nullForEmpty(Utils.truncate(logoutRequestId, 255)));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
    }

    public String getSamlLogoutRequestId() {
        try {
            return this.getAo().getSamlLogoutRequestId();
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
            return ERRORMSG;
        }
    }

    @Override
    public void setProtocolType(ProtocolType type) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                logger.debug("Setting ProtocolType to {}", (Object)type);
                AoAuthenticationTracker ao = this.getAo();
                ao.setProtocolTypeString(ProtocolType.stringFromType(type));
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
        this.repository.notifiyStatusChange(this);
    }

    @Override
    public String getProtocolType() {
        try {
            String protocolType = this.getAo().getProtocolTypeString();
            if (protocolType != null) {
                return protocolType;
            }
            return ProtocolType.stringFromType(this.getAo().getProtocolType());
        }
        catch (Exception e) {
            logger.error(ERRORMSG);
            return null;
        }
    }

    @Override
    public void setClientId(String clientId) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                logger.debug("Setting Client id to {}", (Object)clientId);
                AoAuthenticationTracker ao = this.getAo();
                ao.setClientId(clientId);
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
        this.repository.notifiyStatusChange(this);
    }

    @Override
    public String getClientId() {
        try {
            return this.getAo().getClientId();
        }
        catch (Exception e) {
            logger.error(ERRORMSG);
            return null;
        }
    }

    @Override
    public void setNonce(String nonce) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                logger.debug("Setting nonce to {}", (Object)nonce);
                AoAuthenticationTracker ao = this.getAo();
                ao.setNonce(nonce);
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
        this.repository.notifiyStatusChange(this);
    }

    @Override
    public String getNonce() {
        try {
            return this.getAo().getNonce();
        }
        catch (Exception e) {
            logger.error(ERRORMSG);
            return null;
        }
    }

    @Override
    public void setCodeVerifier(String codeVerifier) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setCodeVerifier(codeVerifier);
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
        this.repository.notifiyStatusChange(this);
    }

    @Override
    public String getCodeVerifier() {
        try {
            return this.getAo().getCodeVerifier();
        }
        catch (Exception e) {
            logger.error(ERRORMSG);
            return null;
        }
    }

    @Override
    public void setIdToken(String idToken) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                AoAuthenticationTracker ao = this.getAo();
                ao.setIdToken(idToken);
                this.save(ao);
                return null;
            });
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error(ERRORMSG, (Throwable)e);
        }
        this.repository.notifiyStatusChange(this);
    }

    @Override
    public String getIdToken() {
        try {
            return this.getAo().getIdToken();
        }
        catch (Exception e) {
            logger.error(ERRORMSG);
            return null;
        }
    }

    public void addListener(SAMLAuthenticationTrackerListener listener) {
        logger.warn("addListener is not implemented here!");
    }

    public String toString() {
        return "AuthenticationTrackerActiveObjectsProxy trackerid: " + this.trackerId;
    }

    private AoAuthenticationTracker getAo() {
        AoAuthenticationTracker ao = (AoAuthenticationTracker)this.activeObjects.get(AoAuthenticationTracker.class, (Object)this.trackerId);
        if (ao == null) {
            throw new IllegalStateException("Tracker with id " + this.trackerId + " is no longer available");
        }
        return ao;
    }

    private void save(AoAuthenticationTracker aoTracker) {
        aoTracker.setLastModified(new Date().getTime());
        aoTracker.save();
    }

    public String toJsonString() {
        try {
            return objectMapper.writer().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            throw new AoProxyRuntimeException("Creating JSON failed", e);
        }
    }

    public JsonNode toJsonNode() {
        return objectMapper.valueToTree((Object)this);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SAMLAuthenticationTracker)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        JsonNode thisNode = this.toJsonNode();
        if (logger.isDebugEnabled()) {
            logger.debug("ThisNode {}", (Object)thisNode);
        }
        return true;
    }

    public int hashCode() {
        JsonNode thisNode = this.toJsonNode();
        return thisNode.hashCode();
    }

    private <T> T loadFromJson(@Nullable String jsonString, Class<T> clazz) {
        return this.loadFromJson(jsonString, clazz, null);
    }

    private <T> T loadFromJson(@Nullable String jsonString, TypeReference<T> typeReference) {
        return this.loadFromJson(jsonString, null, typeReference);
    }

    private <T> T loadFromJson(@Nullable String jsonString, Class<T> clazz, @Nullable TypeReference<T> typeReference) {
        try {
            if (jsonString == null || jsonString.isEmpty()) {
                return null;
            }
            if (clazz != null) {
                return (T)objectMapper.readValue(jsonString, clazz);
            }
            return (T)objectMapper.readValue(jsonString, typeReference);
        }
        catch (Exception e) {
            if (!this.repository.isCatchExceptions()) {
                throw new AoProxyRuntimeException(e);
            }
            logger.error("Parsing json String failed, returning null", (Throwable)e);
            return null;
        }
    }

    public static class AoProxyRuntimeException
    extends RuntimeException {
        public AoProxyRuntimeException(String message, Throwable cause) {
            super(message, cause);
        }

        public AoProxyRuntimeException(Throwable cause) {
            super(cause);
        }
    }
}

