/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.frontend;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import de.resolution.atlasuser.impl.user.communardo.CommunardoUserProfileAdapter;
import de.resolution.retransform.frontend.AbstractAttributeMappingOptionProvider;
import de.resolution.retransform.frontend.AttributeMappingOptionGroup;
import de.resolution.retransform.frontend.AttributeMappingUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
public class JiraAttributeMappingOptionProvider
extends AbstractAttributeMappingOptionProvider {
    private final JiraLicenseService licenseService;
    private final CommunardoUserProfileAdapter communardoUserProfileAdapter;

    @Autowired
    public JiraAttributeMappingOptionProvider(@JiraImport JiraLicenseService licenseService, CommunardoUserProfileAdapter communardoUserProfileAdapter) {
        this.licenseService = licenseService;
        this.communardoUserProfileAdapter = communardoUserProfileAdapter;
    }

    @Override
    public List<AttributeMappingOptionGroup> getSpecificOptions() {
        List<AttributeMappingOptionGroup.AttributeMappingOption> communardoOptions;
        List<AttributeMappingOptionGroup> jiraOptions = this.load("jiraAttributeMappingOptions");
        if (this.isJiraServiceDesk()) {
            jiraOptions.addAll(this.load("jiraServiceDeskAttributeMappingOptions"));
        }
        if (!(communardoOptions = AttributeMappingUtils.createCommunardoAttributeOptions(this.communardoUserProfileAdapter)).isEmpty()) {
            jiraOptions.add(new AttributeMappingOptionGroup("Communardo", communardoOptions));
        }
        return jiraOptions;
    }

    private boolean isJiraServiceDesk() {
        for (LicenseDetails licenseDetails : this.licenseService.getLicenses()) {
            for (ApplicationKey appKey : licenseDetails.getLicensedApplications().getKeys()) {
                if (!appKey.equals((Object)ApplicationKey.valueOf((String)"jira-servicedesk"))) continue;
                return true;
            }
        }
        return false;
    }
}

