/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.regex.tester;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.user.UserProfile;
import de.resolution.commons.util.boundedregex.BoundedRegex;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.WebSudoRequiredException;
import de.resolution.reconfigure.api.Configuration;
import de.resolution.reconfigure.api.ConfigurationService;
import de.resolution.reconfigure.regex.tester.RegexMatchTestData;
import de.resolution.reconfigure.regex.tester.RegexMatchTestResult;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/regexmatch")
public class RegexMatchTestRestResource<C extends Configuration> {
    private final PrivilegeChecker privilegeChecker;
    private final ConfigurationService<C> configurationService;
    private static final String CC_NO_CACHE_VALUE = "no-cache, no-store, must-revalidate";
    private static final CacheControl CC_NO_CACHE = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private static final Logger logger = LoggerFactory.getLogger(RegexMatchTestRestResource.class);
    private static final int REGEX_TIMEOUT = 2000;

    @Autowired
    public RegexMatchTestRestResource(ConfigurationService<C> configurationService, PrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
        this.configurationService = configurationService;
    }

    @PUT
    @Path(value="/checkmatch/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response check(RegexMatchTestData testData, @Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, null);
        if (testData.getInput() != null) {
            String value = testData.isIncludeQueryString() ? testData.getInput() : testData.getInput().split("\\?")[0];
            int index = 0;
            for (String regex : testData.getInputList()) {
                try {
                    if (BoundedRegex.matches((String)regex, (String)value, (long)2000L)) {
                        logger.debug("Match with Regex {}", (Object)(index + 1));
                        return Response.ok((Object)new RegexMatchTestResult(true, "Match with Regex " + (index + 1), index, index)).cacheControl(CC_NO_CACHE).build();
                    }
                }
                catch (Exception e) {
                    logger.debug("Regex is invalid", (Throwable)e);
                    return Response.ok((Object)new RegexMatchTestResult(false, "Regex is invalid: " + e.getMessage(), index, index)).cacheControl(CC_NO_CACHE).build();
                }
                ++index;
            }
        }
        return Response.ok((Object)new RegexMatchTestResult(false, "No Match", -1, -1)).cacheControl(CC_NO_CACHE).build();
    }
}

