/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.websudo;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.atlasplugins.samlsso.websudo.WebSudoService;
import de.resolution.commons.util.StringUtil;
import de.resolution.samlauth.api.AdditionalAuthenticationService;
import de.resolution.samlauth.api.AdditionalAuthenticationStatus;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebSudoServlet
extends BasicServlet {
    private static final Logger logger = LoggerFactory.getLogger(WebSudoServlet.class);
    private final AdditionalAuthenticationService additionalAuthenticationService;
    private final WebSudoService webSudoService;
    private final AuthenticationTrackerRepository trackerRepository;

    @Autowired
    public WebSudoServlet(SamlSsoService samlSsoService, AuthenticationTrackerRepository trackerRepository, AdditionalAuthenticationService additionalAuthenticationService, WebSudoService webSudoService, @ComponentImport TemplateRenderer renderer) {
        super(samlSsoService, renderer);
        this.additionalAuthenticationService = additionalAuthenticationService;
        this.webSudoService = webSudoService;
        this.trackerRepository = trackerRepository;
    }

    @Override
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this.sendGeneralError(response, 400, "There is no active session.");
            return;
        }
        String notSanitizedWebSudoDestinationParameter = request.getParameter("webSudoDestination");
        if (logger.isDebugEnabled()) {
            logger.debug("webSudoDestination-parameter is {}", (Object)StringUtil.sanitize((String)notSanitizedWebSudoDestinationParameter));
        }
        String trackerIdAttr = (String)session.getAttribute("tracker");
        AuthenticationTracker tracker = (AuthenticationTracker)this.trackerRepository.getOrCreateNewTracker(StringUtil.sanitize((String)trackerIdAttr));
        String webSudoDestination = this.samlSsoService.getRedirectURL(request, notSanitizedWebSudoDestinationParameter, tracker);
        if (logger.isDebugEnabled()) {
            logger.debug("Websudo Destination is {}", (Object)StringUtil.sanitize((String)webSudoDestination));
        }
        if (!this.webSudoService.isEnabled()) {
            logger.debug("Websudo is not enabled");
            response.sendRedirect(webSudoDestination);
            return;
        }
        if (this.webSudoService.hasValidSession(session)) {
            logger.debug("Websudo is already active");
            response.sendRedirect(webSudoDestination);
            return;
        }
        String token = request.getParameter("token");
        String statusId = this.webSudoService.getStatusId(token);
        if (statusId == null) {
            this.sendGeneralError(response, 401, "Could not find an AdditionalAuthenticationResult for token " + token);
            return;
        }
        AdditionalAuthenticationStatus additionalAuthenticationStatus = this.additionalAuthenticationService.getStatus(statusId);
        if (additionalAuthenticationStatus == null) {
            this.sendGeneralError(response, 401, "Could not find an AdditionalAuthenticationResult for with id " + statusId);
            return;
        }
        if (!additionalAuthenticationStatus.isConfirmed()) {
            this.sendGeneralError(response, 401, "The additional authentication was not confirmed.");
            return;
        }
        if (!additionalAuthenticationStatus.isSuccess()) {
            this.sendGeneralError(response, 401, "The additional authentication was NOT successful: " + additionalAuthenticationStatus.getStatusMessage());
            return;
        }
        if (!this.additionalAuthenticationService.isSameSession(additionalAuthenticationStatus, request)) {
            this.sendGeneralError(response, 401, "The authentication happened in a different session");
            return;
        }
        this.webSudoService.startSession(request, response);
        logger.debug("Started WebSudo-Session");
        response.sendRedirect(webSudoDestination);
    }
}

