/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.oauth;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oauth.KeyValue;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oauth2.PkceType;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.OAuthFlow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude
public class OAuth2IdpConfigurationData
extends CommonIdpConfigurationData {
    public String clientId;
    public String clientSecret;
    public OAuthFlow oAuthFlow = OAuthFlow.AUTHN_CODE;
    public List<String> scopes = new ArrayList<String>();
    public String authEndpoint;
    public String tokenEndpoint;
    public List<String> userInfoEndpoints = new ArrayList<String>();
    public boolean fetchUserInfo = true;
    public List<KeyValue> additionalAuthEndpointRequestParameters = new ArrayList<KeyValue>();
    public List<KeyValue> additionalTokenEndpointRequestParameters = new ArrayList<KeyValue>();
    public List<KeyValue> additionalUserInfoEndpointRequestParameters = new ArrayList<KeyValue>();
    public List<KeyValue> authEndpointRequestHeaders = new ArrayList<KeyValue>();
    public List<KeyValue> tokenEndpointRequestHeaders = new ArrayList<KeyValue>();
    public List<KeyValue> userInfoEndpointRequestHeaders = new ArrayList<KeyValue>();
    public String authScheme = "Bearer";
    public boolean usePkce = false;
    public PkceType pkceMethod = PkceType.S256;
    public boolean doSingleLogout = false;
    public String endSessionEndpoint;

    public OAuth2IdpConfigurationData(OAuth2IdpConfigurationData other) {
        super(other);
        this.clientId = other.clientId;
        this.clientSecret = other.clientSecret;
        this.oAuthFlow = other.oAuthFlow;
        this.scopes = new ArrayList<String>(other.scopes);
        this.authEndpoint = other.authEndpoint;
        this.tokenEndpoint = other.tokenEndpoint;
        this.userInfoEndpoints = other.userInfoEndpoints != null ? new ArrayList<String>(other.userInfoEndpoints) : Collections.emptyList();
        this.fetchUserInfo = other.fetchUserInfo;
        this.additionalAuthEndpointRequestParameters = new ArrayList<KeyValue>(other.additionalAuthEndpointRequestParameters);
        this.additionalTokenEndpointRequestParameters = new ArrayList<KeyValue>(other.additionalTokenEndpointRequestParameters);
        this.additionalUserInfoEndpointRequestParameters = new ArrayList<KeyValue>(other.additionalUserInfoEndpointRequestParameters);
        this.authEndpointRequestHeaders = new ArrayList<KeyValue>(other.authEndpointRequestHeaders);
        this.tokenEndpointRequestHeaders = new ArrayList<KeyValue>(other.tokenEndpointRequestHeaders);
        this.userInfoEndpointRequestHeaders = new ArrayList<KeyValue>(other.userInfoEndpointRequestHeaders);
        this.authScheme = other.authScheme;
        this.usePkce = other.usePkce;
        this.pkceMethod = other.pkceMethod;
        this.idpId = other.clientId;
        this.doSingleLogout = other.doSingleLogout;
        this.endSessionEndpoint = other.endSessionEndpoint;
    }

    public OAuth2IdpConfigurationData() {
        this.enableAdditionalAuthentication = false;
    }
}

