/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bitbucket.userauth;

import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessHandler;
import com.atlassian.bitbucket.auth.RememberMeService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent(value="BitbucketSsoAuthenticationSuccessHandler")
public class BitbucketSsoAuthenticationSuccessHandler
implements HttpAuthenticationSuccessHandler {
    private final RememberMeService rememberMeService;
    private final RunningConfiguration pluginConfiguration;
    private final UserAdminService userAdminService;
    private final SecurityService securityService;

    @Autowired
    public BitbucketSsoAuthenticationSuccessHandler(@BitbucketImport RememberMeService rememberMeService, RunningConfiguration pluginConfiguration, @BitbucketImport UserAdminService userAdminService, @BitbucketImport SecurityService securityService) {
        this.rememberMeService = rememberMeService;
        this.pluginConfiguration = pluginConfiguration;
        this.userAdminService = userAdminService;
        this.securityService = securityService;
    }

    public boolean onAuthenticationSuccess(@Nonnull HttpAuthenticationSuccessContext context) {
        HttpServletRequest request = context.getRequest();
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        String ssoAuthenticated = (String)session.getAttribute("ssoAuthenticated");
        if (ssoAuthenticated != null && ssoAuthenticated.equals("true")) {
            this.securityService.withPermission(Permission.SYS_ADMIN, "reset captcha on successful login").call(() -> {
                String username = context.getUser().getName();
                this.userAdminService.clearCaptchaChallenge(username);
                return null;
            });
            if (this.pluginConfiguration.isSetRememberMeCookie()) {
                this.rememberMeService.createCookie(context.getRequest(), context.getResponse());
            }
        }
        return false;
    }
}

