/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.resolution.samlwrapper.api.LoginInformation;
import de.resolution.commons.data.StructuredData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ImmutableLoginInformation
implements LoginInformation {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String nameId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String sessionIndex;
    private final String idp;
    private final String relayState;
    private final StructuredData attributes;

    @JsonCreator
    public ImmutableLoginInformation(@JsonProperty(value="nameId") String nameId, @JsonProperty(value="attributesAsString") JsonNode attributes, @JsonProperty(value="idp") String idp, @JsonProperty(value="relayState") String relayState, @JsonProperty(value="sessionIndex") String sessionIndex) {
        this.nameId = nameId;
        this.sessionIndex = sessionIndex;
        this.idp = idp;
        this.relayState = relayState;
        this.attributes = attributes != null ? StructuredData.parseJson((String)attributes.toString()) : StructuredData.create();
        if (nameId != null) {
            this.attributes.put((Object)"ATTR_NAMEID", Collections.singletonList(nameId));
        }
    }

    public String getNameId() {
        return this.nameId;
    }

    public String getIdp() {
        return this.idp;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public StructuredData getAttributes() {
        return this.attributes;
    }

    public List<String> getAttributeValues(String key) {
        StructuredData values = this.attributes.asMap().get((Object)key);
        if (values == null) {
            return new ArrayList<String>();
        }
        return values.asStringList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NameId: ").append(this.nameId).append("\n");
        sb.append("IdP: ").append(this.idp).append("\n");
        sb.append("SessionIndex: ").append(this.sessionIndex).append("\n");
        sb.append("RelayState: ").append(this.relayState).append("\n");
        sb.append("Attributes: \n");
        for (String key : this.attributes.asMap().keySet()) {
            sb.append("  ").append(key).append(": ");
            for (String value : this.attributes.asMap().get((Object)key).asStringList()) {
                sb.append(value).append("|");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

