/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.NameAndValue;
import com.resolution.atlasplugins.samlsso.RedirectChecker;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.cleanup.CleanupJobScheduler;
import com.resolution.atlasplugins.samlsso.cluster.ClusterNotificationListener;
import com.resolution.atlasplugins.samlsso.cluster.ClusterNotificator;
import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfigurationListener;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.SamlRunningIdPConfiguration;
import com.resolution.atlasplugins.samlsso.idpselection.IdpByRequestHeaderSelector;
import com.resolution.atlasplugins.samlsso.servlet.InvalidUrlException;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.samlwrapper.api.ResponseIDStore;
import com.resolution.samlwrapper.api.SAMLWrapper;
import com.resolution.samlwrapper.api.SAMLWrapperConfiguration;
import com.resolution.samlwrapper.api.SAMLWrapperIdpConfiguration;
import com.resolution.samlwrapper.api.exception.MetadataException;
import com.resolution.samlwrapper.api.exception.SAMLWrapperException;
import com.resolution.samlwrapper.api.metadata.MetadataInformation;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTrackerRepository;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.util.boundedregex.BoundedRegex;
import de.resolution.commons.util.boundedregex.TimeoutExceededException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSamlSsoService
implements PluginConfigurationListener,
ClusterNotificationListener,
SamlSsoService,
SAMLWrapperConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSamlSsoService.class);
    private static final String CONFIG_UPDATED_MESSAGE = "configUpdated";
    private static final String CONFIG_CLEARED_MESSAGE = "configCleared";
    private static final String UTF8 = "UTF-8";
    private boolean loadedFirstTime = false;
    private boolean initialized = false;
    protected final RunningConfiguration runningConfiguration;
    protected final ApplicationProperties applicationProperties;
    private final ClusterNotificator clusterNotificator;
    protected final TemplateRenderer templateRenderer;
    protected final SAMLWrapper samlWrapper;
    private final AuthenticationTrackerRepository authenticationTrackerRepository;
    protected final IdpByRequestHeaderSelector idpByRequestHeaderSelector;

    protected AbstractSamlSsoService(SAMLWrapper samlWrapper, RunningConfiguration runningConfiguration, ApplicationProperties applicationProperties, ClusterNotificator clusterNotificator, TemplateRenderer templateRenderer, ResponseIDStore responseIdStore, AuthenticationTrackerRepository authenticationTrackerRepository, IdpByRequestHeaderSelector idpByRequestHeaderSelector, CleanupJobScheduler cleanupJobScheduler) {
        this.authenticationTrackerRepository = authenticationTrackerRepository;
        this.idpByRequestHeaderSelector = idpByRequestHeaderSelector;
        cleanupJobScheduler.scheduleCleanup();
        this.samlWrapper = samlWrapper;
        logger.debug("Setting Response ID Store {}", (Object)responseIdStore.getClass().getName());
        this.samlWrapper.setResponseIDStore(responseIdStore);
        this.runningConfiguration = runningConfiguration;
        this.runningConfiguration.addListener(this);
        this.applicationProperties = applicationProperties;
        this.clusterNotificator = clusterNotificator;
        if (this.clusterNotificator != null) {
            this.clusterNotificator.register(this);
        }
        this.templateRenderer = templateRenderer;
        this.applyConfiguration();
        logger.debug("Finished constructing SamlSsoService");
    }

    @Override
    public String getCanonicalSSOURL() {
        return this.getCanonicalBaseUrl() + "/plugins/servlet/samlsso";
    }

    @Override
    public String getAbsoluteSsoURL() {
        return this.getAbsoluteBaseUrl() + "/plugins/servlet/samlsso";
    }

    public String getPostBindingURL() {
        String url = this.getCanonicalBaseUrl() + "/plugins/servlet/samlsso";
        logger.debug("Returning Post binding URL {}", (Object)url);
        return url;
    }

    public String getRedirectBindingURL() {
        String url = this.getCanonicalBaseUrl() + "/plugins/servlet/samlsso";
        logger.debug("Returning Redirect binding URL {}", (Object)url);
        return url;
    }

    public String getEntityId() {
        return this.runningConfiguration.getEntityId();
    }

    @Override
    public String getRelativeInitiateSSOUrl() {
        return this.getRelativeBaseUrl() + "/plugins/servlet/samlsso";
    }

    @Override
    public String getRelativeLoggedOutPageUrl() {
        return this.getRelativeBaseUrl() + "/plugins/servlet/samlsso/loggedoutpage";
    }

    public List<? extends SAMLWrapperIdpConfiguration> getSamlIdPConfigurations() {
        return this.runningConfiguration.getRunningIdPConfigurations().stream().filter(SamlRunningIdPConfiguration.class::isInstance).map(SamlRunningIdPConfiguration.class::cast).collect(Collectors.toList());
    }

    public List<CommonRunningIdpConfiguration> getAllIdpConfigurations() {
        return new ArrayList<CommonRunningIdpConfiguration>(this.runningConfiguration.getRunningIdPConfigurations());
    }

    public SAMLWrapperIdpConfiguration getFirstSamlIdPConfiguration() {
        List<? extends SAMLWrapperIdpConfiguration> idpConfigurations = this.getSamlIdPConfigurations();
        if (idpConfigurations.isEmpty()) {
            return null;
        }
        return idpConfigurations.get(0);
    }

    public MetadataInformation getMetadataInformation() {
        return this.runningConfiguration.getMetadataInformation();
    }

    public String getCertificatePEM() {
        return this.runningConfiguration.getCertificatePEM();
    }

    public String getPrivateKeyPEM() {
        return this.runningConfiguration.getPrivateKeyPEM();
    }

    public boolean isIncludeEncryptionCertificateInMetadata() {
        return this.runningConfiguration.isIncludeEncryptionCertificateInMetadata();
    }

    public boolean isIncludeSigningCertificateInMetadata() {
        return this.runningConfiguration.isIncludeSigningCertificateInMetadata();
    }

    public boolean isIncludeLogoutUrlInMetadata() {
        return this.runningConfiguration.isIncludeLogoutUrlInMetadata();
    }

    public SAMLWrapperIdpConfiguration getSAMLWrapperIdpConfigurationByEntityId(String entityID) {
        List res = this.runningConfiguration.getRunningIdPConfigurations().stream().filter(cfg -> cfg.getIdpId().equals(entityID)).collect(Collectors.toList());
        if (res.isEmpty()) {
            logger.error("Could not find a SAML config");
            return null;
        }
        if (res.size() > 1) {
            logger.error("Found more than one config with the same entity id. Returning the first");
        }
        return (SAMLWrapperIdpConfiguration)res.get(0);
    }

    @Override
    public String getRelativeRedirectUrlForLogin(HttpServletRequest request) throws TimeoutExceededException, InvalidUrlException {
        return this.getRelativeRedirectUrlForLogin(request, this.getRelativeDefaultLoginPageUrl());
    }

    protected abstract String getRelativeDefaultLoginPageUrl();

    protected boolean matchesDefaultLoginPageUrl(@Nonnull String path) {
        return path.contains(this.getRelativeDefaultLoginPageUrl());
    }

    protected String getRelativeRedirectUrlForLogin(HttpServletRequest request, String loginPageName) throws TimeoutExceededException, InvalidUrlException {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        String path = requestURI.substring(contextPath.length());
        String queryString = request.getQueryString();
        if (this.runningConfiguration.isBlockUrlsWithPathParameters() && path.contains(";")) {
            logger.warn("Path {} contains ;. Blocking this request as it is very likely to be malicous", (Object)path);
            throw new InvalidUrlException(path);
        }
        String pathWithQueryString = queryString == null || queryString.trim().isEmpty() ? path : path + "?" + queryString;
        if (this.matchesDefaultLoginPageUrl(path)) {
            String referer = request.getHeader("referer");
            logger.debug("REFERER   === {}", (Object)referer);
            if (referer != null && this.matchesDefaultLoginPageUrl(referer)) {
                logger.debug("Referer {} contains {}, not redirecting", (Object)referer, (Object)loginPageName);
                return null;
            }
            String osDestination = request.getParameter("os_destination");
            if (osDestination == null) {
                osDestination = request.getParameter("next");
            }
            if (osDestination == null) {
                osDestination = request.getParameter("nextUrl");
            }
            if (osDestination == null) {
                HttpSession session;
                String origUrl = request.getParameter("origUrl");
                if (origUrl == null && (session = request.getSession(false)) != null) {
                    origUrl = (String)session.getAttribute("com.cenqua.fisheye.web.LoginServlet.ORIG_URL");
                }
                if (origUrl != null && origUrl.length() > 0) {
                    osDestination = contextPath.length() > 0 && origUrl.startsWith(contextPath) ? origUrl.substring(contextPath.length()) : (origUrl.startsWith(this.getAbsoluteBaseUrl()) ? origUrl.substring(this.getAbsoluteBaseUrl().length()) : origUrl);
                }
            }
            if (osDestination == null) {
                logger.debug("os_destination was null, returning {}", (Object)this.getRelativeInitiateSSOUrl());
                return this.getRelativeInitiateSSOUrl();
            }
            String osDestinationForNonSSOUrlCheck = osDestination = RedirectChecker.adjustOsDestinationIfNecessary(osDestination);
            if (!this.runningConfiguration.isIncludeQueryStringForEnforceSsoDestinations() && osDestinationForNonSSOUrlCheck.contains("?")) {
                osDestinationForNonSSOUrlCheck = osDestinationForNonSSOUrlCheck.substring(0, osDestinationForNonSSOUrlCheck.indexOf(63));
            }
            if (this.getNonSSOCheckResult(osDestinationForNonSSOUrlCheck)) {
                return null;
            }
            String encodedOsDestination = null;
            try {
                encodedOsDestination = URLEncoder.encode(osDestination, UTF8);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("URLencoding failed, THIS SHOULD NEVER HAPPEN!", (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Encoding destination from {} to {}", (Object)StringUtil.sanitize((String)osDestination), (Object)StringUtil.sanitize((String)encodedOsDestination));
            }
            logger.debug("Returning {}?redirectTo={}", (Object)this.getRelativeInitiateSSOUrl(), (Object)encodedOsDestination);
            return this.getRelativeInitiateSSOUrl() + "?redirectTo=" + encodedOsDestination;
        }
        String stringToMatch = this.runningConfiguration.isIncludeQueryStringForEnforceSsoDestinations() ? pathWithQueryString : path;
        for (String enforcedSsoDestination : this.runningConfiguration.getEnforceSsoDestinations()) {
            try {
                if (!BoundedRegex.matches((String)enforcedSsoDestination, (String)stringToMatch, (long)this.getRegexTimeout())) continue;
                if (this.getNonSSOCheckResult(stringToMatch)) {
                    return null;
                }
                String encodedPathWithQueryString = null;
                try {
                    encodedPathWithQueryString = URLEncoder.encode(pathWithQueryString, UTF8);
                }
                catch (UnsupportedEncodingException e) {
                    logger.error("URLencoding failed, THIS SHOULD NEVER HAPPEN!", (Throwable)e);
                }
                String redirectURL = this.getRelativeInitiateSSOUrl() + "?redirectTo=" + encodedPathWithQueryString;
                logger.debug("URL matched erforced SSO Regex {}, redirecting to {}", (Object)path, (Object)redirectURL);
                return redirectURL;
            }
            catch (PatternSyntaxException e) {
                logger.error("Force SSO Pattern {} is invalid: {}", (Object)enforcedSsoDestination, (Object)e.getMessage());
            }
        }
        return null;
    }

    private boolean getNonSSOCheckResult(@Nullable String stringToMatch) throws TimeoutExceededException {
        if (logger.isDebugEnabled()) {
            logger.debug("Checking if URL {} is Non-SSO.", (Object)StringUtil.sanitize((String)stringToMatch));
        }
        for (String nonSsoDestination : this.runningConfiguration.getNonSsoDestinations()) {
            try {
                if (stringToMatch == null || !BoundedRegex.matches((String)nonSsoDestination, (String)stringToMatch, (long)this.getRegexTimeout())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Not redirecting, this is a non-sso link url, which will always win over force-sso urls: {}", (Object)StringUtil.sanitize((String)stringToMatch));
                }
                return true;
            }
            catch (PatternSyntaxException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Force SSO Pattern {} is invalid: {}", (Object)StringUtil.sanitize((String)nonSsoDestination), (Object)StringUtil.sanitize((String)e.getMessage()));
                }
                return false;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("URL {} was not found in configuration as Non-SSO URL.", (Object)StringUtil.sanitize((String)stringToMatch));
        }
        return false;
    }

    @Override
    public SAMLWrapper getSamlWrapper() {
        return this.samlWrapper;
    }

    @Override
    public String generateSamlMetadata(int idpId) throws SAMLWrapperException {
        if (!this.initialized) {
            logger.warn("SAML Single Sign On is not initialized, cannot create metadata!");
            throw new MetadataException("SAML Single Sign On is not initialized, cannot create metadata!");
        }
        return this.samlWrapper.createMetadata(this.getPostBindingURL(), this.getEntityId(), idpId);
    }

    @Override
    public boolean isReady() {
        return this.initialized && this.runningConfiguration.isValid();
    }

    @Override
    public String getCanonicalBaseUrl() {
        String url = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        logger.trace("returning canonical base URL {}", (Object)url);
        return url;
    }

    @Override
    public String getAbsoluteBaseUrl() {
        String url = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        logger.trace("returning absolute base URL {}", (Object)url);
        return url;
    }

    @Override
    public boolean isHttps() {
        return this.getAbsoluteBaseUrl().startsWith("https://");
    }

    @Override
    public String getRelativeBaseUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
    }

    @Override
    public String getRelativeCanonicalBaseUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.RELATIVE_CANONICAL);
    }

    @Override
    public String getRelativeRedirectURLForRequest(HttpServletRequest request) throws TimeoutExceededException, InvalidUrlException {
        if (logger.isTraceEnabled()) {
            logger.trace("Request is for {} | Request type is {} | ContentType is {} | Message is {}", new Object[]{request.getRequestURL(), request.getMethod(), request.getContentType(), request.getQueryString()});
            String servletPath = request.getServletPath();
            logger.trace("Servlet path is {}", (Object)servletPath);
        }
        if (!this.loadedFirstTime) {
            logger.trace("Not loaded for the first time yet.");
            return null;
        }
        boolean redirectLogin = this.runningConfiguration.isRedirectToSso();
        if (!this.initialized && redirectLogin) {
            logger.warn("The SAMLSSOService is not initialized, no redirection is performed. Check the configuration.");
            return null;
        }
        if (this.runningConfiguration.getOverrideLoggedOutUrlMethod() == RunningConfiguration.OverrideLoggedOutUrlMethod.NO_REDIRECTION && !redirectLogin) {
            return null;
        }
        if (request.getParameter("nosso") != null && this.runningConfiguration.isNossoEnabled()) {
            logger.trace("nosso parameter is present, not redirecting");
            return null;
        }
        if (request.getParameter("auth_fallback") != null && this.runningConfiguration.isNossoEnabled()) {
            logger.trace("auth_fallback parameter is present, not redirecting");
            return null;
        }
        String userAgentHeader = request.getHeader("user-agent");
        for (String nonSsoUserAgent : this.runningConfiguration.getNonSsoUserAgents()) {
            if (userAgentHeader == null || !userAgentHeader.contains(nonSsoUserAgent)) continue;
            logger.trace("Not redirecting, this is a non-sso user agent: {}", (Object)userAgentHeader);
            return null;
        }
        if (this.isLoggedInUser(request)) {
            return this.executeLogout(request);
        }
        if (redirectLogin) {
            return this.getRelativeRedirectUrlForLogin(request);
        }
        logger.trace("Login redirection is disabled, returning null");
        return null;
    }

    @Override
    @Nullable
    public String executeLogout(HttpServletRequest request) {
        if (request.getServletPath().equals(this.getRelativeDefaultLoginPageUrl())) {
            return this.getRelativeBaseUrl() + "/plugins/servlet/samlsso/loggedin";
        }
        boolean noSSO = false;
        HttpSession session = request.getSession(false);
        if (session != null) {
            String idpAttribute = (String)session.getAttribute("identityProvider");
            if (idpAttribute == null || idpAttribute.length() == 0) {
                noSSO = true;
            }
        } else {
            logger.info("isLoggedInUser returned true, but there is no session- not redirecting");
            return null;
        }
        switch (this.runningConfiguration.getOverrideLoggedOutUrlMethod()) {
            case REDIRECT_ALL: {
                return this.getRelativeRedirectUrlForLogout(request);
            }
            case REDIRECT_SSO_ONLY: {
                return noSSO ? null : this.getRelativeRedirectUrlForLogout(request);
            }
        }
        return null;
    }

    @Override
    public void configurationUpdated() {
        this.runningConfiguration.load();
        this.applyConfiguration();
        if (this.clusterNotificator != null) {
            logger.debug("Sending configuration updated message to the cluster");
            this.clusterNotificator.send(CONFIG_UPDATED_MESSAGE);
        }
    }

    @Override
    public void configurationCleared() {
        logger.warn("Configuration was cleared, setting initialized-flag to false");
        this.initialized = false;
        if (this.clusterNotificator != null) {
            logger.debug("Sending configuration cleared message to the cluster");
            this.clusterNotificator.send(CONFIG_CLEARED_MESSAGE);
        }
    }

    @Override
    public void receiveClusterNotification(String message) {
        if (message.equals(CONFIG_UPDATED_MESSAGE)) {
            logger.info("Configuration was updated on other cluster node. Reloading configuration.");
            this.runningConfiguration.load();
            this.applyConfiguration();
        } else if (message.equals(CONFIG_CLEARED_MESSAGE)) {
            logger.warn("Configuration was cleared on other cluster node, setting initialized-flag to false.");
            this.initialized = false;
        } else {
            logger.debug("Received message {} from cluster. Ignoring it.", (Object)message);
        }
    }

    @Override
    public void applyConfiguration() {
        if (this.runningConfiguration.isLoaded()) {
            if (!this.runningConfiguration.isValid()) {
                logger.warn("Configuration is not valid, not initializing.");
                this.initialized = false;
            } else {
                logger.trace("Configuration is valid.");
                if (this.getAllIdpConfigurations().isEmpty()) {
                    logger.warn("There is no IdP-configuration, configuration should be completed");
                }
                try {
                    this.samlWrapper.configure((SAMLWrapperConfiguration)this, (SAMLAuthenticationTrackerRepository)this.authenticationTrackerRepository);
                    this.initialized = true;
                }
                catch (SAMLWrapperException e) {
                    logger.error("Configuring SAMLWrapper failed", (Throwable)e);
                    this.initialized = false;
                }
            }
            this.loadedFirstTime = true;
        } else {
            logger.debug("RunningConfiguration is not loaded yet");
        }
    }

    @Override
    public boolean isJira() {
        return false;
    }

    @Override
    public boolean isJiraServiceDesk() {
        return false;
    }

    @Override
    public boolean isConfluence() {
        return false;
    }

    @Override
    public boolean isBamboo() {
        return false;
    }

    @Override
    public boolean isBitbucket() {
        return false;
    }

    @Override
    public boolean isFecru() {
        return false;
    }

    public boolean isEnforceResponseValidityDates() {
        return this.runningConfiguration.isEnforceResponseValidityDates();
    }

    public int getClockSkew() {
        return this.runningConfiguration.getClockSkew();
    }

    public boolean isEnforceResponseIDUniqueness() {
        return this.runningConfiguration.isEnforceResponseIDUniqueness();
    }

    public boolean isValidateSamlMessageXml() {
        return this.runningConfiguration.isValidateSamlMessageXml();
    }

    @Override
    public RunningConfiguration getRunningConfiguration() {
        return this.runningConfiguration;
    }

    @Override
    public List<String> getUserAttributeKeys() {
        return new ArrayList<String>();
    }

    @Override
    public long getRegexTimeout() {
        return this.runningConfiguration.getRegexTimeout();
    }

    public boolean enableSsoRedirect() {
        if (this.runningConfiguration.isValid()) {
            this.runningConfiguration.setOverrideLoginUrl(true);
            this.runningConfiguration.store();
            return true;
        }
        return false;
    }

    public void disableSsoRedirect() {
        this.runningConfiguration.setOverrideLoginUrl(false);
        if (this.runningConfiguration.isValid()) {
            this.runningConfiguration.store();
        }
    }

    public static boolean headersMatch(Map<String, String> currentHeaders, List<NameAndValue> namesAndValues, long regexTimeout) throws TimeoutExceededException {
        for (NameAndValue nameAndValue : namesAndValues) {
            if (!currentHeaders.containsKey(nameAndValue.name)) continue;
            String value = nameAndValue.value;
            if (value == null || value.trim().isEmpty()) {
                return true;
            }
            if (!BoundedRegex.matches((String)value, (String)currentHeaders.get(nameAndValue.name), (long)regexTimeout)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public String getRedirectURL(@Nonnull HttpServletRequest req, @Nullable String relayState, @Nonnull AuthenticationTracker tracker) {
        String defaultRelativeRedirectUrl = this.getRelativeBaseUrl() + this.getRunningConfiguration().getDefaultRedirectUrl();
        boolean isSkipBaseUrlCheck = this.getRunningConfiguration().isSkipBaseUrlCheck();
        String baseUrlWithSlash = this.getBaseUrlForRequest(req);
        return RedirectChecker.getRedirectURL(this.runningConfiguration.getRedirectCheckerBlockedStrings(), isSkipBaseUrlCheck, baseUrlWithSlash, this.getRelativeBaseUrl(), relayState, defaultRelativeRedirectUrl, tracker);
    }

    @Nonnull
    private String getBaseUrlForRequest(@Nonnull HttpServletRequest req) {
        CommonRunningIdpConfiguration idpConfiguration = null;
        HttpSession session = req.getSession(false);
        if (session != null) {
            String entityId = (String)session.getAttribute("identityProvider");
            if (entityId == null || entityId.isEmpty()) {
                logger.debug("EntityID not present in session.");
            } else {
                idpConfiguration = this.runningConfiguration.getRunningIdpConfiguration(entityId);
                if (idpConfiguration == null) {
                    logger.debug("Could not find idp configuration for EntityID {}", (Object)entityId);
                }
            }
        }
        String baseUrlStr = idpConfiguration != null && idpConfiguration.isUseUrlFromRequest() ? this.getAbsoluteBaseUrl() : this.getCanonicalBaseUrl();
        return baseUrlStr.endsWith("/") ? baseUrlStr : baseUrlStr + "/";
    }

    @Override
    public String getAbsoluteNoSsoUrl() {
        return this.getAbsoluteBaseUrl() + this.getRelativeDefaultLoginPageUrl() + "?nosso";
    }

    public SAMLWrapperConfiguration.TrueFalseNone getWantAssertionsSigned() {
        return this.runningConfiguration.getWantAssertionsSigned();
    }

    public SAMLWrapperConfiguration.TrueFalseNone getAuthnRequestsSigned() {
        return this.runningConfiguration.getAuthnRequestsSigned();
    }

    public boolean isAcceptHolderOfKeyLikeBearer() {
        return this.runningConfiguration.isAcceptHolderOfKeyLikeBearer();
    }
}

