/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.keycloak;

import com.fasterxml.jackson.databind.JsonNode;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.ListStructuredData;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.data.StructuredDataException;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.ConnectorGroup;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.AccessTokenException;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.GeneralSyncException;
import de.resolution.usersync.api.exception.UserRelatedSyncException;
import de.resolution.usersync.builtin.keycloak.KeycloakConnectorConfiguration;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckFailedException;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerHolder;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import de.resolution.usersync.spi.AbstractOAuthClientCredentialsConnector;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakConnector
extends AbstractOAuthClientCredentialsConnector<KeycloakConnectorConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(KeycloakConnector.class);
    public static final String KEYCLOAK_ATTRIBUTE_ID = "id";
    static final String KEYCLOAK_ATTRIBUTE_ENABLED = "enabled";
    static final String KEYCLOAK_ATTRIBUTE_USERNAME = "username";
    static final String KEYCLOAK_ATTRIBUTE_FIRSTNAME = "firstName";
    static final String KEYCLOAK_ATTRIBUTE_LASTNAME = "lastName";
    static final String KEYCLOAK_ATTRIBUTE_EMAIL = "email";
    private static final String PATH_SEGMENT_USERS = "users";
    private static final String PATH_SEGMENT_GROUPS = "groups";
    private static final String PATH_SEGMENT_MEMBERS = "members";
    private static final String QUERY_PARAMETER_FIRST = "first";
    private static final String QUERY_PARAMETER_MAX = "max";
    private static final String MESSAGE_INVALID_BASE_URL = "Invalid base url, please check your settings";
    private static final Script ID_EXPRESSION = StructuredData.prepareFind((String)"id");
    private static final Script NAME_EXPRESSION = StructuredData.prepareFind((String)"name");
    private static final Script PATH_EXPRESSION = StructuredData.prepareFind((String)"path");
    private static final Script KEYCLOAK_ATTRIBUTE_USERNAME_EXPRESSION = StructuredData.prepareFind((String)"username");
    private static final List<String> CONNECTOR_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("id", "username", "enabled", "firstName", "lastName", "email", "GROUPS"));

    protected KeycloakConnector(@Nonnull ConnectorService connectorService, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull KeycloakConnectorConfiguration configuration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/KeycloakConnector.json");
    }

    @Override
    protected void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        try {
            if (this.getRequiredGroupCheckerHolder().hasRequiredGroupsConfigured()) {
                this.fetchUsersFromRequiredGroups(syncFunction, syncStatusFacade);
            } else {
                this.fetchAllUsers(syncFunction, syncStatusFacade);
            }
        }
        catch (GeneralSyncException e) {
            syncStatusFacade.fail(e.getMessage(), e, logger);
        }
    }

    @Override
    @Nonnull
    public Set<ConnectorGroup> fetchRequiredConnectorGroups(@Nonnull RequiredGroupCheckerHolder requiredGroupCheckerHolder, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        int pageGroupCount;
        syncStatusFacade.add("Started processing required groups, please wait...", null, SyncStatusFacade.LogLevel.DEBUG, logger);
        int totalGroupCount = 0;
        HashSet<ConnectorGroup> requiredConnectorGroups = new HashSet<ConnectorGroup>();
        do {
            syncStatusFacade.checkCancel();
            HttpUrl url = this.getUrlBuilderForRealm().addPathSegment(PATH_SEGMENT_GROUPS).addQueryParameter(QUERY_PARAMETER_FIRST, String.valueOf(totalGroupCount)).addQueryParameter(QUERY_PARAMETER_MAX, String.valueOf(((KeycloakConnectorConfiguration)this.configuration).getBatchSize())).build();
            ResponseWrapper responseWrapper = this.performGetRequest(url.toString(), syncStatusFacade);
            if (!responseWrapper.isSuccess()) {
                throw new RequiredGroupCheckFailedException("Fetching required groups failed: " + responseWrapper.getCode() + ": " + responseWrapper.getMessage());
            }
            JsonNode groups = responseWrapper.getBodyAsJsonNode();
            if (!groups.isArray()) {
                throw new RequiredGroupCheckFailedException("Group result is no list");
            }
            pageGroupCount = KeycloakConnector.parseRequiredGroups(groups, requiredGroupCheckerHolder, requiredConnectorGroups);
            if ((totalGroupCount += pageGroupCount) % 100 != 0) continue;
            syncStatusFacade.setStatusMessage("Processed " + totalGroupCount + " groups, please wait...");
        } while (pageGroupCount == ((KeycloakConnectorConfiguration)this.configuration).getBatchSize());
        syncStatusFacade.add("Finished processing " + totalGroupCount + " groups.", null, SyncStatusFacade.LogLevel.DEBUG, logger);
        return requiredConnectorGroups;
    }

    private static int parseRequiredGroups(@Nonnull JsonNode groups, @Nonnull RequiredGroupCheckerHolder requiredGroupCheckerHolder, @Nonnull Set<ConnectorGroup> requiredConnectorGroups) {
        StreamSupport.stream(groups.spliterator(), false).map(KeycloakConnector::createConnectorGroup).filter(Objects::nonNull).filter(connectorGroup -> KeycloakConnector.matchesLocalRequiredGroupChecker(connectorGroup, requiredGroupCheckerHolder)).forEach(requiredConnectorGroups::add);
        StreamSupport.stream(groups.spliterator(), false).forEach(jsonNode -> {
            JsonNode subGroups = jsonNode.path("subGroups");
            KeycloakConnector.parseRequiredGroups(subGroups, requiredGroupCheckerHolder, requiredConnectorGroups);
        });
        return groups.size();
    }

    private void fetchUsersFromRequiredGroups(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        Set<ConnectorGroup> requiredConnectorGroups = this.fetchRequiredConnectorGroups(this.getRequiredGroupCheckerHolder(), syncStatusFacade);
        if (requiredConnectorGroups.isEmpty()) {
            syncStatusFacade.add("No matching required groups found. No users will be synced.", null, SyncStatusFacade.LogLevel.DEBUG, logger);
            return;
        }
        String namesOfRequiredGroups = requiredConnectorGroups.stream().map(ConnectorGroup::getName).filter(Objects::nonNull).collect(Collectors.joining(", "));
        syncStatusFacade.add("Fetch users of " + requiredConnectorGroups.size() + " required groups: " + namesOfRequiredGroups, null, SyncStatusFacade.LogLevel.DEBUG, logger);
        HashSet<String> seenUserIdentifiers = new HashSet<String>();
        for (ConnectorGroup requiredGroup : requiredConnectorGroups) {
            int fetchedUserCountPage;
            int fetchedUserCountTotal = 0;
            do {
                syncStatusFacade.checkCancel();
                HttpUrl url = this.getUrlBuilderForRealm().addPathSegment(PATH_SEGMENT_GROUPS).addPathSegment(requiredGroup.getId()).addPathSegment(PATH_SEGMENT_MEMBERS).addQueryParameter(QUERY_PARAMETER_FIRST, String.valueOf(fetchedUserCountTotal)).addQueryParameter(QUERY_PARAMETER_MAX, String.valueOf(((KeycloakConnectorConfiguration)this.configuration).getBatchSize())).build();
                fetchedUserCountPage = this.fetchUsersPage(syncFunction, syncStatusFacade, url.toString(), seenUserIdentifiers);
                fetchedUserCountTotal += fetchedUserCountPage;
            } while (fetchedUserCountPage == ((KeycloakConnectorConfiguration)this.configuration).getBatchSize());
        }
    }

    private void fetchAllUsers(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        int fetchedUserCountPage;
        syncStatusFacade.add("Fetching users", SyncStatusFacade.LogLevel.DEBUG, logger);
        int fetchedUserCountTotal = 0;
        do {
            syncStatusFacade.checkCancel();
            HttpUrl url = this.getUrlBuilderForRealm().addPathSegment(PATH_SEGMENT_USERS).addQueryParameter(QUERY_PARAMETER_FIRST, String.valueOf(fetchedUserCountTotal)).addQueryParameter(QUERY_PARAMETER_MAX, String.valueOf(((KeycloakConnectorConfiguration)this.configuration).getBatchSize())).build();
            fetchedUserCountPage = this.fetchUsersPage(syncFunction, syncStatusFacade, url.toString(), new HashSet<String>());
            fetchedUserCountTotal += fetchedUserCountPage;
        } while (fetchedUserCountPage == ((KeycloakConnectorConfiguration)this.configuration).getBatchSize());
    }

    private int fetchUsersPage(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade, @Nonnull String url, @Nonnull Set<String> seenUserIdentifiers) throws GeneralSyncException {
        ResponseWrapper responseWrapper = this.performGetRequest(url, syncStatusFacade);
        if (!responseWrapper.isSuccess()) {
            syncStatusFacade.fail("Fetching users failed", responseWrapper.getCode(), responseWrapper.getMessage(), responseWrapper.getBody(), logger);
            return -1;
        }
        StructuredData responseData = responseWrapper.getBodyAsStructuredData();
        ListStructuredData userList = responseData.asList();
        for (StructuredData userData : userList) {
            syncStatusFacade.checkCancel();
            String userid = userData.findString(ID_EXPRESSION);
            if (userid == null) {
                if (!logger.isDebugEnabled()) continue;
                syncStatusFacade.add("Skipping user with empty id", SyncStatusFacade.LogLevel.DEBUG, logger);
                continue;
            }
            if (seenUserIdentifiers.contains(userid)) {
                logger.debug("Skipping already seen user {}", (Object)userid);
                continue;
            }
            seenUserIdentifiers.add(userid);
            try {
                MapStructuredData userMap = userData.asMap();
                Set<ConnectorGroup> groups = this.fetchGroupsForUser(userid, syncStatusFacade);
                userMap.put((Object)"GROUPS", this.extractGroupNamesFromGroup(groups));
                syncFunction.accept(userMap);
            }
            catch (UserRelatedSyncException e) {
                logger.error("Fetching groups for user {} failed, user attributes: {}", new Object[]{userid, JSONUtil.asJson((Object)userData), e});
                syncStatusFacade.failPartially("Fetching groups for user " + userid + "failed", e, logger);
            }
        }
        return userList.size();
    }

    @Nonnull
    private Set<ConnectorGroup> fetchGroupsForUser(@Nonnull String identifier, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException, UserRelatedSyncException {
        int fetchedGroupsCount;
        HashSet<ConnectorGroup> allGroups = new HashSet<ConnectorGroup>();
        do {
            syncStatusFacade.checkCancel();
            Set<ConnectorGroup> groupsPage = this.fetchGroupsForUserPage(identifier, allGroups.size(), syncStatusFacade);
            fetchedGroupsCount = groupsPage.size();
            allGroups.addAll(groupsPage);
        } while (fetchedGroupsCount == ((KeycloakConnectorConfiguration)this.configuration).getBatchSize());
        return allGroups;
    }

    @Nonnull
    private Set<ConnectorGroup> fetchGroupsForUserPage(@Nonnull String identifier, int offset, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException, UserRelatedSyncException {
        HttpUrl url = this.getUrlBuilderForRealm().addPathSegment(PATH_SEGMENT_USERS).addPathSegment(identifier).addPathSegment(PATH_SEGMENT_GROUPS).addQueryParameter(QUERY_PARAMETER_FIRST, String.valueOf(offset)).addQueryParameter(QUERY_PARAMETER_MAX, String.valueOf(((KeycloakConnectorConfiguration)this.configuration).getBatchSize())).build();
        ResponseWrapper responseWrapper = this.performGetRequest(url.toString(), syncStatusFacade);
        if (!responseWrapper.isSuccess()) {
            throw new UserRelatedSyncException("Fetching groups failed for user <" + identifier + "> " + responseWrapper.getMessage());
        }
        JsonNode groups = responseWrapper.getBodyAsJsonNode();
        return StreamSupport.stream(groups.spliterator(), false).map(KeycloakConnector::createConnectorGroup).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nullable
    private static ConnectorGroup createConnectorGroup(@Nonnull JsonNode group) {
        String id = group.path(KEYCLOAK_ATTRIBUTE_ID).asText();
        String name = group.path("name").asText();
        if (StringUtil.isNullOrEmpty((String)id)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invalid group, id is null or empty: {}", (Object)JSONUtil.asJson((Object)group));
            }
            return null;
        }
        return new ConnectorGroup(id, name, JSONUtil.asJson((Object)group));
    }

    @Nonnull
    private Set<String> extractGroupNamesFromGroup(@Nonnull Set<ConnectorGroup> groups) {
        return groups.stream().map(ConnectorGroup::getGroupDataAsStructuredData).map(groupData -> {
            HashSet<String> groupNames = new HashSet<String>();
            if (((KeycloakConnectorConfiguration)this.configuration).isFetchNestedGroups()) {
                String path = groupData.findString(PATH_EXPRESSION);
                if (!StringUtil.isNullOrEmpty((String)path)) {
                    String[] pathSegments;
                    for (String groupName : pathSegments = path.split("/")) {
                        if (StringUtil.isNullOrEmpty((String)groupName)) continue;
                        groupNames.add(groupName);
                    }
                }
            } else {
                String name = groupData.findString(NAME_EXPRESSION);
                if (!StringUtil.isNullOrEmpty((String)name)) {
                    groupNames.add(name);
                }
            }
            return groupNames;
        }).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Nonnull
    private HttpUrl.Builder getUrlBuilderForRealm() throws GeneralSyncException {
        HttpUrl url = HttpUrl.parse((String)((KeycloakConnectorConfiguration)this.configuration).getBaseUrl());
        if (url == null) {
            throw new GeneralSyncException(MESSAGE_INVALID_BASE_URL);
        }
        return url.newBuilder().addPathSegment("admin").addPathSegment("realms").addPathSegment(((KeycloakConnectorConfiguration)this.configuration).getRealm());
    }

    @Override
    @Nonnull
    protected FindUserResult findUser(@Nonnull String identifier, @Nullable MapStructuredData additionalData) {
        try {
            this.refreshAccessTokenIfInvalid();
        }
        catch (AccessTokenException e) {
            return FindUserResult.failed(e);
        }
        Pattern p = Pattern.compile("\\b[0-9a-f]{8}\\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\\b[0-9a-f]{12}\\b");
        Matcher m = p.matcher(identifier);
        try {
            StructuredData userData = m.matches() ? this.findUserById(identifier, SyncStatusFacade.nullFacade()) : this.findUserByUsername(identifier, SyncStatusFacade.nullFacade());
            if (userData == null) {
                return FindUserResult.notFound();
            }
            String userIdentifier = userData.findString(ID_EXPRESSION);
            if (userIdentifier == null) {
                return FindUserResult.failed("Returned user has no attribute id");
            }
            Set<ConnectorGroup> groups = this.fetchGroupsForUser(userIdentifier, SyncStatusFacade.nullFacade());
            userData.put((Object)"GROUPS", this.extractGroupNamesFromGroup(groups));
            if (((KeycloakConnectorConfiguration)this.configuration).isIgnoreRequiredConnectorGroupsOnSingleUserSync() || this.matchesLocalRequiredGroupChecker(groups)) {
                return FindUserResult.found(userData);
            }
            return FindUserResult.preFiltered(userData);
        }
        catch (StructuredDataException | GeneralSyncException | UserRelatedSyncException e) {
            return FindUserResult.failed(e.getMessage());
        }
    }

    @Nullable
    private StructuredData findUserById(@Nonnull String identifier, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException, UserRelatedSyncException {
        HttpUrl url = this.getUrlBuilderForRealm().addPathSegment(PATH_SEGMENT_USERS).addPathSegment(identifier).build();
        ResponseWrapper responseWrapper = this.performGetRequest(url.toString(), syncStatusFacade);
        if (responseWrapper.isNotFound()) {
            return null;
        }
        if (!responseWrapper.isSuccess()) {
            throw new UserRelatedSyncException("Request failed: " + responseWrapper.getMessage());
        }
        return responseWrapper.getBodyAsStructuredData();
    }

    @Nullable
    private StructuredData findUserByUsername(@Nonnull String identifier, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException, UserRelatedSyncException {
        HttpUrl url = this.getUrlBuilderForRealm().addPathSegment(PATH_SEGMENT_USERS).addQueryParameter(KEYCLOAK_ATTRIBUTE_USERNAME, identifier).build();
        ResponseWrapper responseWrapper = this.performGetRequest(url.toString(), syncStatusFacade);
        if (responseWrapper.isNotFound()) {
            return null;
        }
        if (!responseWrapper.isSuccess()) {
            throw new UserRelatedSyncException("Request failed: " + responseWrapper.getMessage());
        }
        ListStructuredData userList = responseWrapper.getBodyAsStructuredData().asList();
        if (userList.isEmpty()) {
            return null;
        }
        if (userList.size() == 1) {
            return (StructuredData)userList.get(0);
        }
        for (StructuredData current : userList) {
            if (!identifier.equals(current.findString(KEYCLOAK_ATTRIBUTE_USERNAME_EXPRESSION))) continue;
            return current;
        }
        return null;
    }

    @Override
    @Nonnull
    protected String getTokenUrl() {
        HttpUrl tokenUrl = Objects.requireNonNull(HttpUrl.parse((String)((KeycloakConnectorConfiguration)this.configuration).getBaseUrl())).newBuilder().addPathSegment("realms").addPathSegment(((KeycloakConnectorConfiguration)this.configuration).getRealm()).addPathSegments("protocol/openid-connect/token").build();
        logger.debug("Keycloak token URL is {}", (Object)tokenUrl);
        return tokenUrl.toString();
    }

    @Override
    @Nonnull
    protected Optional<String> getScope() {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Class<KeycloakConnectorConfiguration> getConfigurationClass() {
        return KeycloakConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "Keycloak";
    }

    @Override
    public List<String> getConnectorAttributes() {
        return CONNECTOR_ATTRIBUTES;
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return true;
    }

    @Override
    public boolean isCanUseRequiredConnectorGroupsGroovy() {
        return true;
    }

    @Override
    public boolean isCanFetchRequiredConnectorGroups() {
        return true;
    }

    @Override
    @Nonnull
    public List<ConnectionTestResultEntity.EndpointResult> doConnectionTest() {
        String identifier;
        ArrayList<ConnectionTestResultEntity.EndpointResult> tests = new ArrayList<ConnectionTestResultEntity.EndpointResult>();
        ConnectionTestResultEntity.EndpointResult accessTokenTest = this.doAccessTokenConnectionTest();
        tests.add(accessTokenTest);
        if (!accessTokenTest.isSuccess()) {
            return tests;
        }
        MapStructuredData userData = StructuredData.create();
        try {
            HttpUrl url = this.getUrlBuilderForRealm().addPathSegment(PATH_SEGMENT_USERS).addQueryParameter(QUERY_PARAMETER_FIRST, String.valueOf(0)).addQueryParameter(QUERY_PARAMETER_MAX, String.valueOf(1)).build();
            ResponseWrapper resp = this.performGetRequest(url.toString(), SyncStatusFacade.nullFacade());
            tests.add(ConnectionTestResultEntity.EndpointResult.create("Fetch User", url.toString(), resp.isSuccess(), String.valueOf(resp.getCode()), resp.getBody()));
            if (resp.isSuccess()) {
                userData = resp.getBodyAsStructuredData();
            }
        }
        catch (GeneralSyncException e) {
            tests.add(ConnectionTestResultEntity.EndpointResult.create("Fetch User", "", false, "FAIL", e.getMessage()));
            return tests;
        }
        String fetchGroup = "Fetch Group";
        try {
            identifier = userData.asList().get(0).asMap().get((Object)KEYCLOAK_ATTRIBUTE_ID).asString();
        }
        catch (Exception e) {
            tests.add(ConnectionTestResultEntity.EndpointResult.createError(fetchGroup, "", false, "SKIPPED", null, "Cannot run test because we did not get a user from the previous test. There are either no users in your Keycloak or the previous test failed."));
            return tests;
        }
        try {
            HttpUrl url = this.getUrlBuilderForRealm().addPathSegment(PATH_SEGMENT_USERS).addPathSegment(identifier).addPathSegment(PATH_SEGMENT_GROUPS).addQueryParameter(QUERY_PARAMETER_FIRST, String.valueOf(0)).addQueryParameter(QUERY_PARAMETER_MAX, String.valueOf(1)).build();
            ResponseWrapper resp = this.performGetRequest(url.toString(), SyncStatusFacade.nullFacade());
            tests.add(ConnectionTestResultEntity.EndpointResult.create(fetchGroup, url.toString(), resp.isSuccess(), String.valueOf(resp.getCode()), resp.getBody()));
        }
        catch (Exception e) {
            tests.add(ConnectionTestResultEntity.EndpointResult.create(fetchGroup, "", false, "FAIL", e.getMessage()));
        }
        return tests;
    }
}

