/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.ImmutableAtlasUserResult;
import de.resolution.commons.util.JSONUtil;
import de.resolution.usersync.api.GenericUserSyncResult;
import de.resolution.usersync.api.TransformationResults;
import de.resolution.usersync.impl.ImmutableSyncUserResult;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonIgnoreProperties(value={"operation", "success"}, allowGetters=true)
public interface SyncUserResult
extends GenericUserSyncResult {
    public static final int UNKNOWN_ID = -1;

    @Override
    public AtlasUserResult getAtlasUserResult();

    @Override
    public TransformationResults getTransformationResults();

    public boolean isSuccess();

    public AtlasUserResult.Operation getOperation();

    public String getMessage();

    public int getId();

    @JsonCreator
    public static SyncUserResult create(@Nullable @JsonProperty(value="transformationResults") TransformationResults transformationResults, @Nullable @JsonProperty(value="atlasUserResult") ImmutableAtlasUserResult atlasUserResult, @Nullable @JsonProperty(value="message") String message, @Nullable @JsonProperty(value="id") Integer id) {
        return new ImmutableSyncUserResult(transformationResults, (AtlasUserResult)atlasUserResult, message, id);
    }

    public static SyncUserResult create(@Nullable @JsonProperty(value="transformationResults") TransformationResults transformationResults, @Nullable @JsonProperty(value="atlasUserResult") ImmutableAtlasUserResult atlasUserResult, @Nullable @JsonProperty(value="message") String message) {
        return SyncUserResult.create(transformationResults, atlasUserResult, message, null);
    }

    public static SyncUserResult create(@Nonnull TransformationResults transformationResults) {
        return SyncUserResult.create(transformationResults, null, null, null);
    }

    public static SyncUserResult create(@Nonnull TransformationResults transformationResults, String message) {
        return SyncUserResult.create(transformationResults, null, message, null);
    }

    public static SyncUserResult create(@Nonnull AtlasUserResult atlasUserResult) {
        return SyncUserResult.create(TransformationResults.createEmptyNonDrop(), atlasUserResult);
    }

    public static SyncUserResult create(@Nullable TransformationResults transformationResults, @Nullable AtlasUserResult atlasUserResult) {
        return new ImmutableSyncUserResult(transformationResults, atlasUserResult, null, null);
    }

    public static SyncUserResult fromJsonAndId(@Nonnull String resultJson, int id) {
        SyncUserResult fromJson = (SyncUserResult)JSONUtil.fromJson((String)resultJson, SyncUserResult.class);
        return new ImmutableSyncUserResult(fromJson, id);
    }
}

