/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.systeminformation;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.joda.time.DateTime;

@JsonAutoDetect
public class PluginInformationImpl
implements de.resolution.reconfigure.api.PluginInformation {
    private String pluginKey;
    private String version;
    private String hostApplication;
    private String hostApplicationVersion;
    private String licenseType;
    private String licenseSize;
    private String maintenanceExpires;
    private String supportEntitlementNumber;
    private String baseUrl;
    private String requestUrl;
    private String evaluationLicense;
    private static final String UNDEFINED = "UNDEFINED";
    private static final String NONE = "NONE";
    private static final String UNLIMITED = "UNLIMITED";
    private static final String NEVER = "NEVER";

    public PluginInformationImpl(ApplicationProperties applicationProperties, PluginLicenseManager licenseManager, PluginAccessor pluginAccessor, HttpServletRequest request) {
        this.pluginKey = licenseManager.getPluginKey();
        if (licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)licenseManager.getLicense().get();
            this.licenseType = license.getLicenseType().toString();
            this.licenseSize = license.getEdition().isDefined() ? ((Integer)license.getEdition().get()).toString() : UNLIMITED;
            this.maintenanceExpires = license.getMaintenanceExpiryDate().isDefined() ? ((DateTime)license.getMaintenanceExpiryDate().get()).toString() : NEVER;
            this.supportEntitlementNumber = license.getSupportEntitlementNumber().isDefined() ? (String)license.getSupportEntitlementNumber().get() : UNDEFINED;
            this.evaluationLicense = String.valueOf(license.isEvaluation());
        } else {
            this.licenseType = NONE;
            this.licenseSize = NONE;
            this.evaluationLicense = UNDEFINED;
            this.maintenanceExpires = NONE;
        }
        this.baseUrl = applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        this.requestUrl = request != null ? request.getRequestURL().toString() : UNDEFINED;
        Plugin plugin = pluginAccessor.getPlugin(this.pluginKey);
        PluginInformation pluginInfo = plugin.getPluginInformation();
        this.version = pluginInfo.getVersion();
        this.hostApplication = applicationProperties.getDisplayName();
        this.hostApplicationVersion = applicationProperties.getVersion();
    }

    @Override
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Override
    public String getPluginVersion() {
        return this.version;
    }

    @Override
    public String getHostApplication() {
        return this.hostApplication;
    }

    @Override
    public String getHostApplicationVersion() {
        return this.hostApplicationVersion;
    }

    @Override
    public String getLicenseType() {
        return this.licenseType;
    }

    @Override
    public String getLicenseSize() {
        return this.licenseSize;
    }

    @Override
    public String getMaintenanceExpires() {
        return this.maintenanceExpires;
    }

    @Override
    public String getSupportEntitlementNumber() {
        return this.supportEntitlementNumber;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getRequestUrl() {
        return this.requestUrl;
    }

    @Override
    public String getEvaluationLicense() {
        return this.evaluationLicense;
    }
}

