/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.WebSudoRequiredException;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="privilegeChecker")
@ExportAsService
public class PrivilegeCheckerImpl
implements PrivilegeChecker {
    private static final Logger logger = LoggerFactory.getLogger(PrivilegeCheckerImpl.class);
    private final UserManager userManager;
    private final WebSudoManager webSudoManager;

    @Inject
    public PrivilegeCheckerImpl(@ComponentImport UserManager userManager, @ComponentImport WebSudoManager webSudoManager) {
        this.userManager = userManager;
        this.webSudoManager = webSudoManager;
    }

    @Override
    public UserProfile checkPrivileges(HttpServletRequest request, Predicate<UserProfile> privilege) throws InsufficientUserPrivilegeException {
        logger.debug("Checking request for privilege {}", privilege);
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        if (userProfile == null) {
            throw InsufficientUserPrivilegeException.noUserid();
        }
        if (!privilege.test(userProfile)) {
            logger.debug("User {} has insufficient privilege for this request, required privilege is {}", (Object)userProfile.getUsername(), privilege);
            throw InsufficientUserPrivilegeException.insufficientPrivilege(userProfile.getUsername());
        }
        return userProfile;
    }

    @Override
    public void requireWebSudo(boolean webSudoRequired, HttpServletRequest request, HttpServletResponse response) throws WebSudoRequiredException {
        if (!webSudoRequired || this.webSudoManager.canExecuteRequest(request)) {
            if (logger.isDebugEnabled()) {
                if (webSudoRequired) {
                    logger.debug("Websudo required and session is already elevated.");
                } else {
                    logger.debug("Websudo not required for this resource");
                }
            }
            return;
        }
        if (response != null) {
            logger.debug("Websudo required and session was not found. Sending redirect to Websudo permission screen");
            this.webSudoManager.enforceWebSudoProtection(request, response);
        } else {
            logger.debug("Websudo required and session was not found. Sending error as REST response");
        }
        throw new WebSudoRequiredException();
    }

    @Override
    public void checkAdmin(HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.checkPrivileges(request, this.getPrivilegeFactory().isAdmin());
    }

    @Override
    public void checkSysAdmin(HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.checkPrivileges(request, this.getPrivilegeFactory().isSysadmin());
    }

    @Override
    public void checkUser(HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.checkPrivileges(request, this.getPrivilegeFactory().isUser());
    }

    @Override
    public PrivilegeChecker.PrivilegeFactory getPrivilegeFactory() {
        return new PrivilegeFactoryImpl(this.userManager);
    }

    public static class PrivilegeFactoryImpl
    implements PrivilegeChecker.PrivilegeFactory {
        private final PrivilegeChecker.Privilege isSysadmin;
        private final PrivilegeChecker.Privilege isAdmin;
        private final PrivilegeChecker.Privilege isUser;
        private final PrivilegeChecker.Privilege isAnonymous;
        private final UserManager userManager;

        PrivilegeFactoryImpl(UserManager userManager) {
            this.isSysadmin = new PrivilegeImpl(Role.SYSADMIN, userManager);
            this.isAdmin = new PrivilegeImpl(Role.ADMIN, userManager);
            this.isUser = new PrivilegeImpl(Role.USER, userManager);
            this.isAnonymous = new PrivilegeImpl(Role.ANONYMOUS, userManager);
            this.userManager = userManager;
        }

        @Override
        public PrivilegeChecker.Privilege deny() {
            return userProfile -> false;
        }

        @Override
        public PrivilegeChecker.Privilege isSysadmin() {
            return this.isSysadmin;
        }

        @Override
        public PrivilegeChecker.Privilege isAdmin() {
            return this.isAdmin;
        }

        @Override
        public PrivilegeChecker.Privilege isUser() {
            return this.isUser;
        }

        @Override
        public PrivilegeChecker.Privilege isInGroup(List<String> groups) {
            return new PrivilegeImpl(Role.GROUP_MEMBER, groups, this.userManager);
        }

        @Override
        public PrivilegeChecker.Privilege hasUserKey(List<String> userKeys) {
            return new PrivilegeImpl(Role.HAS_USER_KEY, userKeys, this.userManager);
        }

        @Override
        public PrivilegeChecker.Privilege isAnonymous() {
            return this.isAnonymous;
        }
    }

    public static class PrivilegeImpl
    implements PrivilegeChecker.Privilege {
        @Nonnull
        private final Role role;
        private final List<String> args;
        private final UserManager userManager;

        PrivilegeImpl(@Nonnull Role role, @Nonnull UserManager userManager) {
            this.role = role;
            this.args = null;
            this.userManager = userManager;
        }

        PrivilegeImpl(@Nonnull Role role, @Nonnull List<String> args, @Nonnull UserManager userManager) {
            this.role = role;
            this.args = args;
            this.userManager = userManager;
        }

        @Override
        public boolean test(@Nullable UserProfile userProfile) {
            if (userProfile == null) {
                return this.role == Role.ANONYMOUS;
            }
            switch (this.role) {
                case ANONYMOUS: 
                case USER: {
                    return true;
                }
                case ADMIN: {
                    return this.userManager.isAdmin(userProfile.getUserKey());
                }
                case SYSADMIN: {
                    return this.userManager.isSystemAdmin(userProfile.getUserKey());
                }
                case GROUP_MEMBER: {
                    if (this.args == null) {
                        throw new IllegalArgumentException("Args must not be null if GROUP_MEMBER role is being used");
                    }
                    return this.args.stream().anyMatch(groupName -> this.userManager.isUserInGroup(userProfile.getUserKey(), groupName));
                }
                case HAS_USER_KEY: {
                    if (this.args == null) {
                        throw new IllegalArgumentException("Args must not be null if HAS_USER_KEY role is being used");
                    }
                    return this.args.contains(userProfile.getUserKey().getStringValue());
                }
            }
            throw new IllegalArgumentException("Role was of an unknown value");
        }

        public String toString() {
            return "Privilege{role=" + (Object)((Object)this.role) + ", args=" + this.args + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrivilegeImpl privilege = (PrivilegeImpl)o;
            return this.role == privilege.role && Objects.equals(this.args, privilege.args);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.role, this.args});
        }
    }

    public static enum Role {
        SYSADMIN,
        ADMIN,
        USER,
        GROUP_MEMBER,
        HAS_USER_KEY,
        ANONYMOUS;

    }
}

