/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.validation;

import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.IdPType;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.commons.validate.api.Validator;
import de.resolution.retransform.config.AttributeTransformationConfigValidator;
import de.resolution.retransform.config.Source;
import de.resolution.usersync.api.UserSyncService;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CommonIdpConfigurationDataValidator<T extends CommonIdpConfigurationData>
implements Validator<T, ConfigurationData> {
    private static final String MSG_NO_NAME = "IdP name must be set";
    private final Logger logger = LoggerFactory.getLogger(CommonIdpConfigurationDataValidator.class);
    protected static final String FIND_BY_ATTRIBUTE_NAME = "findByAttributeName";
    private static final String USER_SYNC_CONNECTOR = "userSyncConnectorUID";
    private final AttributeTransformationConfigValidator attributeTransformationConfigValidator;
    private final UserSyncService userSyncService;

    @Autowired
    protected CommonIdpConfigurationDataValidator(AttributeTransformationConfigValidator attributeTransformationConfigValidator, UserSyncService userSyncService) {
        this.attributeTransformationConfigValidator = attributeTransformationConfigValidator;
        this.userSyncService = userSyncService;
    }

    public ValidationResult validate(T idpConfig, ConfigurationData configurationData) {
        ValidationResult result = ValidationResult.create();
        if (((CommonIdpConfigurationData)idpConfig).id == null || ((CommonIdpConfigurationData)idpConfig).id < 1) {
            result.add("id", "ID must be > 0", null);
        }
        if (((CommonIdpConfigurationData)idpConfig).weight == null || ((CommonIdpConfigurationData)idpConfig).weight < 0) {
            result.add("weight", "Weight must be => 0", null);
        }
        if (((CommonIdpConfigurationData)idpConfig).name == null || ((CommonIdpConfigurationData)idpConfig).name.trim().isEmpty()) {
            this.logger.debug(MSG_NO_NAME);
            result.add("name", MSG_NO_NAME, null);
        }
        if (((CommonIdpConfigurationData)idpConfig).shouldDisplayIdpButtonOnLoginPage && configurationData.redirectToSso) {
            result.add("shouldDisplayIdpButtonOnLoginPage", null, "Once redirection is enabled, you'll seamlessly be directed to the identity provider or the selected IdP selection method. As a result, the IdP buttons will not be usable.");
        }
        if (((CommonIdpConfigurationData)idpConfig).attributeTransformations != null) {
            HashSet tmp = new HashSet();
            ((CommonIdpConfigurationData)idpConfig).attributeTransformations.forEach(mapping -> {
                if (!tmp.add(mapping.getTarget())) {
                    result.add("attributeTransformations", "You added a mapping twice! Delete the duplicate of the '" + mapping.getTarget().getName() + "' attribute!");
                }
            });
        }
        if (((CommonIdpConfigurationData)idpConfig).findByAttributeName != null && ((CommonIdpConfigurationData)idpConfig).attributeTransformations != null && !((CommonIdpConfigurationData)idpConfig).findByAttributeName.equals("addNewEntryToAttributeMapping")) {
            if (((CommonIdpConfigurationData)idpConfig).attributeTransformations.stream().filter(t -> t.getSource().getType() == Source.Type.UNMAPPED).anyMatch(t -> idpConfig.findByAttributeName.equals(t.getTarget().getName()))) {
                result.add(FIND_BY_ATTRIBUTE_NAME, "You have to configure an attribute mapping for the selected attribute");
            }
            if (((CommonIdpConfigurationData)idpConfig).findByAttributeName.isEmpty()) {
                result.add(FIND_BY_ATTRIBUTE_NAME, "You just deleted the attribute to find a user. You must choose a new one before saving the configuration.");
            }
            if (((CommonIdpConfigurationData)idpConfig).attributeTransformations.stream().noneMatch(mapping -> mapping.getTarget().getName() != null && mapping.getTarget().getName().equals(idpConfig.findByAttributeName))) {
                result.add(FIND_BY_ATTRIBUTE_NAME, "You set a findByAttribute which does not exist in attribute transformations. ");
            }
        }
        if (((CommonIdpConfigurationData)idpConfig).attributeTransformations != null && !((CommonIdpConfigurationData)idpConfig).attributeTransformations.isEmpty()) {
            ValidationResult attributeTransformationResult = ValidationResult.create();
            result.add("attributeTransformations", attributeTransformationResult);
            for (int i = 0; i < ((CommonIdpConfigurationData)idpConfig).attributeTransformations.size(); ++i) {
                attributeTransformationResult.add(i, this.attributeTransformationConfigValidator.validate(((CommonIdpConfigurationData)idpConfig).attributeTransformations.get(i)));
            }
        }
        result.add("userSyncLookupTransformation", this.attributeTransformationConfigValidator.validate(((CommonIdpConfigurationData)idpConfig).userSyncLookupTransformation));
        if (((CommonIdpConfigurationData)idpConfig).userUpdateMethod == CommonIdpConfigurationData.UserUpdateMethod.CONNECTOR || ((CommonIdpConfigurationData)idpConfig).userUpdateMethod == CommonIdpConfigurationData.UserUpdateMethod.CONNECTORANDSAML) {
            if (this.userSyncService.getAvailableConnectorNamesAndUniqueIds().isEmpty()) {
                result.add(USER_SYNC_CONNECTOR, "No UserSync connectors are configured, please configure UserSync first.", null);
            } else if (((CommonIdpConfigurationData)idpConfig).userSyncConnectorUID == null || ((CommonIdpConfigurationData)idpConfig).userSyncConnectorUID.equals("None")) {
                result.add(USER_SYNC_CONNECTOR, "You have to choose the connector that corresponds with your IdP to use this functionality.", null);
            } else if (this.userSyncService.getAvailableConnectorNamesAndUniqueIds().stream().noneMatch(curr -> ((String)curr.getValue()).equals(idpConfig.userSyncConnectorUID))) {
                result.add(USER_SYNC_CONNECTOR, "The configured connector is no longer available, probably it got deleted. Please finish/fix the UserSync configuration first before enabling this functionality.", null);
            }
        }
        if (((CommonIdpConfigurationData)idpConfig).shouldSendLoginHint) {
            if (configurationData.idpSelectionMethod != RunningConfiguration.IdpSelectionMethod.EMAIL) {
                result.add("shouldSendLoginHint", null, "This feature only works with the IdP Selection set to 'EMAIL'. Either change the IdP Selection type or nothing will happen.");
            }
            String deflt = null;
            if (((CommonIdpConfigurationData)idpConfig).idpType == IdPType.AZURE || ((CommonIdpConfigurationData)idpConfig).idpType == IdPType.ADFS) {
                deflt = "login_hint";
            }
            if (((CommonIdpConfigurationData)idpConfig).idpType == IdPType.OKTA) {
                deflt = "LoginHint";
            }
            if (StringUtil.isNullOrEmpty((String)((CommonIdpConfigurationData)idpConfig).loginHintParameterName)) {
                if (deflt != null) {
                    result.add("loginHintParameterName", "You must add something here. For your idp, please use '" + deflt + "' (without quotes) here.");
                } else {
                    result.add("loginHintParameterName", "You must add something here");
                }
            }
        }
        return result;
    }
}

