/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.groovyconnector;

import de.resolution.atlasuser.api.CancelHandle;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.DirectoryNotFoundException;
import de.resolution.atlasuser.api.exception.InvalidSearchFilterException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.api.user.SearchFilter;
import de.resolution.atlasuser.api.user.SortBy;
import de.resolution.atlasuser.api.user.UserSearchResult;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SyncSingleUserWrapper {
    @Nonnull
    private final String identifier;
    @Nonnull
    private final MapStructuredData additionalData;
    @Nonnull
    private final AtlasUserAdapter atlasUserAdapter;
    @Nonnull
    private final Map<String, Set<String>> attributesToOverride;
    @Nullable
    private final String overridingPrimaryAttribute;
    @Nullable
    private final Set<String> knownAttributes;

    public SyncSingleUserWrapper(@Nonnull String identifier, @Nullable MapStructuredData additionalData, @Nullable Map<String, Set<String>> attributesToOverride, @Nullable String overridingPrimaryAttribute, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nullable Set<String> knownAttributes) {
        this.identifier = identifier;
        this.additionalData = additionalData == null ? StructuredData.create() : additionalData;
        this.attributesToOverride = attributesToOverride == null ? Collections.emptyMap() : attributesToOverride;
        this.overridingPrimaryAttribute = overridingPrimaryAttribute;
        this.atlasUserAdapter = atlasUserAdapter;
        this.knownAttributes = knownAttributes;
    }

    @Nonnull
    public String getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    public MapStructuredData getAdditionalData() {
        return this.additionalData;
    }

    private AtlasUser addAttributesToOverride(AtlasUser atlasUser) {
        if (!this.attributesToOverride.isEmpty()) {
            AtlasUserBuilder builder = atlasUser.newBuilder();
            this.attributesToOverride.forEach((arg_0, arg_1) -> ((AtlasUserBuilder)builder).with(arg_0, arg_1));
            return builder.build();
        }
        return atlasUser;
    }

    @Nonnull
    public AtlasUserResult create(@Nonnull AtlasUser userToCreate) {
        return this.atlasUserAdapter.create(this.addAttributesToOverride(userToCreate));
    }

    @Nonnull
    public AtlasUserResult readFirstUniqueUser(@Nonnull AtlasUserReference userToFind) {
        return this.atlasUserAdapter.readFirstUniqueUser(userToFind);
    }

    @Nonnull
    public AtlasUserResult findByUsername(@Nonnull Object username, long directoryId) {
        return this.atlasUserAdapter.readFirstUniqueUser(AtlasUserReference.create((String)"ATTR_NAME", (Object)String.valueOf(username), (long)directoryId));
    }

    @Nonnull
    public AtlasUserResult findByUsername(@Nonnull Object username) {
        return this.findByUsername(username, -1L);
    }

    @Nonnull
    public AtlasUserResult update(@Nonnull AtlasUser userToUpdate) {
        return this.atlasUserAdapter.update(this.addAttributesToOverride(userToUpdate));
    }

    @Nonnull
    public AtlasUserResult createOrUpdate(AtlasUser userToCreateOrUpdate, AtlasUserAdapter.CopyBehaviour copyBehaviour) {
        return this.atlasUserAdapter.createOrUpdate(this.addAttributesToOverride(userToCreateOrUpdate), copyBehaviour, this.knownAttributes);
    }

    @Nonnull
    public AtlasUserResult createOrUpdate(AtlasUser userToCreateOrUpdate) {
        return this.createOrUpdate(userToCreateOrUpdate, AtlasUserAdapter.CopyBehaviour.NONE);
    }

    @Nonnull
    public UserSearchResult search(SearchFilter searchFilter, SortBy sortBy, CancelHandle cancelHandle) throws InvalidSearchFilterException, AtlasUserOperationFailedException, DirectoryNotFoundException {
        return this.atlasUserAdapter.search(searchFilter, sortBy, cancelHandle);
    }

    @Nonnull
    public AtlasUserAdapter getAtlasUserAdapter() {
        return this.atlasUserAdapter;
    }

    @Nonnull
    public Map<String, Set<String>> getAttributesToOverride() {
        return this.attributesToOverride;
    }

    @Nullable
    public String getOverridingPrimaryAttribute() {
        return this.overridingPrimaryAttribute;
    }
}

