/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure;

import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserProfile;
import de.resolution.reconfigure.api.UserInformation;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class UserInformationImpl
implements UserInformation {
    private final String userKey;
    private final String userName;
    private final String userFullName;
    private final String userEmail;
    private final String userTimezone;
    private final String userLocale;

    public UserInformationImpl(UserProfile userProfile, TimeZoneManager timeZoneManager, LocaleResolver localeResolver) {
        this.userKey = userProfile.getUserKey().toString();
        this.userName = userProfile.getUsername();
        this.userFullName = userProfile.getFullName();
        this.userEmail = userProfile.getEmail();
        this.userTimezone = timeZoneManager.getUserTimeZone().getID();
        this.userLocale = localeResolver.getLocale(userProfile.getUserKey()).toString();
    }

    @Override
    public String getUserKey() {
        return this.userKey;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getUserFullName() {
        return this.userFullName;
    }

    @Override
    public String getUserEmail() {
        return this.userEmail;
    }

    @Override
    public String getUserTimezone() {
        return this.userTimezone;
    }

    @Override
    public String getUserLocale() {
        return this.userLocale;
    }
}

