/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira;

import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationMigrator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
public class JiraConfigurationMigrator
extends ConfigurationMigrator {
    private static final Logger logger = LoggerFactory.getLogger(JiraConfigurationMigrator.class);
    private static final String OLD_ENFORCE_SSO_URLS = "/default.jsp,/secure/Dashboard.jspa,/secure/MyJiraHome.jspa";

    @Override
    public ConfigurationData migrateSpecific(ConfigurationData configData) {
        if (Objects.equals(configData.enforceSsoDestinations, OLD_ENFORCE_SSO_URLS)) {
            logger.warn("Updating enforceSSODestinations to {}", (Object)"/,/default\\.jsp\\??.*,/secure/Dashboard\\.jspa\\??.*,/secure/MyJiraHome\\.jspa\\??.*,/plugins/servlet/mobile.*");
            configData.enforceSsoDestinations = Utils.splitString("/,/default\\.jsp\\??.*,/secure/Dashboard\\.jspa\\??.*,/secure/MyJiraHome\\.jspa\\??.*,/plugins/servlet/mobile.*");
        }
        return configData;
    }
}

