/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.resolution.atlasplugins.samlsso.Defaults;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.EmailDomainIdpId;
import com.resolution.atlasplugins.samlsso.configuration.HeaderValueIdpId;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.SamlIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.VersionedConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.metadata.MultiMetadataStatus;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2IdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oidc.OidcIdpConfigurationData;
import com.resolution.samlwrapper.api.SAMLWrapperConfiguration;
import com.resolution.samlwrapper.api.metadata.MetadataInformation;
import com.resolution.samlwrapper.api.metadata.impl.MetadataInformationImpl;
import de.resolution.reconfigure.api.Configuration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigurationData
implements VersionedConfigurationData,
Configuration {
    @XmlTransient
    public static final int CURRENT_VERSION = 14;
    @XmlTransient
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationData.class);
    public int version = 0;
    public String defaultRedirectUrl = "/";
    public boolean redirectToSso;
    public RunningConfiguration.OverrideLoggedOutUrlMethod overrideLoggedOutUrlMethod = RunningConfiguration.OverrideLoggedOutUrlMethod.REDIRECT_SSO_ONLY;
    public String logoutUrl;
    public boolean enableUserForLogin;
    public RunningConfiguration.IdpSelectionMethod idpSelectionMethod = RunningConfiguration.IdpSelectionMethod.FIRST;
    public boolean showSelectionPageWhenEmailCookie = true;
    public String errorPageTemplate;
    public String loggedInPageTemplate;
    public String loggedOutPageTemplate;
    public String idpSelectionPageTemplate;
    public String idpByEmailPageTemplate;
    public String idpByEmailPageJavaScript;
    public String idpButtonsPageTemplate;
    public String serviceDeskErrorPageTemplate;
    @XmlElementWrapper(name="groupsToAddUserTo")
    @XmlElement(name="groupToAddUserTo")
    public List<String> groupsToAddUserTo = new ArrayList<String>();
    @XmlElementWrapper(name="nonSsoDestinations")
    @XmlElement(name="nonSsoDestination")
    @Nonnull
    public List<String> nonSsoDestinations = new ArrayList<String>();
    @XmlElementWrapper(name="nonSsoUserAgents")
    @XmlElement(name="nonSsoUserAgent")
    @Nonnull
    public List<String> nonSsoUserAgents = new ArrayList<String>();
    @XmlElementWrapper(name="enforceSsoDestinations")
    @XmlElement(name="enforceSsoDestination")
    @Nonnull
    public List<String> enforceSsoDestinations = new ArrayList<String>();
    public boolean includeQueryStringForEnforceSsoDestinations = true;
    public boolean redirectServiceDeskLogin;
    public List<String> serviceDeskPortalsToRedirect = new ArrayList<String>();
    public boolean setRememberMeCookie = false;
    public boolean fetchFromRemoteDirectory = true;
    public boolean triggerUpdateOnCrowdDirectories = true;
    public boolean enforceResponseValidityDates = true;
    public boolean enforceResponseIDUniqueness = true;
    public boolean validateSamlMessageXml = true;
    public boolean includeSigningCertificateInMetadata = true;
    public boolean includeEncryptionCertificateInMetadata = false;
    public boolean includeLogoutUrlInMetadata = false;
    public boolean blockPasswordAuthentication = false;
    public boolean blockUrlsWithPathParameters = true;
    public String entityId;
    public String privateKeyPEM;
    public String certificatePEM;
    public int clockSkew = 60;
    public boolean skipBaseUrlCheck = false;
    public int trackerStorageHours = 48;
    public int trackerCleanupIntervalInMinutes = 60;
    public int responseIdStorageIntervalInHours = 48;
    public int reloadMetadataIntervalInMinutes = 1440;
    public MetadataInformationImpl metadataInformation = new MetadataInformationImpl();
    public boolean nossoEnabled = true;
    public long regexTimeout = 2000L;
    public String sessionCookieName;
    public boolean setSameSiteAttributeOnSessionCookie = true;
    @XmlElementWrapper(name="idpConfigurations")
    @XmlElement(name="idpConfiguration")
    public List<CommonIdpConfigurationData> idpConfigurations = new ArrayList<CommonIdpConfigurationData>();
    @XmlElementWrapper(name="requestHeadersForIdpSelection")
    @XmlElement(name="requestHeaderForIdpSelection")
    public List<HeaderValueIdpId> requestHeadersForIdpSelection = new ArrayList<HeaderValueIdpId>();
    @XmlElementWrapper(name="emailDomainsForIdpSelection")
    @XmlElement(name="emailDomainForIdpSelection")
    public List<EmailDomainIdpId> emailDomainsForIdpSelection = new ArrayList<EmailDomainIdpId>();
    @XmlElementWrapper(name="allowedNotificationEmailAddresses")
    @XmlElement(name="allowedNotificationEmailAddress")
    public List<String> allowedNotificationEmailAddresses = new ArrayList<String>();
    public String commonMetadataUrl = null;
    public String commonMetadataCertificate = null;
    public boolean commonMetadataAutoReload = false;
    public String idpNameFromMetadataExpression = "md.data\n    ?.'md:EntityDescriptor'?._value\n    ?.'md:IDPSSODescriptor'?._value\n    ?.'md:Extensions'\n    ?.'mdui:UIInfo'?._value\n    ?.'mdui:DisplayName'?._value\n    ?.getAt(0)\n    ?: \"IdP $id\"";
    public long oidcJwksCacheSize = 5L;
    public long oidcJwksCacheExpiresInMinutes = 10L;
    public int analyticsConsentLevel = 0;
    public MultiMetadataStatus multiMetadataStatus;
    public boolean acceptHolderOfKeyLikeBearer = false;
    public List<String> redirectCheckerBlockedStrings = new ArrayList<String>(Defaults.DEFAULT_ILLEGAL_REDIRECT_STRINGS);
    public SAMLWrapperConfiguration.TrueFalseNone wantAssertionsSigned = SAMLWrapperConfiguration.TrueFalseNone.TRUE;
    public SAMLWrapperConfiguration.TrueFalseNone authnRequestsSigned = SAMLWrapperConfiguration.TrueFalseNone.NONE;
    public boolean hideLoginForm = false;

    public ConfigurationData() {
    }

    public ConfigurationData(ConfigurationData other) {
        this.version = other.version;
        this.defaultRedirectUrl = other.defaultRedirectUrl;
        this.redirectToSso = other.redirectToSso;
        this.overrideLoggedOutUrlMethod = other.overrideLoggedOutUrlMethod;
        this.logoutUrl = other.logoutUrl;
        this.enableUserForLogin = other.enableUserForLogin;
        this.idpSelectionMethod = other.idpSelectionMethod;
        this.showSelectionPageWhenEmailCookie = other.showSelectionPageWhenEmailCookie;
        this.entityId = other.entityId;
        this.errorPageTemplate = other.errorPageTemplate;
        this.loggedInPageTemplate = other.loggedInPageTemplate;
        this.loggedOutPageTemplate = other.loggedOutPageTemplate;
        this.idpSelectionPageTemplate = other.idpSelectionPageTemplate;
        this.idpByEmailPageTemplate = other.idpByEmailPageTemplate;
        this.idpByEmailPageJavaScript = other.idpByEmailPageJavaScript;
        this.serviceDeskErrorPageTemplate = other.serviceDeskErrorPageTemplate;
        this.idpButtonsPageTemplate = other.idpButtonsPageTemplate;
        this.redirectServiceDeskLogin = other.redirectServiceDeskLogin;
        this.serviceDeskPortalsToRedirect = new ArrayList<String>(other.serviceDeskPortalsToRedirect);
        this.setRememberMeCookie = other.setRememberMeCookie;
        this.fetchFromRemoteDirectory = other.fetchFromRemoteDirectory;
        this.triggerUpdateOnCrowdDirectories = other.triggerUpdateOnCrowdDirectories;
        this.enforceResponseValidityDates = other.enforceResponseValidityDates;
        this.enforceResponseIDUniqueness = other.enforceResponseIDUniqueness;
        this.validateSamlMessageXml = other.validateSamlMessageXml;
        this.includeSigningCertificateInMetadata = other.includeSigningCertificateInMetadata;
        this.includeEncryptionCertificateInMetadata = other.includeEncryptionCertificateInMetadata;
        this.includeLogoutUrlInMetadata = other.includeLogoutUrlInMetadata;
        this.reloadMetadataIntervalInMinutes = other.reloadMetadataIntervalInMinutes;
        this.idpNameFromMetadataExpression = other.idpNameFromMetadataExpression;
        this.privateKeyPEM = other.privateKeyPEM;
        this.certificatePEM = other.certificatePEM;
        this.clockSkew = other.clockSkew;
        this.skipBaseUrlCheck = other.skipBaseUrlCheck;
        this.trackerStorageHours = other.trackerStorageHours;
        this.responseIdStorageIntervalInHours = other.responseIdStorageIntervalInHours;
        this.trackerCleanupIntervalInMinutes = other.trackerCleanupIntervalInMinutes;
        this.nossoEnabled = other.nossoEnabled;
        this.commonMetadataUrl = other.commonMetadataUrl;
        this.commonMetadataCertificate = other.commonMetadataCertificate;
        this.commonMetadataAutoReload = other.commonMetadataAutoReload;
        this.blockPasswordAuthentication = other.blockPasswordAuthentication;
        this.blockUrlsWithPathParameters = other.blockUrlsWithPathParameters;
        this.groupsToAddUserTo = new ArrayList<String>();
        this.groupsToAddUserTo.addAll(other.groupsToAddUserTo);
        this.nonSsoDestinations = new ArrayList<String>();
        this.nonSsoDestinations.addAll(other.nonSsoDestinations);
        this.nonSsoUserAgents = new ArrayList<String>();
        this.nonSsoUserAgents.addAll(other.nonSsoUserAgents);
        this.regexTimeout = other.regexTimeout;
        this.enforceSsoDestinations = new ArrayList<String>();
        this.enforceSsoDestinations.addAll(other.enforceSsoDestinations);
        this.includeQueryStringForEnforceSsoDestinations = other.includeQueryStringForEnforceSsoDestinations;
        this.allowedNotificationEmailAddresses = new ArrayList<String>();
        this.allowedNotificationEmailAddresses.addAll(other.allowedNotificationEmailAddresses);
        this.idpConfigurations = new ArrayList<CommonIdpConfigurationData>();
        for (CommonIdpConfigurationData commonIdpConfigurationData : other.idpConfigurations) {
            if (commonIdpConfigurationData.protocolType == ProtocolType.SAML) {
                this.idpConfigurations.add(new SamlIdpConfigurationData((SamlIdpConfigurationData)commonIdpConfigurationData));
                continue;
            }
            if (commonIdpConfigurationData.protocolType == ProtocolType.OIDC) {
                this.idpConfigurations.add(new OidcIdpConfigurationData((OidcIdpConfigurationData)commonIdpConfigurationData));
                continue;
            }
            if (commonIdpConfigurationData.protocolType != ProtocolType.OAU2) continue;
            this.idpConfigurations.add(new OAuth2IdpConfigurationData((OAuth2IdpConfigurationData)commonIdpConfigurationData));
        }
        for (EmailDomainIdpId emailDomainIdpId : other.emailDomainsForIdpSelection) {
            this.emailDomainsForIdpSelection.add(new EmailDomainIdpId(emailDomainIdpId));
        }
        for (HeaderValueIdpId headerValueIdpId : other.requestHeadersForIdpSelection) {
            this.requestHeadersForIdpSelection.add(new HeaderValueIdpId(headerValueIdpId));
        }
        this.metadataInformation = new MetadataInformationImpl((MetadataInformation)other.metadataInformation);
        this.sessionCookieName = other.sessionCookieName;
        this.setSameSiteAttributeOnSessionCookie = other.setSameSiteAttributeOnSessionCookie;
        this.oidcJwksCacheExpiresInMinutes = other.oidcJwksCacheExpiresInMinutes;
        this.oidcJwksCacheSize = other.oidcJwksCacheSize;
        this.analyticsConsentLevel = other.analyticsConsentLevel;
        if (other.multiMetadataStatus != null) {
            this.multiMetadataStatus = new MultiMetadataStatus(other.multiMetadataStatus);
        }
        this.redirectCheckerBlockedStrings = new ArrayList<String>(other.redirectCheckerBlockedStrings);
        this.authnRequestsSigned = other.authnRequestsSigned;
        this.wantAssertionsSigned = other.wantAssertionsSigned;
        this.acceptHolderOfKeyLikeBearer = other.acceptHolderOfKeyLikeBearer;
        this.hideLoginForm = other.hideLoginForm;
    }

    public static String getPluginSettingsKey(String parameter) {
        return ConfigurationData.getPluginSettingsKey(parameter, 14);
    }

    public static String getPluginSettingsKey(String parameter, boolean versioned) {
        if (versioned) {
            return ConfigurationData.getPluginSettingsKey(parameter, 14);
        }
        return ConfigurationData.getPluginSettingsKey(parameter, 1);
    }

    public static String getPluginSettingsKey(String parameter, int version) {
        if (version > 1) {
            return "com.resolution.atlasplugins.samlsso:" + version + ":" + parameter;
        }
        return "com.resolution.atlasplugins.samlsso:" + parameter;
    }

    @Override
    public int getVersion() {
        return 14;
    }

    @Override
    public ConfigurationData migrateToNewerModelVersion() {
        logger.debug("This is the latest version, not migrating.");
        return null;
    }

    public MetadataInformationImpl getMetadataInformation() {
        return this.metadataInformation;
    }

    @Override
    public void setMetadataInformation(MetadataInformationImpl metadataInformation) {
        this.metadataInformation = metadataInformation;
    }
}

