/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.azure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.MapUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.util.Tuple;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.usersync.api.ConnectorGroup;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.IdentifierForSingleUserSync;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.AccessTokenException;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.GeneralSyncException;
import de.resolution.usersync.api.exception.RequestFailedException;
import de.resolution.usersync.api.exception.UserRelatedSyncException;
import de.resolution.usersync.builtin.azure.AzureConnectorConfiguration;
import de.resolution.usersync.builtin.azure.AzureGroup;
import de.resolution.usersync.builtin.azure.AzureGroupResult;
import de.resolution.usersync.builtin.azure.AzureUserResult;
import de.resolution.usersync.impl.requiredgroups.LocalRequiredGroupChecker;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckFailedException;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerHolder;
import de.resolution.usersync.impl.requiredgroups.ServerFilterBasedRequiredGroupChecker;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import de.resolution.usersync.spi.AbstractOAuthClientCredentialsConnector;
import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureConnector
extends AbstractOAuthClientCredentialsConnector<AzureConnectorConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(AzureConnector.class);
    public static final String AZURE_ATTRIBUTE_ID = "azure_ID";
    private static final int HTTP_STATUS_TOO_MANY_REQUESTS = 429;
    private static final String ACCOUNT_ENABLED = "accountEnabled";
    private static final String DISPLAY_NAME = "displayName";
    private static final String MANAGER = "manager";
    private static final String MEMBER_OF = "memberOf";
    private static final String ON_PREMISES_SAM_ACCOUNT_NAME = "onPremisesSamAccountName";
    private static final String QUERY_PARAM_COUNT = "$count";
    private static final String QUERY_PARAM_FILTER = "$filter";
    private static final String QUERY_PARAM_SELECT = "$select";
    private static final String QUERY_PARAM_TOP = "$top";
    private static final String TRANSITIVE_MEMBER_OF = "transitiveMemberOf";
    private static final String USER_PRINCIPAL_NAME = "userPrincipalName";
    private static final Script ID_EXPRESSION = StructuredData.prepareFind((String)"id");
    private static final String MESSAGE_PERMISSION_WARNING = "Please make sure to set the required permissions and grant admin consent in the Azure portal as described in the documentation.";
    private static final String MESSAGE_SKIPPING_USER_WITHOUT_ID = "Skipping user without id";
    private static final List<String> CONNECTOR_USER_ATTRIBUTES = Arrays.asList("id", "deletedDateTime", "accountEnabled", "ageGroup", "businessPhones", "city", "createdDateTime", "creationType", "companyName", "consentProvidedForMinor", "country", "department", "displayName", "employeeId", "employeeHireDate", "employeeOrgData", "employeeType", "faxNumber", "givenName", "imAddresses", "infoCatalogs", "isManagementRestricted", "isResourceAccount", "jobTitle", "legalAgeGroupClassification", "mail", "mailNickname", "mobilePhone", "onPremisesDistinguishedName", "officeLocation", "onPremisesDomainName", "onPremisesImmutableId", "onPremisesLastSyncDateTime", "onPremisesSecurityIdentifier", "onPremisesSamAccountName", "onPremisesSyncEnabled", "onPremisesUserPrincipalName", "otherMails", "passwordPolicies", "passwordProfile", "photo.etag", "photo.value", "postalCode", "preferredDataLocation", "preferredLanguage", "proxyAddresses", "refreshTokensValidFromDateTime", "showInAddressList", "signInSessionsValidFromDateTime", "state", "streetAddress", "surname", "usageLocation", "userPrincipalName", "externalUserState", "externalUserStateChangeDateTime", "userType", "assignedLicenses", "assignedPlans", "deviceKeys", "identities", "onPremisesExtensionAttributes", "onPremisesProvisioningErrors", "provisionedPlans");

    AzureConnector(ConnectorService connectorService, AtlasUserAdapter atlasUserAdapter, AzureConnectorConfiguration configuration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/AzureConnector.json");
    }

    @Override
    protected void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        try {
            this.refreshAccessTokenIfInvalid();
        }
        catch (AccessTokenException e) {
            syncStatusFacade.fail("The access token is invalid and could not be refreshed. Please make sure to set the required permissions and grant admin consent in the Azure portal as described in the documentation.", e, logger);
            return;
        }
        try {
            if (this.getRequiredGroupCheckerHolder().hasRequiredGroupsConfigured()) {
                this.fetchUsersFromRequiredGroups(syncFunction, syncStatusFacade);
            } else {
                this.fetchAllUsers(syncFunction, syncStatusFacade);
            }
        }
        catch (GeneralSyncException e) {
            syncStatusFacade.fail("Fetching users failed", e, logger);
        }
    }

    private void fetchAllUsers(SyncFunction syncFunction, SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        this.trackMemoryUsage(syncStatusFacade, "before fetching all users");
        String nextPageUrl = null;
        do {
            int resultCount;
            String url;
            if (nextPageUrl == null) {
                HttpUrl.Builder urlBuilder = this.getUsersUrlBase().addQueryParameter(QUERY_PARAM_SELECT, this.getSelectString());
                url = urlBuilder.build().toString();
            } else {
                logger.debug("Fetching next page of users.");
                url = nextPageUrl;
            }
            AzureUserResult azureUserResult = this.fetchUsersPage(url, new HashSet<String>(), syncFunction, syncStatusFacade);
            nextPageUrl = azureUserResult.getNextPageUrl();
            SyncStatus syncStatus = syncStatusFacade.getSyncStatus();
            if (syncStatus == null || (resultCount = syncStatus.getResultCount()) % 100 != 0) continue;
            this.trackMemoryUsage(syncStatusFacade, String.format("after processing %d users", resultCount));
        } while (!StringUtil.isNullOrEmpty((String)nextPageUrl));
        this.trackMemoryUsage(syncStatusFacade, "after fetching all users");
    }

    private void fetchUsersFromRequiredGroups(SyncFunction syncFunction, SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        Set<ConnectorGroup> requiredConnectorGroups;
        this.trackMemoryUsage(syncStatusFacade, "before fetching users from required groups");
        try {
            requiredConnectorGroups = this.fetchRequiredConnectorGroups(this.getRequiredGroupCheckerHolder(), syncStatusFacade);
        }
        catch (RequiredGroupCheckFailedException e) {
            throw new GeneralSyncException("Checking required groups failed", e);
        }
        if (requiredConnectorGroups.isEmpty()) {
            syncStatusFacade.add("No matching required groups found. No users will be synced.", null, SyncStatusFacade.LogLevel.DEBUG, logger);
            return;
        }
        String namesOfRequiredGroups = requiredConnectorGroups.stream().map(ConnectorGroup::getName).filter(Objects::nonNull).collect(Collectors.joining(", "));
        syncStatusFacade.add("Fetch users of " + requiredConnectorGroups.size() + " required groups: " + namesOfRequiredGroups + ".", null, SyncStatusFacade.LogLevel.DEBUG, logger);
        this.fetchUsersForGroups(requiredConnectorGroups, syncFunction, syncStatusFacade);
    }

    @Override
    @Nonnull
    public Set<ConnectorGroup> fetchRequiredConnectorGroups(@Nonnull RequiredGroupCheckerHolder requiredGroupCheckerHolder, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        HashSet<ConnectorGroup> requiredConnectorGroups = new HashSet<ConnectorGroup>();
        String nextPageUrl = null;
        int totalGroupCount = 0;
        syncStatusFacade.add("Started processing required groups, please wait...", null, SyncStatusFacade.LogLevel.DEBUG, logger);
        this.trackMemoryUsage(syncStatusFacade, "before fetching required connector groups");
        do {
            String url;
            if (nextPageUrl == null) {
                HttpUrl.Builder urlBuilder = this.getGroupsUrlBase();
                Optional<ServerFilterBasedRequiredGroupChecker> serverFilterBasedRequiredGroupChecker = requiredGroupCheckerHolder.getServerFilterBasedRequiredGroupChecker();
                if (serverFilterBasedRequiredGroupChecker.isPresent()) {
                    urlBuilder.addQueryParameter(QUERY_PARAM_FILTER, serverFilterBasedRequiredGroupChecker.get().getCustomServerFilter());
                } else {
                    urlBuilder.addQueryParameter(QUERY_PARAM_FILTER, this.createGroupFilterString());
                }
                url = urlBuilder.build().toString();
            } else {
                url = nextPageUrl;
            }
            syncStatusFacade.checkCancel();
            ResponseWrapper responseWrapper = this.performGetRequest(url, syncStatusFacade);
            if (!responseWrapper.isSuccess() || responseWrapper.getBody() == null) {
                if (responseWrapper.getCode() == 401) {
                    throw new GeneralSyncException("Fetching required groups failed. Please check if Application ID, Directory (Tenant) ID and Application Secret are valid.");
                }
                if (responseWrapper.getCode() == 403) {
                    throw new GeneralSyncException("Fetching required groups failed. Please make sure to set the required permissions and grant admin consent in the Azure portal as described in the documentation.");
                }
                throw new RequiredGroupCheckFailedException("Fetching groups failed. This usually means that we were not able to connect to Azure or did not get a reply. Please check your network connection and make sure that Azure's endpoints are reachable. (see https://wiki.resolution.de/go/idpEndpoints) Error message:" + responseWrapper.getMessage());
            }
            AzureGroupResult groupResult = (AzureGroupResult)JSONUtil.fromJson((String)responseWrapper.getBody(), AzureGroupResult.class);
            List<AzureGroup> groupData = groupResult.getGroups();
            totalGroupCount += groupData.size();
            Optional<LocalRequiredGroupChecker> localRequiredGroupCheckerOptional = requiredGroupCheckerHolder.getLocalRequiredGroupChecker();
            if (localRequiredGroupCheckerOptional.isPresent()) {
                LocalRequiredGroupChecker localRequiredGroupChecker = localRequiredGroupCheckerOptional.get();
                groupData.stream().map(AzureGroup::asConnectorGroup).filter(localRequiredGroupChecker::isRequiredGroup).forEach(requiredConnectorGroups::add);
            } else {
                groupData.stream().map(AzureGroup::asConnectorGroup).forEach(requiredConnectorGroups::add);
            }
            nextPageUrl = groupResult.getNextPageUrl();
            if (totalGroupCount % 100 == 0) {
                syncStatusFacade.setStatusMessage("Processed " + totalGroupCount + " groups, please wait...");
            }
            if (totalGroupCount % 50 != 0) continue;
            this.trackMemoryUsage(syncStatusFacade, String.format("after processing %d groups", totalGroupCount));
        } while (!StringUtil.isNullOrEmpty((String)nextPageUrl));
        syncStatusFacade.add("Finished processing " + totalGroupCount + " groups.", null, SyncStatusFacade.LogLevel.DEBUG, logger);
        this.trackMemoryUsage(syncStatusFacade, " after processing groups");
        return requiredConnectorGroups;
    }

    private void fetchUsersForGroups(Set<ConnectorGroup> requiredConnectorGroups, SyncFunction syncFunction, SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        HashSet<String> alreadySyncedUserIds = new HashSet<String>();
        for (ConnectorGroup requiredConnectorGroup : requiredConnectorGroups) {
            syncStatusFacade.checkCancel();
            this.fetchUsersForGroup(requiredConnectorGroup, alreadySyncedUserIds, syncFunction, syncStatusFacade);
        }
        this.trackMemoryUsage(syncStatusFacade, "after fetching users for groups");
    }

    private void fetchUsersForGroup(@Nonnull ConnectorGroup requiredConnectorGroup, Set<String> alreadySyncedUserIds, SyncFunction syncFunction, SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        String nextPageUrl = null;
        do {
            int resultCount;
            String url;
            if (nextPageUrl == null) {
                url = this.getGroupsUrlBase().addPathSegment(requiredConnectorGroup.getId()).addPathSegment(((AzureConnectorConfiguration)this.configuration).isFetchGroupMemberships() ? "transitiveMembers" : "members").addQueryParameter(QUERY_PARAM_SELECT, this.getSelectString()).build().toString();
            } else {
                logger.debug("Fetching next page of users.");
                url = nextPageUrl;
            }
            AzureUserResult azureUserResult = this.fetchUsersPage(url, alreadySyncedUserIds, syncFunction, syncStatusFacade);
            nextPageUrl = azureUserResult.getNextPageUrl();
            alreadySyncedUserIds.addAll(azureUserResult.getUserIds());
            SyncStatus syncStatus = syncStatusFacade.getSyncStatus();
            if (syncStatus == null || (resultCount = syncStatus.getResultCount()) % 100 != 0) continue;
            this.trackMemoryUsage(syncStatusFacade, String.format("after processing %d users", resultCount));
        } while (!StringUtil.isNullOrEmpty((String)nextPageUrl));
    }

    private String createGroupFilterString() {
        HashSet<String> queryParts = new HashSet<String>();
        if (((AzureConnectorConfiguration)this.configuration).isFetchSecurityGroups()) {
            queryParts.add("(securityEnabled eq true and mailEnabled eq false)");
        }
        if (((AzureConnectorConfiguration)this.configuration).isFetchMailEnabledSecurityGroups()) {
            queryParts.add("(securityEnabled eq true and mailEnabled eq true)");
        }
        if (((AzureConnectorConfiguration)this.configuration).isFetchDistributionGroups()) {
            queryParts.add("(securityEnabled eq false and mailEnabled eq true)");
        }
        if (((AzureConnectorConfiguration)this.configuration).isFetchOffice365GroupsSecurityEnabled()) {
            queryParts.add("(groupTypes/any(c:c eq 'Unified') and securityEnabled eq true and mailEnabled eq true)");
        }
        if (((AzureConnectorConfiguration)this.configuration).isFetchOffice365GroupsNonSecurityEnabled()) {
            queryParts.add("(groupTypes/any(c:c eq 'Unified') and securityEnabled eq false and mailEnabled eq true)");
        }
        return String.join((CharSequence)" or ", queryParts);
    }

    @Nonnull
    private AzureUserResult fetchUsersPage(@Nonnull String url, @Nonnull Set<String> seenUserIdentifiers, @Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        ResponseWrapper responseWrapper = this.performGetRequest(url, syncStatusFacade);
        if (!responseWrapper.isSuccess()) {
            throw new GeneralSyncException("Parsing users from response failed: " + responseWrapper.getBody());
        }
        AzureUserResult azureUserResult = new AzureUserResult(responseWrapper, seenUserIdentifiers, syncStatusFacade);
        for (Tuple<String, StructuredData> users : azureUserResult.getUsers()) {
            syncStatusFacade.checkCancel();
            String userIdentifier = (String)users.left();
            StructuredData userAttributes = (StructuredData)users.right();
            try {
                this.addGroupAttribute(userIdentifier, userAttributes, syncStatusFacade);
                this.addManagerAttribute(userIdentifier, userAttributes, syncStatusFacade);
                this.addProfilePictureAttributes(userIdentifier, userAttributes, syncStatusFacade);
                syncFunction.accept(userAttributes.asMap());
            }
            catch (UserRelatedSyncException e) {
                syncStatusFacade.failPartially(e.getMessage(), e, logger);
            }
        }
        return azureUserResult;
    }

    private boolean addGroupAttribute(@Nonnull String userIdentifier, @Nonnull StructuredData userData, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        Set<ConnectorGroup> groupsForUser = this.fetchGroupsForUser(userIdentifier, syncStatusFacade);
        List groupsNamesForUser = groupsForUser.stream().map(ConnectorGroup::getName).filter(Objects::nonNull).collect(Collectors.toList());
        userData.put((Object)"GROUPS", groupsNamesForUser);
        List groupIdsForUser = groupsForUser.stream().map(ConnectorGroup::getId).collect(Collectors.toList());
        userData.put((Object)"GROUP_IDS", groupIdsForUser);
        if (((AzureConnectorConfiguration)this.configuration).isAddGroupOnPremisesSamAccountNameToUser()) {
            ObjectMapper objectMapper = new ObjectMapper();
            Set groupOnPremisesSamAccountNamesForUser = groupsForUser.stream().map(ConnectorGroup::getGroupData).map(groupData -> {
                try {
                    return objectMapper.readTree(groupData);
                }
                catch (JsonProcessingException e) {
                    logger.debug("Could not parse group data while trying to read onPremisesSamAccountName: {}", groupData, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).filter(jsonNode -> jsonNode.has(ON_PREMISES_SAM_ACCOUNT_NAME)).filter(jsonNode -> !jsonNode.get(ON_PREMISES_SAM_ACCOUNT_NAME).isNull()).map(jsonNode -> jsonNode.get(ON_PREMISES_SAM_ACCOUNT_NAME).asText()).collect(Collectors.toSet());
            userData.put((Object)"GROUP_ON_PREMISES_SAM_ACCOUNT_NAMES", groupOnPremisesSamAccountNamesForUser);
        }
        return this.matchesLocalRequiredGroupChecker(groupsForUser);
    }

    @Override
    @Nonnull
    protected FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        String url;
        SyncStatusFacade syncStatusFacade = SyncStatusFacade.nullFacade();
        try {
            this.refreshAccessTokenIfInvalid();
        }
        catch (AccessTokenException e) {
            return FindUserResult.failed(e);
        }
        try {
            HttpUrl.Builder urlBuilder = this.getUsersUrlBase().addPathSegment(identifier).addQueryParameter(QUERY_PARAM_SELECT, this.getSelectString());
            url = urlBuilder.toString();
        }
        catch (GeneralSyncException e) {
            return FindUserResult.failed(e);
        }
        ResponseWrapper response = this.performGetRequest(url, syncStatusFacade);
        if (response.isNotFound()) {
            return FindUserResult.notFound();
        }
        if (!response.isSuccess()) {
            return FindUserResult.failed(response.getMessage());
        }
        StructuredData userAttributes = response.getBodyAsStructuredData();
        try {
            String userIdentifier = userAttributes.findString(ID_EXPRESSION);
            if (userIdentifier == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Skipping user without id {}", (Object)JSONUtil.asJson((Object)userAttributes));
                }
                throw new UserRelatedSyncException(MESSAGE_SKIPPING_USER_WITHOUT_ID);
            }
            this.addManagerAttribute(userIdentifier, userAttributes, syncStatusFacade);
            this.addProfilePictureAttributes(userIdentifier, userAttributes, syncStatusFacade);
            boolean matchesRequiredConnectorGroups = this.addGroupAttribute(userIdentifier, userAttributes, syncStatusFacade);
            if (!((AzureConnectorConfiguration)this.configuration).isIgnoreRequiredConnectorGroupsOnSingleUserSync()) {
                if (((AzureConnectorConfiguration)this.configuration).isUseRequiredConnectorGroupsServerFilter() && !this.isUserInRequiredServerGroup(identifier)) {
                    return FindUserResult.preFiltered(userAttributes);
                }
                if (!matchesRequiredConnectorGroups) {
                    return FindUserResult.preFiltered(userAttributes);
                }
            }
        }
        catch (GeneralSyncException | UserRelatedSyncException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Single user update failed", (Throwable)e);
            }
            return FindUserResult.failed(e);
        }
        return FindUserResult.found(userAttributes);
    }

    private boolean isUserInRequiredServerGroup(String identifier) throws GeneralSyncException, UserRelatedSyncException {
        HttpUrl url = this.getUsersUrlBase().addPathSegment(identifier).addPathSegment(((AzureConnectorConfiguration)this.configuration).isFetchGroupMemberships() ? TRANSITIVE_MEMBER_OF : MEMBER_OF).addPathSegment("microsoft.graph.group").addQueryParameter(QUERY_PARAM_COUNT, "true").addQueryParameter(QUERY_PARAM_FILTER, ((AzureConnectorConfiguration)this.configuration).getRequiredConnectorGroupsServerFilter()).build();
        ResponseWrapper response = this.httpWrapper.get(url, MapUtil.of((Object)"Authorization", (Object)this.getAuthorizationHeaderValue(), (Object)"ConsistencyLevel", (Object)"eventual"));
        if (response.isNotFound()) {
            throw new UserRelatedSyncException("User with identifier <" + identifier + "> was not found");
        }
        if (!response.isSuccess()) {
            throw new UserRelatedSyncException("Checking required groups for user with identifier <" + identifier + "> failed: " + response.getMessage());
        }
        JsonNode parsedJson = response.getBodyAsJsonNode();
        JsonNode odataCountNode = parsedJson.get("@odata.count");
        if (odataCountNode != null && odataCountNode.isNumber()) {
            return odataCountNode.asInt() > 0;
        }
        return false;
    }

    @Nonnull
    private Set<ConnectorGroup> fetchGroupsForUser(@Nonnull String userId, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        if (((AzureConnectorConfiguration)this.configuration).isGroupSyncDisabled()) {
            logger.debug("Group sync is disabled.");
            return Collections.emptySet();
        }
        HashSet<ConnectorGroup> groups = new HashSet<ConnectorGroup>();
        String nextPageUrl = null;
        do {
            String url;
            if (nextPageUrl == null) {
                url = this.getUsersUrlBase().addPathSegment(userId).addPathSegment(((AzureConnectorConfiguration)this.configuration).isFetchGroupMemberships() ? TRANSITIVE_MEMBER_OF : MEMBER_OF).build().toString();
            } else {
                logger.debug("Fetching next page of groups.");
                url = nextPageUrl;
            }
            ResponseWrapper responseWrapper = this.performGetRequest(url, syncStatusFacade);
            if (!responseWrapper.isSuccess() || responseWrapper.getBody() == null) {
                String errorMessage = "Could not fetch groups, because there is (most likely) a network-related issue. Please check your network connection and make sure that Azure's endpoints are reachable (see https://wiki.resolution.de/go/idpEndpoints).";
                if (responseWrapper.getMessage() != null) {
                    errorMessage = errorMessage + " The result contained the following message: " + responseWrapper.getMessage() + ".";
                }
                errorMessage = responseWrapper.getBody() == null ? errorMessage + " There was no response by Azure and the return code is " + responseWrapper.getCode() + "." : errorMessage + " We got the following response during the request: " + responseWrapper.getBody() + ".";
                throw new GeneralSyncException(errorMessage);
            }
            try {
                AzureGroupResult groupResult = (AzureGroupResult)JSONUtil.fromJson((String)responseWrapper.getBody(), AzureGroupResult.class);
                groupResult.getValidGroups((AzureConnectorConfiguration)this.configuration).stream().map(AzureGroup::asConnectorGroup).forEach(groups::add);
                nextPageUrl = groupResult.getNextPageUrl();
            }
            catch (JSONUtil.JsonDeserializationFailedException e) {
                throw new GeneralSyncException("Could not parse group response", (Exception)((Object)e));
            }
        } while (!StringUtil.isNullOrEmpty((String)nextPageUrl));
        return groups;
    }

    private void addManagerAttribute(@Nonnull String userIdentifier, @Nonnull StructuredData userData, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException, UserRelatedSyncException {
        if (!((AzureConnectorConfiguration)this.configuration).isFetchManager()) {
            return;
        }
        String url = this.getUsersUrlBase().addPathSegment(userIdentifier).addPathSegment(MANAGER).addQueryParameter(QUERY_PARAM_SELECT, this.getSelectString()).build().toString();
        ResponseWrapper responseWrapper = this.performGetRequest(url, syncStatusFacade);
        if (responseWrapper.isNotFound()) {
            userData.put((Object)MANAGER, (Object)this.getEmptyListOfMappedManagerAttributes());
            return;
        }
        if (!responseWrapper.isSuccess()) {
            throw new UserRelatedSyncException("Fetching manager for user " + userIdentifier + " failed: " + responseWrapper.getCode() + " : " + responseWrapper.getMessage());
        }
        userData.put((Object)MANAGER, (Object)responseWrapper.getBodyAsStructuredData());
    }

    private void addProfilePictureAttributes(@Nonnull String userIdentifier, @Nonnull StructuredData userAttributes, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        if (!((AzureConnectorConfiguration)this.configuration).isFetchProfilePicture()) {
            return;
        }
        HashMap<String, String> profilePictureAttributes = new HashMap<String, String>();
        logger.debug("Fetching profile picture for user {}", (Object)userIdentifier);
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout((long)((AzureConnectorConfiguration)this.configuration).getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)((AzureConnectorConfiguration)this.configuration).getReadTimeout(), TimeUnit.SECONDS).build();
        String url = "largest".equalsIgnoreCase(((AzureConnectorConfiguration)this.configuration).getProfilePictureSize()) ? this.getUsersUrlBase().addPathSegment(userIdentifier).addPathSegment("photo").addPathSegment("$value").toString() : this.getUsersUrlBase().addPathSegment(userIdentifier).addPathSegment("photos").addPathSegment(((AzureConnectorConfiguration)this.configuration).getProfilePictureSize()).addPathSegment("$value").toString();
        Request.Builder request = new Request.Builder().url(url).addHeader("Authorization", this.getAuthorizationHeaderValue());
        try (Response response = okHttpClient.newCall(request.build()).execute();){
            byte[] bytes;
            if (response.code() == 401) {
                syncStatusFacade.add("Azure returned 401 Unauthorized. Please check if your Azure application does have the User.Read.All permission.", SyncStatusFacade.LogLevel.INFO, logger);
                return;
            }
            if (response.code() == 404) {
                logger.debug("No profile picture returned for user {}", (Object)userIdentifier);
                profilePictureAttributes.put("etag", "");
                profilePictureAttributes.put("value", "");
                userAttributes.put((Object)"photo", profilePictureAttributes);
                return;
            }
            if (response.code() != 200) {
                syncStatusFacade.failPartially("Server did not return profile picture", response.code(), response.message(), null, logger);
                return;
            }
            ResponseBody body = response.body();
            if (body == null) {
                syncStatusFacade.failPartially("Profile picture response body from Azure is null", response.code(), response.message(), null, logger);
                return;
            }
            try {
                bytes = IOUtils.toByteArray((InputStream)body.byteStream());
            }
            catch (IOException e) {
                logger.debug("Could not parse profile picture data");
                syncStatusFacade.failPartially("Could not parse profile picture data", e, logger);
                if (response != null) {
                    response.close();
                }
                return;
            }
            String newEtag = response.header("Etag");
            String assignedProfilePictureFilename = this.getAttributeValueFromUser(AZURE_ATTRIBUTE_ID, userIdentifier, "ATTR_PROFILE_PICTURE_FILENAME");
            if (assignedProfilePictureFilename != null && newEtag != null && assignedProfilePictureFilename.contains(newEtag.replaceAll("W/\"(.*)\"", "$1"))) {
                logger.debug("Profile picture is already assigned to the user, so the attributes are not added to the user, etag: {}, existingFilename: {}", (Object)newEtag, (Object)assignedProfilePictureFilename);
                return;
            }
            String avatarBase64 = Base64.getEncoder().encodeToString(bytes);
            profilePictureAttributes.put("etag", newEtag);
            profilePictureAttributes.put("value", avatarBase64);
            userAttributes.put((Object)"photo", profilePictureAttributes);
        }
        catch (IOException e) {
            syncStatusFacade.failPartially("Could not fetch profile picture", e, logger);
        }
    }

    @Nonnull
    private ResponseWrapper performGetRequest(@Nonnull String url, @Nonnull SyncStatusFacade syncStatusFacade) {
        return this.performGetRequest(url, false, syncStatusFacade);
    }

    @Nonnull
    private ResponseWrapper performGetRequest(@Nonnull String url, boolean isRetry, @Nonnull SyncStatusFacade syncStatusFacade) {
        if (logger.isTraceEnabled()) {
            logger.trace("Perform GET request: {}", (Object)url);
        }
        try {
            ResponseWrapper responseWrapper = this.httpWrapper.get(url, Collections.singletonMap("Authorization", this.getAuthorizationHeaderValue()));
            if (logger.isTraceEnabled()) {
                logger.trace("Response: {}: {} \n {}", new Object[]{responseWrapper.getCode(), responseWrapper.getMessage(), responseWrapper.getBody()});
            }
            if (responseWrapper.getCode() == 401 || responseWrapper.getCode() == 403) {
                if (isRetry) {
                    responseWrapper.setErrorMessage("Authorization failed after retry, please check your settings.");
                    return responseWrapper;
                }
                this.refreshAccessToken();
                return this.performGetRequest(url, true, syncStatusFacade);
            }
            if (responseWrapper.getCode() == 429) {
                if (isRetry) {
                    responseWrapper.setErrorMessage("Rate limit exceeded after retry");
                    return responseWrapper;
                }
                this.handleRateLimit(responseWrapper, syncStatusFacade);
                return this.performGetRequest(url, true, syncStatusFacade);
            }
            if (responseWrapper.getCode() >= 500) {
                if (isRetry) {
                    responseWrapper.setErrorMessage("Request failed after retry");
                    return responseWrapper;
                }
                this.handleRateLimit(responseWrapper, syncStatusFacade);
                if (logger.isDebugEnabled()) {
                    logger.debug("Retrying failed request to {}, because server returned status code {}.", (Object)url, (Object)responseWrapper.getCode());
                }
                return this.performGetRequest(url, true, syncStatusFacade);
            }
            return responseWrapper;
        }
        catch (AccessTokenException e) {
            return this.performGetRequest(url, true, syncStatusFacade);
        }
        catch (RequestFailedException e) {
            return new ResponseWrapper((Exception)e);
        }
    }

    private void handleRateLimit(@Nonnull ResponseWrapper responseWrapper, @Nonnull SyncStatusFacade syncStatusFacade) throws RequestFailedException {
        int retryAfter;
        if (syncStatusFacade.isNullFacade()) {
            throw new RequestFailedException("Rate limit exceeded in single user update, canceling request");
        }
        String retry = responseWrapper.getHeader("Retry-After");
        if (retry == null) {
            throw new RequestFailedException("Retry-After not found");
        }
        try {
            retryAfter = Integer.parseInt(retry);
        }
        catch (NumberFormatException e) {
            throw new RequestFailedException("Could not parse rate limit headers.", e);
        }
        logger.debug("Retry-After: {}.", (Object)retryAfter);
        Instant retryAfterTimestamp = Instant.now().plusSeconds(retryAfter).plusMillis(new SecureRandom().nextInt(10000));
        syncStatusFacade.add("Rate limit threshold reached, sync will resume on " + retryAfterTimestamp, null, SyncStatusFacade.LogLevel.INFO, logger);
        while (Instant.now().isBefore(retryAfterTimestamp)) {
            syncStatusFacade.checkCancel();
            long secondsRemaining = Duration.between(Instant.now(), retryAfterTimestamp).toMillis() / 1000L;
            logger.info("Rate limit threshold reached, waiting for {} more seconds.", (Object)secondsRemaining);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RequestFailedException("Interrupted during sleep", e);
            }
        }
    }

    @Override
    @Nonnull
    protected String getTokenUrl() {
        return String.format("%s/%s/oauth2/v2.0/token", ((AzureConnectorConfiguration)this.configuration).getAzureEndpoint(), ((AzureConnectorConfiguration)this.configuration).getDirectoryTenantId());
    }

    @Override
    @Nonnull
    protected Optional<String> getScope() {
        return Optional.of(((AzureConnectorConfiguration)this.configuration).getGraphEndpoint() + "/.default");
    }

    @Nonnull
    private String getSelectString() {
        if (((AzureConnectorConfiguration)this.configuration).getApiVersion() == AzureConnectorConfiguration.APIVersion.BETA) {
            return "";
        }
        return Stream.of(CONNECTOR_USER_ATTRIBUTES, ((AzureConnectorConfiguration)this.configuration).getAdditionalAzureAttributes()).flatMap(Collection::stream).distinct().collect(Collectors.joining(","));
    }

    private StructuredData getEmptyListOfMappedManagerAttributes() {
        Map<String, String> emptyManagerAttributes = CONNECTOR_USER_ATTRIBUTES.stream().collect(Collectors.toMap(userAttribute -> userAttribute, userAqttribute -> ""));
        return StructuredData.create(emptyManagerAttributes);
    }

    @Nonnull
    private HttpUrl.Builder getUrlBase() throws GeneralSyncException {
        HttpUrl url = HttpUrl.parse((String)((AzureConnectorConfiguration)this.configuration).getGraphEndpoint());
        if (url == null) {
            throw new GeneralSyncException("Invalid graph base endpoint configured: " + ((AzureConnectorConfiguration)this.configuration).getGraphEndpoint());
        }
        return url.newBuilder().addPathSegment(((AzureConnectorConfiguration)this.getConfiguration()).getApiVersion().getUrlPart());
    }

    @Nonnull
    private HttpUrl.Builder getUsersUrlBase() throws GeneralSyncException {
        return this.getUrlBase().addPathSegment("users");
    }

    @Nonnull
    private HttpUrl.Builder getGroupsUrlBase() throws GeneralSyncException {
        return this.getUrlBase().addPathSegment("groups");
    }

    @Override
    @Nonnull
    public Class<AzureConnectorConfiguration> getConfigurationClass() {
        return AzureConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "Azure AD";
    }

    @Override
    public List<String> getConnectorAttributes() {
        ArrayList<String> connectorAttributes = new ArrayList<String>(CONNECTOR_USER_ATTRIBUTES);
        CONNECTOR_USER_ATTRIBUTES.forEach(attribute -> connectorAttributes.add("manager." + attribute));
        connectorAttributes.add("GROUPS");
        return Collections.unmodifiableList(connectorAttributes);
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return true;
    }

    @Override
    public ValidationResult checkIdentifierForSingleUserSync(IdentifierForSingleUserSync identifier, @Nonnull ValidationResult result) {
        if (!identifier.getIdentifier().matches(".+@.+") && !identifier.getIdentifier().matches(".+-.+-.+-.+-.+")) {
            result.addError("You must either enter an Azure email address or an object id!");
        }
        return result;
    }

    @Override
    public boolean isCanUseRequiredConnectorGroupsGroovy() {
        return true;
    }

    @Override
    public boolean isCanFetchRequiredConnectorGroups() {
        return true;
    }

    @Override
    @Nonnull
    public List<ConnectionTestResultEntity.EndpointResult> doConnectionTest() {
        ArrayList<ConnectionTestResultEntity.EndpointResult> endpointResults = new ArrayList<ConnectionTestResultEntity.EndpointResult>();
        ConnectionTestResultEntity.EndpointResult accessTokenTest = this.doAccessTokenConnectionTest();
        endpointResults.add(accessTokenTest);
        if (!accessTokenTest.isSuccess()) {
            return endpointResults;
        }
        try {
            String url = this.getGroupsUrlBase().addQueryParameter(QUERY_PARAM_TOP, "1").build().toString();
            ResponseWrapper res = this.performGetRequest(url, true);
            endpointResults.add(ConnectionTestResultEntity.EndpointResult.create("Fetch Groups", url, res.isSuccess(), String.valueOf(res.getCode()), res.getBody()));
        }
        catch (Exception e) {
            endpointResults.add(ConnectionTestResultEntity.EndpointResult.createError("Fetch Groups", "", false, "FAIL", null, e.getMessage()));
            return endpointResults;
        }
        String userId = null;
        try {
            String url = this.getUsersUrlBase().addQueryParameter(QUERY_PARAM_TOP, "1").build().toString();
            ResponseWrapper res = this.performGetRequest(url, true);
            if (res.isSuccess()) {
                userId = res.getBodyAsStructuredData().asMap().get((Object)"value").asList().get(0).asMap().get((Object)"id").asString();
            }
            endpointResults.add(ConnectionTestResultEntity.EndpointResult.create("Fetch Users", url, res.isSuccess(), String.valueOf(res.getCode()), res.getBody()));
        }
        catch (Exception e) {
            endpointResults.add(ConnectionTestResultEntity.EndpointResult.createError("Fetch Users", "", false, "FAIL", null, e.getMessage()));
            return endpointResults;
        }
        if (((AzureConnectorConfiguration)this.configuration).isFetchProfilePicture()) {
            String fetchProfilePicture = "Fetch Profile Picture";
            if (userId == null) {
                endpointResults.add(ConnectionTestResultEntity.EndpointResult.createError(fetchProfilePicture, "NA", false, "SKIPPED", null, "Cannot run test because we did not get a user from the previous test. There are either no users in your Azure or the previous test failed."));
            } else {
                try {
                    String url = this.getUsersUrlBase().addPathSegment(userId).addPathSegment("photo").toString();
                    ResponseWrapper res = this.performGetRequest(url, false);
                    if (res.getCode() == 404 || res.getCode() == 200) {
                        endpointResults.add(ConnectionTestResultEntity.EndpointResult.create(fetchProfilePicture, url, true, "OK", null));
                    } else if (res.getCode() == 401) {
                        endpointResults.add(ConnectionTestResultEntity.EndpointResult.createError(fetchProfilePicture, url, false, String.valueOf(res.getCode()), res.getBody(), "Please check the error below."));
                    } else {
                        endpointResults.add(ConnectionTestResultEntity.EndpointResult.create(fetchProfilePicture, url, true, String.valueOf(res.getCode()), res.getBody()));
                    }
                }
                catch (Exception e) {
                    endpointResults.add(ConnectionTestResultEntity.EndpointResult.createError(fetchProfilePicture, "", false, "FAIL", null, e.getMessage()));
                    return endpointResults;
                }
            }
        }
        return endpointResults;
    }

    @Override
    public boolean isCanUseRequiredConnectorGroupsServerFilter() {
        return true;
    }
}

