/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import com.resolution.samlwrapper.api.tracker.WithTracker;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletUtil {
    private static final Logger logger = LoggerFactory.getLogger(ServletUtil.class);
    private static final String MESSAGE = "message";
    private static final String USER_ID = "userid";
    private static final String LOGIN_URL = "loginurl";
    private static final String SSO_URL = "ssourl";
    private static final String TRACKER = "tracker";
    private static final String TEXT_HTML_CHARSET_UTF_8 = "text/html;charset=utf-8";
    private static final String STACKTRACE = "stacktrace";

    private ServletUtil() {
    }

    public static void sendErrorHelper(HttpServletResponse resp, String userid, String message, String loginPageUrl, String ssoUrl, Throwable throwable, String pageTemplate, TemplateRenderer templateRenderer) throws IOException {
        SAMLAuthenticationTracker tracker;
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put(LOGIN_URL, loginPageUrl);
        ctx.put(SSO_URL, ssoUrl);
        ctx.put(USER_ID, userid);
        ctx.put(MESSAGE, message);
        if (throwable != null) {
            ctx.put(STACKTRACE, ExceptionUtils.getStackTrace((Throwable)throwable));
            if (message == null || message.isEmpty()) {
                ctx.put(MESSAGE, throwable.getMessage());
            }
        }
        if (throwable instanceof WithTracker && (tracker = ((WithTracker)throwable).getTracker()) != null) {
            ctx.put(TRACKER, tracker.getTrackerId());
            if (logger.isWarnEnabled()) {
                logger.warn("Tracker: {}", (Object)tracker);
            }
        }
        resp.setContentType(TEXT_HTML_CHARSET_UTF_8);
        String result = templateRenderer.renderFragment(pageTemplate, ctx);
        resp.getWriter().write(result);
    }

    public static void sendErrorHelper(HttpServletResponse resp, String userid, String message, String loginPageUrl, String ssoUrl, AuthenticationTracker tracker, String pageTemplate, TemplateRenderer templateRenderer) throws IOException {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put(LOGIN_URL, loginPageUrl);
        ctx.put(SSO_URL, ssoUrl);
        ctx.put(USER_ID, userid);
        ctx.put(MESSAGE, message);
        if (tracker != null) {
            ctx.put(TRACKER, tracker.getTrackerId());
            if (logger.isWarnEnabled()) {
                logger.warn("Tracker: {}", (Object)tracker.getTrackerId());
            }
        }
        resp.setContentType(TEXT_HTML_CHARSET_UTF_8);
        String result = templateRenderer.renderFragment(pageTemplate, ctx);
        resp.getWriter().write(result);
    }
}

