/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.resolution.atlasplugins.samlsso.HostProduct;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.auditlog.AuditLogService;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationDefaultSetter;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationLoadException;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationRuntimeException;
import com.resolution.atlasplugins.samlsso.configuration.EmailDomainIdpId;
import com.resolution.atlasplugins.samlsso.configuration.HeaderValueIdpId;
import com.resolution.atlasplugins.samlsso.configuration.JsonConfigurationLoader;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfigurationListener;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import com.resolution.atlasplugins.samlsso.configuration.SamlIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.SamlRunningIdPConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V7ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.XmlConfigurationDataLoader;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2IdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2RunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.oidc.OidcIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oidc.OidcRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.validation.ConfigurationDataValidator;
import com.resolution.samlwrapper.api.PluginProperties;
import com.resolution.samlwrapper.api.SAMLWrapper;
import com.resolution.samlwrapper.api.SAMLWrapperConfiguration;
import com.resolution.samlwrapper.api.metadata.MetadataInformation;
import com.resolution.samlwrapper.api.metadata.impl.MetadataInformationImpl;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.cert.api.CertUtil;
import de.resolution.commons.cert.api.CertUtilException;
import de.resolution.commons.cert.api.CertificateAndKey;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.usersync.api.UserSyncService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RunningConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RunningConfiguration.class);
    private static final String JSON_CONFIGURATION = "jsonConfiguration";
    private final PluginSettings pluginSettings;
    private final LicenseChecker licenseChecker;
    private final EventPublisher eventPublisher;
    private final ConfigurationDataValidator configurationValidator;
    private final ConfigurationDefaultSetter configurationDefaultSetter;
    private final CertUtil certUtil;
    private final ApplicationProperties applicationProperties;
    private final JsonConfigurationLoader jsonConfigurationLoader;
    private final CrowdDirectoryService crowdDirectoryService;
    private final AtlasUserAdapter atlasUserAdapter;
    private final AuditLogService auditLogService;
    private boolean loaded = false;
    private boolean initialized = false;
    @Nonnull
    private ConfigurationData configurationData = new ConfigurationData();
    private List<CommonRunningIdpConfiguration> runningIdPConfigurations = new ArrayList<CommonRunningIdpConfiguration>();
    private final Collection<PluginConfigurationListener> configurationListeners;
    private ValidationResult validationResult;

    public abstract HostProduct getHostProduct();

    protected RunningConfiguration(PluginSettingsFactory pluginSettingsFactory, LicenseChecker licenseChecker, ConfigurationDataValidator configurationValidator, ConfigurationDefaultSetter configurationDefaultSetter, JsonConfigurationLoader jsonConfigurationLoader, SAMLWrapper samlWrapper, ApplicationProperties applicationProperties, EventPublisher eventPublisher, CrowdDirectoryService crowdDirectoryService, UserSyncService userSyncService, AtlasUserAdapter atlasUserAdapter, AuditLogService auditLogService) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.configurationValidator = configurationValidator;
        this.configurationDefaultSetter = configurationDefaultSetter;
        this.jsonConfigurationLoader = jsonConfigurationLoader;
        this.licenseChecker = licenseChecker;
        this.configurationListeners = new ArrayList<PluginConfigurationListener>();
        this.certUtil = samlWrapper.getCertUtil();
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
        this.eventPublisher.register((Object)this);
        this.crowdDirectoryService = crowdDirectoryService;
        this.atlasUserAdapter = atlasUserAdapter;
        this.auditLogService = auditLogService;
    }

    @EventListener
    public void loadConfigurationAfterStartup(PluginEnabledEvent pluginEnabledEvent) {
        if (Objects.equals(PluginProperties.get((String)"pluginkey"), pluginEnabledEvent.getPlugin().getKey())) {
            logger.debug("Unregistering from EventPublisher");
            this.eventPublisher.unregister((Object)this);
            this.callInitialize();
        } else if (logger.isDebugEnabled()) {
            logger.debug("Ignoring PluginEnabledEvent for {}", (Object)pluginEnabledEvent.getPlugin().getKey());
        }
    }

    private void callInitialize() {
        if (!this.initialized) {
            this.initialized = true;
            logger.info("Loading configuration");
            this.load();
            this.fireConfigurationUpdated();
        } else {
            logger.warn("Already initialized, this method should have been called only once.");
        }
    }

    @Deprecated
    public Map<String, Long> getWritableDirectories() {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        for (Directory dir : this.crowdDirectoryService.findAllDirectories()) {
            if (!dir.getAllowedOperations().contains(OperationType.CREATE_USER) || !dir.getAllowedOperations().contains(OperationType.UPDATE_USER) || !dir.getAllowedOperations().contains(OperationType.UPDATE_GROUP)) continue;
            logger.debug("Found writable directory {} {}", (Object)dir.getId(), (Object)dir.getName());
            ret.put(dir.getName(), dir.getId());
        }
        return ret;
    }

    private String loadLatestXmlConfigurationString(int version) {
        if (version <= 0) {
            return null;
        }
        logger.debug("Trying to load xmlConfiguration v{}", (Object)version);
        String xmlString = (String)this.pluginSettings.get(ConfigurationData.getPluginSettingsKey("xmlConfiguration", version));
        if (xmlString != null && !xmlString.isEmpty()) {
            logger.debug("Found xmlConfiguration v{}", (Object)version);
            return xmlString;
        }
        if (version == 1) {
            logger.debug("It seems that there is no older xmlConfiguration");
            return null;
        }
        return this.loadLatestXmlConfigurationString(version - 1);
    }

    private String loadLatestJsonConfigurationString(int version) {
        if (version < 7) {
            return null;
        }
        logger.debug("Trying to load JSON configuration {}", (Object)version);
        String jsonString = (String)this.pluginSettings.get(ConfigurationData.getPluginSettingsKey(JSON_CONFIGURATION, version));
        if (jsonString != null && !jsonString.isEmpty()) {
            logger.debug("Found JSON configuration version {}", (Object)version);
            return jsonString;
        }
        return this.loadLatestJsonConfigurationString(version - 1);
    }

    public void load() {
        logger.info("Loading Configuration");
        String jsonString = this.loadLatestJsonConfigurationString(14);
        if (jsonString != null) {
            this.load(jsonString);
        } else {
            String xmlString = this.loadLatestXmlConfigurationString(7);
            if (xmlString != null) {
                logger.info("Migrating existing XML-configuration to JSON");
                XmlConfigurationDataLoader xmlLoader = new XmlConfigurationDataLoader();
                V7ConfigurationData v7Data = xmlLoader.load(xmlString);
                try {
                    String configAsJson = new ObjectMapper().writer().writeValueAsString((Object)v7Data);
                    String jsonKey = ConfigurationData.getPluginSettingsKey(JSON_CONFIGURATION, 7);
                    logger.info("JSON-config is: {}", (Object)configAsJson);
                    logger.info("Storing json-config at {} and reloading", (Object)jsonKey);
                    this.pluginSettings.put(jsonKey, (Object)configAsJson);
                    this.load();
                }
                catch (Exception e) {
                    throw new ConfigurationRuntimeException("Reloading existing XML configuration as JSON failed!", e);
                }
            } else {
                logger.info("No JSON or XML configuration found, creating new config");
                ConfigurationData configData = new ConfigurationData();
                configData.version = 14;
                this.configurationDefaultSetter.addSamlDefaults(configData, true);
                this.createNewCertificate(configData, false);
                this.configurationData = configData;
                this.validationResult = ValidationResult.create();
            }
        }
        this.loaded = true;
    }

    public void load(@Nonnull String jsonString) {
        try {
            ConfigurationData configData = this.jsonConfigurationLoader.load(jsonString, this.getHostProduct());
            this.load(configData);
        }
        catch (ConfigurationLoadException e) {
            throw new ConfigurationRuntimeException("Loading JSON-configuration failed!", e);
        }
    }

    public void load(@Nonnull ConfigurationData configData) {
        String applicationPrefix;
        logger.info("Configuration Data version: {}", (Object)configData.version);
        this.configurationDefaultSetter.addSamlDefaults(configData, false);
        switch (this.getHostProduct()) {
            case JIRA: {
                applicationPrefix = "JIRA.PROP.";
                break;
            }
            case CONFLUENCE: {
                applicationPrefix = "CONFLUENCE.UD.";
                break;
            }
            case BITBUCKET: {
                applicationPrefix = "BITBUCKET.";
                logger.warn("Bitbucket-specific attributes are currently not supported");
                break;
            }
            case BAMBOO: {
                applicationPrefix = "BAMBOO.";
                logger.warn("Bamboo-specific attributes are currently not supported");
                break;
            }
            case FECRU: {
                applicationPrefix = "FECRU.";
                logger.warn("FeCru-specific attributes are currently not supported");
                break;
            }
            default: {
                logger.error("Host {} is unknown", (Object)this.getHostProduct());
                applicationPrefix = "UNKNOWN_HOSTPRODUCT.";
            }
        }
        this.runningIdPConfigurations = new ArrayList<CommonRunningIdpConfiguration>();
        for (CommonIdpConfigurationData idpConfigurationData : configData.idpConfigurations) {
            if (idpConfigurationData.protocolType == ProtocolType.SAML) {
                this.runningIdPConfigurations.add(new SamlRunningIdPConfiguration((SamlIdpConfigurationData)idpConfigurationData, applicationPrefix, this.atlasUserAdapter));
                continue;
            }
            if (idpConfigurationData.protocolType == ProtocolType.OIDC) {
                this.runningIdPConfigurations.add(new OidcRunningIdpConfiguration((OidcIdpConfigurationData)idpConfigurationData, this.atlasUserAdapter, configData));
                continue;
            }
            if (idpConfigurationData.protocolType == ProtocolType.OAU2) {
                this.runningIdPConfigurations.add(new OAuth2RunningIdpConfiguration((OAuth2IdpConfigurationData)idpConfigurationData, this.atlasUserAdapter));
                continue;
            }
            logger.error("Encountered wrong type while loading config. Type was {}", idpConfigurationData.getClass());
        }
        this.configurationData = configData;
        boolean createdNewCert = this.createNewCertificate(configData, false);
        if (createdNewCert) {
            this.store(configData);
        }
        this.validationResult = this.configurationValidator.validate(configData, null);
    }

    public boolean createNewCertificate(ConfigurationData configData, boolean force) {
        boolean createdNewCert = false;
        if (configData.privateKeyPEM == null || configData.privateKeyPEM.trim().isEmpty() || configData.certificatePEM == null || configData.certificatePEM.trim().isEmpty()) {
            if (!force && this.configurationData.privateKeyPEM != null && this.configurationData.certificatePEM != null) {
                logger.info("Use existing certificate from pluginConfiguration");
                configData.privateKeyPEM = this.configurationData.privateKeyPEM;
                configData.certificatePEM = this.configurationData.certificatePEM;
                createdNewCert = true;
            } else {
                logger.info("Creating a new certifcate");
                try {
                    String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
                    CertificateAndKey certAndKey = this.certUtil.createCertificate("cn=SAML SingleSignOn certificate for " + baseUrl);
                    configData.certificatePEM = certAndKey.getCertificatePEM();
                    configData.privateKeyPEM = certAndKey.getPrivateKeyPEM();
                    createdNewCert = true;
                }
                catch (CertUtilException e) {
                    logger.error("Creating certificate failed", (Throwable)e);
                }
            }
        }
        return createdNewCert;
    }

    public void clear() {
        logger.warn("clear() has been called, deleting the configuration");
        this.pluginSettings.remove(ConfigurationData.getPluginSettingsKey(JSON_CONFIGURATION));
        this.load();
        this.fireConfigurationCleared();
    }

    private String createJson(ConfigurationData configurationData) {
        try {
            ObjectWriter objectWriter = new ObjectMapper().writerWithDefaultPrettyPrinter();
            ConfigurationData simplifiedConfigurationData = this.configurationDefaultSetter.clearSamlDefaults(configurationData);
            return objectWriter.writeValueAsString((Object)simplifiedConfigurationData);
        }
        catch (IOException e) {
            throw new ConfigurationRuntimeException("Creating configuration-JSON failed", e);
        }
    }

    public void store() {
        this.store(this.configurationData);
    }

    public void store(ConfigurationData configurationData) {
        String jsonString = this.createJson(configurationData);
        logger.debug("Storing configuration-json {}", (Object)jsonString);
        this.pluginSettings.put(ConfigurationData.getPluginSettingsKey(JSON_CONFIGURATION), (Object)jsonString);
    }

    public boolean update(ConfigurationData newConfig) {
        ValidationResult temp = this.configurationValidator.validate(newConfig, null);
        if (newConfig.skipBaseUrlCheck) {
            logger.warn("==== skipBaseUrlCheck is true. The URL from the RelayState parameter will not be checked to match the Base URL. Be aware that this is a potential security issue ===");
        }
        if (temp.isValid()) {
            ConfigurationData oldConfigurationData = new ConfigurationData(this.configurationData);
            this.configurationDefaultSetter.addSamlDefaults(newConfig, false);
            this.configurationData = newConfig;
            Collections.sort(this.configurationData.idpConfigurations);
            this.store(this.configurationData);
            this.fireConfigurationUpdated();
            this.auditLogService.logConfigurationUpdate(oldConfigurationData, this.configurationData);
            return true;
        }
        if (logger.isWarnEnabled()) {
            logger.warn("New config is not valid: {}", (Object)Utils.asJsonString(temp));
        }
        return false;
    }

    public boolean isEnableIdPSelection() {
        return this.configurationData.idpSelectionMethod == IdpSelectionMethod.SELECTIONPAGE;
    }

    public boolean isEnableIdPSelectionByEmailAddress() {
        return this.configurationData.idpSelectionMethod == IdpSelectionMethod.EMAIL;
    }

    public boolean isShowSelectionPageWhenEmailCookie() {
        return this.configurationData.showSelectionPageWhenEmailCookie;
    }

    public boolean isRedirectToSso() {
        return this.configurationData.redirectToSso;
    }

    public void setOverrideLoginUrl(boolean enable) {
        this.configurationData.redirectToSso = enable;
        this.store(this.configurationData);
    }

    public OverrideLoggedOutUrlMethod getOverrideLoggedOutUrlMethod() {
        return this.configurationData.overrideLoggedOutUrlMethod;
    }

    public boolean isNossoEnabled() {
        return this.configurationData.nossoEnabled;
    }

    public void setNossoEnabled(boolean enable) {
        this.configurationData.nossoEnabled = enable;
        this.store(this.configurationData);
    }

    public boolean isEnableUserForLogin() {
        return this.configurationData.enableUserForLogin;
    }

    public boolean isRedirectServiceDeskLogin() {
        return this.configurationData.redirectServiceDeskLogin;
    }

    public List<String> getServiceDeskPortalsToRedirect() {
        return this.configurationData.serviceDeskPortalsToRedirect;
    }

    public String getDefaultRedirectUrl() {
        return this.configurationData.defaultRedirectUrl;
    }

    public String getLogoutUrl() {
        if (this.configurationData.logoutUrl != null && !this.configurationData.logoutUrl.isEmpty()) {
            return this.configurationData.logoutUrl;
        }
        return null;
    }

    @Deprecated
    public boolean isCustomLogoutUrl() {
        return this.configurationData.logoutUrl != null && !this.configurationData.logoutUrl.isEmpty();
    }

    public boolean isEnforceResponseValidityDates() {
        return this.configurationData.enforceResponseValidityDates;
    }

    public boolean isValidateSamlMessageXml() {
        return this.configurationData.validateSamlMessageXml;
    }

    public boolean isIncludeSigningCertificateInMetadata() {
        return this.configurationData.includeSigningCertificateInMetadata;
    }

    public boolean isIncludeEncryptionCertificateInMetadata() {
        return this.configurationData.includeEncryptionCertificateInMetadata;
    }

    public boolean isIncludeLogoutUrlInMetadata() {
        return this.configurationData.includeLogoutUrlInMetadata;
    }

    public boolean isBlockPasswordAuthentication() {
        return this.configurationData.blockPasswordAuthentication;
    }

    public int getClockSkew() {
        return this.configurationData.clockSkew;
    }

    public boolean isEnforceResponseIDUniqueness() {
        return this.configurationData.enforceResponseIDUniqueness;
    }

    public List<String> getGroupsToAddUserTo() {
        return this.configurationData.groupsToAddUserTo;
    }

    @Nonnull
    public List<String> getNonSsoUserAgents() {
        return this.configurationData.nonSsoUserAgents;
    }

    @Nonnull
    public List<String> getNonSsoDestinations() {
        return this.configurationData.nonSsoDestinations;
    }

    @Nonnull
    public List<String> getEnforceSsoDestinations() {
        return this.configurationData.enforceSsoDestinations;
    }

    public boolean isIncludeQueryStringForEnforceSsoDestinations() {
        return this.configurationData.includeQueryStringForEnforceSsoDestinations;
    }

    public String getErrorPageTemplate() {
        return this.configurationData.errorPageTemplate;
    }

    public String getServiceDeskErrorPageTemplate() {
        return this.configurationData.serviceDeskErrorPageTemplate;
    }

    public String getLoggedInPageTemplate() {
        return this.configurationData.loggedInPageTemplate;
    }

    public String getLoggedOutPageTemplate() {
        return this.configurationData.loggedOutPageTemplate;
    }

    public String getIdpSelectionPageTemplate() {
        return this.configurationData.idpSelectionPageTemplate;
    }

    public String getIdpByEmailPageTemplate() {
        return this.configurationData.idpByEmailPageTemplate;
    }

    public String getIdpByEmailPageJavaScript() {
        return this.configurationData.idpByEmailPageJavaScript;
    }

    public boolean isSetRememberMeCookie() {
        return this.configurationData.setRememberMeCookie;
    }

    public boolean isFetchFromRemoteDirectory() {
        return this.configurationData.fetchFromRemoteDirectory;
    }

    public boolean isTriggerUpdateOnCrowdDirectories() {
        return this.configurationData.triggerUpdateOnCrowdDirectories;
    }

    public void setTriggerUpdateOnCrowdDirectories(boolean triggerUpdateOnCrowdDirectories) {
        this.configurationData.triggerUpdateOnCrowdDirectories = triggerUpdateOnCrowdDirectories;
    }

    public String getPrivateKeyPEM() {
        return this.configurationData.privateKeyPEM;
    }

    public String getCertificatePEM() {
        return this.configurationData.certificatePEM;
    }

    public String getEntityId() {
        return this.configurationData.entityId;
    }

    public String getDefaultEntityId() {
        return this.configurationDefaultSetter.getDefaultEntityId();
    }

    public boolean isSetSameSiteAttributeOnSessionCookie() {
        return this.configurationData.setSameSiteAttributeOnSessionCookie;
    }

    public String getSessionCookieName() {
        return this.configurationData.sessionCookieName;
    }

    public List<CommonRunningIdpConfiguration> getRunningIdPConfigurations() {
        return Collections.unmodifiableList(this.runningIdPConfigurations);
    }

    public List<OidcRunningIdpConfiguration> getOidcRunningIdpConfigurations() {
        return this.runningIdPConfigurations.stream().filter(OidcRunningIdpConfiguration.class::isInstance).map(OidcRunningIdpConfiguration.class::cast).collect(Collectors.toList());
    }

    public List<SamlRunningIdPConfiguration> getSamlRunningIdpConfigurations() {
        return this.runningIdPConfigurations.stream().filter(SamlRunningIdPConfiguration.class::isInstance).map(SamlRunningIdPConfiguration.class::cast).collect(Collectors.toList());
    }

    public SamlRunningIdPConfiguration getSamlRunningIdpConfiguration(int id) {
        return this.getSamlRunningIdpConfigurations().stream().filter(conf -> conf.getId() == id).findFirst().orElse(null);
    }

    public CommonRunningIdpConfiguration getRunningIdpConfiguration(int id) {
        return this.runningIdPConfigurations.stream().filter(conf -> conf.getId() == id).findFirst().orElse(null);
    }

    @Nullable
    public CommonRunningIdpConfiguration getRunningIdpConfiguration(@Nonnull String idpId) {
        return this.runningIdPConfigurations.stream().filter(conf -> Objects.equals(conf.getIdpId(), idpId)).findFirst().orElse(null);
    }

    public List<HeaderValueIdpId> getRequestHeadersForIdpSelection() {
        return this.configurationData.requestHeadersForIdpSelection;
    }

    public List<EmailDomainIdpId> getEmailDomainsForIdpSelection() {
        return this.configurationData.emailDomainsForIdpSelection;
    }

    public List<String> getAllowedNotificationEmailAddresses() {
        return this.configurationData.allowedNotificationEmailAddresses;
    }

    @Deprecated
    public boolean isLicensed() {
        if (this.licenseChecker == null) {
            return false;
        }
        return this.licenseChecker.checkLicense().isLicensed();
    }

    public boolean isSkipBaseUrlCheck() {
        return this.configurationData.skipBaseUrlCheck;
    }

    public void setSkipBaseUrlCheck(boolean skipBaseUrlCheck) {
        this.configurationData.skipBaseUrlCheck = skipBaseUrlCheck;
    }

    public int getTrackerStorageHours() {
        return this.configurationData.trackerStorageHours;
    }

    public int getTrackerCleanupIntervalInMinutes() {
        return this.configurationData.trackerCleanupIntervalInMinutes;
    }

    public int getResponseIdStorageIntervalInHours() {
        return this.configurationData.responseIdStorageIntervalInHours;
    }

    public void setResponseIdStorageIntervalInHours(int responseIdStorageIntervalInHours) {
        this.configurationData.responseIdStorageIntervalInHours = responseIdStorageIntervalInHours;
    }

    public MetadataInformation getMetadataInformation() {
        return this.configurationData.metadataInformation;
    }

    public void setMetadataInformation(MetadataInformationImpl metdataInformation) {
        this.configurationData.metadataInformation = metdataInformation;
    }

    public long getRegexTimeout() {
        return this.configurationData.regexTimeout;
    }

    public void setRegexTimeout(long regexTimeout) {
        this.configurationData.regexTimeout = regexTimeout;
    }

    public int getReloadMetadataIntervalInMinutes() {
        return this.configurationData.reloadMetadataIntervalInMinutes;
    }

    public boolean isBlockUrlsWithPathParameters() {
        return this.configurationData.blockPasswordAuthentication;
    }

    public int getAnalyticsConsentLevel() {
        return this.configurationData.analyticsConsentLevel;
    }

    @Nullable
    public String getCommonMetadataCertificate() {
        return this.configurationData.commonMetadataCertificate;
    }

    @Nullable
    public String getCommonMetadataUrl() {
        return this.configurationData.commonMetadataUrl;
    }

    public boolean isCommonMetadataAutoReload() {
        return this.configurationData.commonMetadataAutoReload;
    }

    public boolean isAcceptHolderOfKeyLikeBearer() {
        return this.configurationData.acceptHolderOfKeyLikeBearer;
    }

    public void addListener(PluginConfigurationListener listener) {
        if (!this.configurationListeners.contains(listener)) {
            this.configurationListeners.add(listener);
            logger.debug("Added ConfigurationListener");
        } else {
            logger.debug("ConfigurationListener is already registered, skipping.");
        }
        logger.debug("{} ConfigurationListeners are registered", (Object)this.configurationListeners.size());
    }

    public void removeListener(PluginConfigurationListener listener) {
        this.configurationListeners.remove(listener);
    }

    protected void fireConfigurationUpdated() {
        for (PluginConfigurationListener listener : this.configurationListeners) {
            listener.configurationUpdated();
        }
    }

    protected void fireConfigurationCleared() {
        for (PluginConfigurationListener listener : this.configurationListeners) {
            listener.configurationCleared();
        }
    }

    public ConfigurationData getConfigurationData() {
        return new ConfigurationData(this.configurationData);
    }

    public CommonRunningIdpConfiguration getFirstRunningIdpConfiguration() {
        if (this.runningIdPConfigurations.isEmpty()) {
            return null;
        }
        return this.runningIdPConfigurations.get(0);
    }

    public boolean isValid() {
        if (this.validationResult == null) {
            return false;
        }
        return this.validationResult.isValid();
    }

    @JsonIgnore
    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    @Nonnull
    public List<String> getDefaultEnforceSsoUrls() {
        return this.configurationDefaultSetter.getDefaultEnforceSsoUrls();
    }

    @Nonnull
    public List<String> getDefaultNonSsoUrls() {
        return this.configurationDefaultSetter.getDefaultNonSsoUrls();
    }

    @Nonnull
    public List<String> getDefaultNonSsoUserAgents() {
        return this.configurationDefaultSetter.getDefaultNonSsoUserAgents();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public List<String> getRedirectCheckerBlockedStrings() {
        return new ArrayList<String>(this.configurationData.redirectCheckerBlockedStrings);
    }

    public SAMLWrapperConfiguration.TrueFalseNone getWantAssertionsSigned() {
        return this.configurationData.wantAssertionsSigned;
    }

    public SAMLWrapperConfiguration.TrueFalseNone getAuthnRequestsSigned() {
        return this.configurationData.authnRequestsSigned;
    }

    public String getIdpButtonsPageTemplate() {
        return this.configurationData.idpButtonsPageTemplate;
    }

    public boolean hideLoginForm() {
        return this.configurationData.hideLoginForm;
    }

    public static enum IdpSelectionMethod {
        SELECTIONPAGE("IdP Selection Page"),
        EMAIL("Email Address"),
        FIRST("Use IdP with lowest weight");

        private final String display;

        private IdpSelectionMethod(String display) {
            this.display = display;
        }

        public String getDisplay() {
            return this.display;
        }
    }

    public static enum OverrideLoggedOutUrlMethod {
        NO_REDIRECTION("No redirection after logout"),
        REDIRECT_ALL("Redirect all users after logout"),
        REDIRECT_SSO_ONLY("Redirect only SSO users after logout");

        private final String display;

        private OverrideLoggedOutUrlMethod(String display) {
            this.display = display;
        }

        public String getDisplay() {
            return this.display;
        }
    }
}

