/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bitbucket.userauth;

import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.ExpiredAuthenticationException;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.auth.HttpLogoutHandler;
import com.atlassian.bitbucket.auth.NoAccessAuthenticationException;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.SingleLogoutService;
import com.resolution.atlasplugins.samlsso.SingleLogoutServiceException;
import com.resolution.atlasplugins.samlsso.bitbucket.userauth.OnlySAMLAuthenticationAllowedException;
import com.resolution.atlasplugins.samlsso.bitbucket.userauth.SSOTokenStore;
import de.resolution.commons.util.StringUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent(value="BitbucketSsoAuthenticationHandler")
public class BitbucketSsoAuthenticationHandler
implements HttpAuthenticationHandler,
HttpLogoutHandler {
    static final String SSO_TOKEN_NAME = "ssoToken";
    static final String SSO_AUTHENTICATED = "ssoAuthenticated";
    private static final String PASSWORD_AUTH_GROUP_NAME = "allow-password-login";
    private static final String KEY_CONTAINER_AUTH_NAME = "auth.container.remote-user";
    private static final Logger logger = LoggerFactory.getLogger(BitbucketSsoAuthenticationHandler.class);
    private final UserService userService;
    private final SSOTokenStore ssoTokenStore;
    private final SamlSsoService samlSsoService;
    private final PermissionService permissionService;
    private final SecurityService securityService;
    private final SingleLogoutService singleLogoutService;

    @Autowired
    public BitbucketSsoAuthenticationHandler(@BitbucketImport UserService userService, @BitbucketImport PermissionService permissionService, @BitbucketImport SecurityService securityService, SSOTokenStore ssoTokenStore, SamlSsoService samlSsoService, SingleLogoutService singleLogoutService) {
        this.userService = userService;
        this.ssoTokenStore = ssoTokenStore;
        this.samlSsoService = samlSsoService;
        this.permissionService = permissionService;
        this.securityService = securityService;
        this.singleLogoutService = singleLogoutService;
    }

    @Nullable
    public AuthenticationResult performAuthentication(@Nonnull HttpAuthenticationContext authenticationContext) {
        ApplicationUser applicationUser = this.authenticate(authenticationContext);
        if (applicationUser == null) {
            return null;
        }
        return new AuthenticationResult.Builder(applicationUser).build();
    }

    @Nullable
    public ApplicationUser authenticate(@Nonnull HttpAuthenticationContext httpAuthenticationContext) {
        logger.debug("BitbucketSsoAuthenticationHandler Authentication started.");
        HttpServletRequest request = httpAuthenticationContext.getRequest();
        String remoteUser = request.getRemoteUser();
        if (logger.isDebugEnabled()) {
            logger.debug("remoteUser is {}", (Object)StringUtil.sanitize((String)remoteUser));
        }
        HttpSession session = request.getSession(false);
        logger.debug("session is {}", (Object)session);
        if (session == null) {
            return this.checkIfNonSAMLIsAllowed(httpAuthenticationContext);
        }
        String ssotoken = (String)session.getAttribute(SSO_TOKEN_NAME);
        String userFromContext = httpAuthenticationContext.getUsername();
        logger.debug("User from context is {}", (Object)userFromContext);
        if (ssotoken == null) {
            return this.checkIfNonSAMLIsAllowed(httpAuthenticationContext);
        }
        logger.debug("Retrieved samlssotoken from request: {}. ", (Object)ssotoken);
        String userid = this.ssoTokenStore.getUseridFromSsoToken(ssotoken);
        if (userid == null) {
            logger.debug("No userid found for samlssotoken {}, cancelling authentication.", (Object)ssotoken);
            return this.checkIfNonSAMLIsAllowed(httpAuthenticationContext);
        }
        ApplicationUser user = this.userService.getUserByName(userid);
        if (user != null) {
            request.setAttribute(KEY_CONTAINER_AUTH_NAME, (Object)remoteUser);
            logger.debug("User {} found, returning user for authentication.", (Object)user.getName());
            return user;
        }
        if (logger.isErrorEnabled()) {
            logger.error("User {} not found. Container-provided authentication failed.", (Object)StringUtil.sanitize((String)request.getRemoteUser()));
        }
        String message = "The user '" + userid + "' was not found in any configured user directory.";
        throw new NoAccessAuthenticationException(new KeyedMessage("user not found", message, message));
    }

    @Nullable
    private ApplicationUser checkIfNonSAMLIsAllowed(@Nonnull HttpAuthenticationContext httpAuthenticationContext) {
        if ("token".equals(httpAuthenticationContext.getMethod())) {
            logger.debug("Accessing via token, passing authentication request through.");
            return null;
        }
        String userid = httpAuthenticationContext.getUsername();
        if (userid == null) {
            return null;
        }
        if (!this.samlSsoService.getRunningConfiguration().isBlockPasswordAuthentication()) {
            return null;
        }
        ApplicationUser applicationUser = this.userService.getUserByName(userid);
        if (applicationUser == null) {
            logger.warn("Applicationuser for {} is null, returning null", (Object)userid);
            return null;
        }
        if (this.permissionService.hasGlobalPermission(applicationUser, Permission.SYS_ADMIN)) {
            logger.debug("User is allowed to do non-SAML-authentication");
            return null;
        }
        boolean isUserInGroup = (Boolean)this.securityService.withPermission(Permission.SYS_ADMIN, "Group check").call(() -> this.userService.isUserInGroup(applicationUser, PASSWORD_AUTH_GROUP_NAME));
        if (isUserInGroup) {
            logger.debug("User is allowed to do non-SAML-authentication, is in group {}", (Object)PASSWORD_AUTH_GROUP_NAME);
            return null;
        }
        throw new OnlySAMLAuthenticationAllowedException();
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext httpAuthenticationContext) {
        HttpServletRequest request = httpAuthenticationContext.getRequest();
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        String ssoAuthenticated = (String)session.getAttribute(SSO_AUTHENTICATED);
        if (ssoAuthenticated != null && !ssoAuthenticated.equals("true")) {
            logger.info("SAML SingleSignOn authentication no longer valid.");
            session.removeAttribute(SSO_AUTHENTICATED);
            throw new ExpiredAuthenticationException(new KeyedMessage("ssoNoLongerValid", "The authentication is no longer valid.", "The authentication is no longer valid."));
        }
    }

    public void logout(@Nonnull ApplicationUser arg0, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        try {
            this.singleLogoutService.doSingleLogout(request, response);
        }
        catch (SingleLogoutServiceException e) {
            logger.error("Error during Single Logout out", (Throwable)e);
        }
    }
}

