/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bitbucket.userauth;

import com.atlassian.bitbucket.auth.HttpAuthenticationFailureContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureHandler;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.resolution.atlasplugins.samlsso.bitbucket.BitbucketSamlSsoService;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent(value="BitbucketSsoAuthenticationFailureHandler")
public class BitbucketSsoAuthenticationFailureHandler
implements HttpAuthenticationFailureHandler {
    private BitbucketSamlSsoService samlSsoService;

    @Autowired
    public BitbucketSsoAuthenticationFailureHandler(BitbucketSamlSsoService samlSsoService) {
        this.samlSsoService = samlSsoService;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws IOException {
        boolean isSSO;
        HttpSession session = context.getRequest().getSession(false);
        if (session == null) {
            return false;
        }
        boolean bl = isSSO = session.getAttribute("ssoAuthenticated") != null;
        if (isSSO) {
            session.removeAttribute("ssoAuthenticated");
            session.setAttribute("failureContext", (Object)context);
            String redirectUrl = this.samlSsoService.getRelativeBaseUrl() + "/plugins/servlet/samlsso" + "/error";
            context.getResponse().setHeader("cache-control", "no-cache, no-store, must-revalidate");
            context.getResponse().sendRedirect(redirectUrl);
            return true;
        }
        return false;
    }
}

