(function() {
    var webSudoWithSAML = window.resolution.webSudoWithSAML;
    var additionalAuthBase =  AJS.contextPath() + '/rest/samlsso-admin/1.0/additionalauth';
    var triggerWebsudoUrl  =  AJS.contextPath() + '/rest/samlsso-admin/1.0/websudo';
    webSudoWithSAML.injectDiv.removeClass();
    webSudoWithSAML.injectDiv.addClass("aui-message aui-message-info");
    webSudoWithSAML.injectDiv.append("<aui-spinner size=\"small\"></aui-spinner> Checking if this is a SAML-session...");
    AJS.$.ajax({
        url: additionalAuthBase + '/enabled',
        dataType: "json",
        success: function (data) {
            webSudoWithSAML.injectDiv.empty();
            if(data.enabled) {
                var newButton = AJS.$(
                    "<input>", {
                        type:  "button",
                        class: "aui-button",
                        value: "Re-Authenticate"
                    }).click(function() {
                    requestWebsudoAuthentication();
                });
                webSudoWithSAML.injectDiv.append(
                    AJS.$("<p>You are logged in using single sign-on.</p><p>Click this button to re-authenticate with single sign-on instead of entering your password below.</p>")
                );
                webSudoWithSAML.injectDiv.append("<p>").append(newButton);
                webSudoWithSAML.injectDiv.append("<p><b>This will open a new browser window.</b></p>");
            } else {
                console.log("This is no SAML-session.");
                webSudoWithSAML.injectDiv.removeClass("aui-message aui-message-info");
                webSudoWithSAML.injectDiv.empty();
            }
        },
        error: function(error) {
            webSudoWithSAML.injectDiv.empty();
            webSudoWithSAML.injectDiv.removeClass();
            webSudoWithSAML.injectDiv.addClass("aui-message aui-message-error");
            webSudoWithSAML.injectDiv.append("<p>Checking for SAML-session failed!</p>");
            console.log(error);
        }
    });

    var requestWebsudoAuthentication = function() {
        AJS.$.ajax({
            url: triggerWebsudoUrl,
            type: 'POST',
            dataType: "json",
            contentType: "application/json",
            data: JSON.stringify({ 'webSudoDestination': webSudoWithSAML.webSudoDestination }),
            success: function(data) {
                webSudoWithSAML.injectDiv.empty();
                webSudoWithSAML.injectDiv.removeClass();
                webSudoWithSAML.injectDiv.addClass("aui-message aui-message-info");
                webSudoWithSAML.injectDiv.append("<p><aui-spinner size=\"small\"></aui-spinner>Waiting for authentication....</p>");
                webSudoWithSAML.injectDiv.append("<p>Authenticate at your Identity Provider in the new window.</p>");
                startWebsudoAuthentication(data.authenticationUrl, data.afterAuthenticationUrl);
            },
            error: function(error) {
                webSudoWithSAML.injectDiv.empty();
                webSudoWithSAML.injectDiv.removeClass();
                webSudoWithSAML.injectDiv.addClass("aui-message aui-message-error");
                webSudoWithSAML.injectDiv.append("<p>Request for WebSudo-authenticaton failed!</p>");
                console.log(error);
            }
        });
    }

    var startWebsudoAuthentication = function(authUrl, afterAuthUrl) {
        var awaitingAuthentication = false;
        window.addEventListener('storage', function(event) {
            if(event.key === 'additionalSAMLAuthentication' && awaitingAuthentication) {
                awaitingAuthentication = false;
                window.location.href = afterAuthUrl;
            }
        });
        awaitingAuthentication = true;
        window.open(authUrl, 'newwindow', 'width=600,height=600,left=200,top=200');
    }
})();


