/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.CronScheduleInfo;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.atlasuser.api.HostProductProvider;
import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import de.resolution.atlasuser.api.directory.AtlasUserDirectoryBuilder;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.DirectoryNameExistsAlreadyException;
import de.resolution.atlasuser.api.exception.DirectoryNotFoundException;
import de.resolution.atlasuser.api.exception.InvalidOperationException;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.validate.api.ValidationMessage;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.reconfigure.cronexpressionrest.CronExpressionValidator;
import de.resolution.retransform.config.AttributeTransformationConfigValidator;
import de.resolution.usersync.api.ConnectorAndValidationResult;
import de.resolution.usersync.api.ConnectorFactoryRegistry;
import de.resolution.usersync.api.ConnectorGroup;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.ConnectorStorageManager;
import de.resolution.usersync.api.IdentifierForSingleUserSync;
import de.resolution.usersync.api.LabelValue;
import de.resolution.usersync.api.NotificationService;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.api.exception.ConnectorUniqueIdExistsAlreadyException;
import de.resolution.usersync.api.exception.ConnectorUniqueIdNotUniqueException;
import de.resolution.usersync.api.exception.GeneralSyncException;
import de.resolution.usersync.api.exception.UserSyncRuntimeException;
import de.resolution.usersync.auditlog.UserSyncAuditLogService;
import de.resolution.usersync.impl.AoConnectorConfiguration;
import de.resolution.usersync.impl.AoSyncStatus;
import de.resolution.usersync.impl.DirectoryIdAndName;
import de.resolution.usersync.impl.SyncJobRunner;
import de.resolution.usersync.impl.UnavailableConnector;
import de.resolution.usersync.impl.UnavailableConnectorConfiguration;
import de.resolution.usersync.impl.UserSyncXsrfCheckAvoider;
import de.resolution.usersync.impl.legacy.LegacyAoConnectorConfiguration;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerHolder;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import de.resolution.usersync.spi.ConnectorFactory;
import de.resolution.usersync.util.UserSyncPluginProperties;
import de.resolution.usersync.util.UserSyncUtils;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={ConnectorService.class})
public class ConnectorServiceImpl
implements ConnectorService {
    private static final Logger logger = LoggerFactory.getLogger(ConnectorServiceImpl.class);
    private static final String OLD_JOB_ID_BASE = "de.resolution.usersync.UserSyncJob_";
    private static final String JOB_ID_BASE = "de.resolution.usersync.UserSyncJobId_";
    private final ConnectorFactoryRegistry connectorFactoryRegistry;
    private final ActiveObjects ao;
    private final DirectoryAdapter directoryAdapter;
    private final SchedulerService schedulerService;
    private final ConnectorStorageManager connectorStorageManager;
    private final CronExpressionValidator cronExpressionValidator;
    private final EventPublisher eventPublisher;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Map<String, ConnectorAndValidationResult<?, ?>> connectorCache = new HashMap();
    private final String applicationPrefix;
    private final AtlasUserAdapter atlasUserAdapter;
    private final ApplicationProperties applicationProperties;
    private final NotificationService notificationService;
    private final AttributeTransformationConfigValidator attributeTransformationConfigValidator;
    private final UserSyncAuditLogService userSyncAuditLogService;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final UserSyncXsrfCheckAvoider xsrfCheckAvoider;
    private static final String CN_LAST_UPDATED = "LAST_UPDATED";
    private static final String CN_CLASS_NAME = "CLASS_NAME";
    private static final String CN_CONFIG_VERSION = "CONFIG_VERSION";
    private static final String CN_UNIQUE_ID = "UNIQUE_ID";
    private static final String CN_CONFIGURATION_STRING = "CONFIGURATION_STRING";
    private static final String CN_NEW = "NEW";
    private static final String CN_NAME = "NAME";
    private static final String CN_SANITIZED_CONFIGURATION_STRING = "SANITIZED_CONFIGURATION_STRING";
    private static final String WHERE_UNIQUE_ID_AND_CONFIG_VERSION = "UNIQUE_ID = ? AND CONFIG_VERSION <= 2";
    private static final String ORDER_BY_ID = "ID DESC";

    @Autowired
    public ConnectorServiceImpl(ConnectorFactoryRegistry connectorFactoryRegistry, DirectoryAdapter directoryAdapter, ConnectorStorageManager connectorStorageManager, @ComponentImport ActiveObjects activeObjects, CronExpressionValidator cronExpressionValidator, @ComponentImport SchedulerService schedulerService, @ComponentImport EventPublisher eventPublisher, HostProductProvider hostProductProvider, AtlasUserAdapter atlasUserAdapter, @ComponentImport ApplicationProperties applicationProperties, NotificationService notificationService, AttributeTransformationConfigValidator attributeTransformationConfigValidator, UserSyncAuditLogService userSyncAuditLogService, UserSyncXsrfCheckAvoider xsrfCheckAvoider) {
        this.connectorFactoryRegistry = connectorFactoryRegistry;
        this.ao = activeObjects;
        this.directoryAdapter = directoryAdapter;
        this.schedulerService = schedulerService;
        this.connectorStorageManager = connectorStorageManager;
        this.cronExpressionValidator = cronExpressionValidator;
        this.applicationPrefix = hostProductProvider.getApplicationPrefix();
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
        this.atlasUserAdapter = atlasUserAdapter;
        this.applicationProperties = applicationProperties;
        this.notificationService = notificationService;
        this.attributeTransformationConfigValidator = attributeTransformationConfigValidator;
        this.userSyncAuditLogService = userSyncAuditLogService;
        this.xsrfCheckAvoider = xsrfCheckAvoider;
    }

    public <C extends ConnectorConfiguration> Connector<C> create(@Nonnull Class<? extends Connector<C>> connectorClass) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException {
        return this.create(connectorClass.getCanonicalName());
    }

    private <K extends ConnectorConfiguration, C extends Connector<K>> ConnectorFactory<C, K> getFactory(@Nonnull String connectorClassName) throws ConnectorFactoryNotAvailableException {
        Optional factoryOptional = this.connectorFactoryRegistry.getConnectorFactory(connectorClassName);
        if (factoryOptional.isPresent()) {
            return factoryOptional.get();
        }
        throw new ConnectorFactoryNotAvailableException(connectorClassName);
    }

    @Override
    public <K extends ConnectorConfiguration, C extends Connector<K>> C createWithConfiguration(@Nonnull String configurationString) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException {
        return this.createWithConfiguration(JSONUtil.asJsonNode((String)configurationString));
    }

    @Override
    public <K extends ConnectorConfiguration, C extends Connector<K>> C createWithConfiguration(@Nonnull JsonNode configurationNode) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException {
        String uniqueId = configurationNode.get("uniqueId").asText();
        if (uniqueId == null) {
            throw new ConfigurationFailedException("Missing unique id");
        }
        if (this.connectorExists(uniqueId)) {
            throw new ConnectorUniqueIdExistsAlreadyException(uniqueId);
        }
        String connectorClassName = configurationNode.get("connectorClass").asText();
        ConnectorFactory<C, K> factory = this.getFactory(connectorClassName);
        long lastUpdated = System.currentTimeMillis();
        this.createConfigurationInDatabase(uniqueId, connectorClassName, configurationNode.toPrettyString(), lastUpdated);
        C connector = factory.create(configurationNode, false, lastUpdated);
        this.userSyncAuditLogService.connectorCreated((Connector<?>)connector);
        return connector;
    }

    private void createConfigurationInDatabase(@Nonnull String uniqueId, @Nonnull String connectorClassName, @Nonnull String configurationString, long lastUpdated) {
        this.ao.executeInTransaction(() -> {
            this.ao.create(AoConnectorConfiguration.class, new DBParam[]{new DBParam(CN_LAST_UPDATED, (Object)lastUpdated), new DBParam(CN_CLASS_NAME, (Object)connectorClassName), new DBParam(CN_CONFIG_VERSION, (Object)2), new DBParam(CN_CONFIGURATION_STRING, (Object)configurationString), new DBParam(CN_UNIQUE_ID, (Object)uniqueId), new DBParam(CN_NEW, (Object)true)});
            return null;
        });
    }

    @Override
    public <K extends ConnectorConfiguration, C extends Connector<K>> C create(@Nonnull String connectorClassName) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException {
        ConnectorFactory<C, K> factory = this.getFactory(connectorClassName);
        String uniqueId = this.createNewUniqueId();
        C connector = factory.create(uniqueId);
        String configurationString = this.createJson((ConnectorConfiguration)connector.getConfiguration());
        this.createConfigurationInDatabase(uniqueId, connectorClassName, configurationString, System.currentTimeMillis());
        this.userSyncAuditLogService.connectorCreated((Connector<?>)connector);
        return connector;
    }

    private String createJson(ConnectorConfiguration configuration) {
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)configuration);
        }
        catch (IOException e) {
            throw new ConnectorServiceRuntimeException(e);
        }
    }

    @Override
    public <K extends ConnectorConfiguration> ValidationResult validate(Connector<K> connector) {
        return this.validate((ConnectorConfiguration)connector.getConfiguration(), connector.getConfigurationClass());
    }

    private ValidationResult validate(@Nonnull ConnectorConfiguration connectorConfiguration, Class<?> configurationClass) {
        ConnectorFactory factory = this.connectorFactoryRegistry.getConnectorFactoryByConfiguration(configurationClass.getCanonicalName()).orElse(null);
        if (factory == null) {
            return ValidationResult.create((ValidationMessage)ValidationMessage.create((String)("No ConnectorFactory found for configuration" + connectorConfiguration.getClass().getCanonicalName())), null);
        }
        return factory.validate(connectorConfiguration);
    }

    @Override
    public void validate(@Nonnull ValidationResult validationResult, @Nonnull String connectorType, @Nonnull JsonNode configurationNode, @Nonnull String connectorUID) {
        Optional factoryOpt = this.connectorFactoryRegistry.getConnectorFactory(connectorType);
        if (factoryOpt.isPresent()) {
            try {
                ConnectorFactory factory = factoryOpt.get();
                ConnectorConfiguration config = (ConnectorConfiguration)objectMapper.treeToValue((TreeNode)configurationNode, factory.getConfigurationClass());
                validationResult.add("configuration", this.validate(config, factory.getConfigurationClass()));
            }
            catch (JsonProcessingException e) {
                validationResult.addError("Parsing configuration failed: " + e.getMessage());
            }
        } else {
            validationResult.addError("Could not load factory for " + connectorType);
        }
    }

    @Override
    public ValidationResult validateIdentifierForSingleSync(@Nonnull IdentifierForSingleUserSync identifier, @Nonnull String connectorUID) {
        ValidationResult result = ValidationResult.create();
        try {
            this.getConnectorByUniqueId(connectorUID).getConnector().checkIdentifierForSingleUserSync(identifier, result);
        }
        catch (ConfigurationFailedException | ConnectorFactoryNotAvailableException | ConnectorNotFoundException e) {
            logger.error("The connector associated with unique id={} could not be loaded", (Object)connectorUID);
        }
        return result;
    }

    @Override
    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> configure(@Nonnull String uniqueId, @Nonnull String configurationJson) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException {
        return this.configure(uniqueId, (K)JSONUtil.asJsonNode((String)configurationJson));
    }

    @Override
    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> configure(@Nonnull String uniqueId, @Nonnull JsonNode configurationJsonNode) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException {
        String classNameFromConfig;
        String oldConfiguration = this.loadLastStoredConfiguration(uniqueId);
        String connectorClassName = this.getConnectorClassNameForUniqueId(uniqueId);
        if (connectorClassName == null) {
            throw new ConnectorNotFoundException(uniqueId);
        }
        JsonNode classNameNode = configurationJsonNode.get("connectorClass");
        if (classNameNode != null && !Objects.equals(classNameFromConfig = classNameNode.textValue(), connectorClassName)) {
            throw new ConfigurationFailedException("Cannot configure connector " + connectorClassName + " with configuration of type " + classNameFromConfig);
        }
        ConnectorFactory factory = this.connectorFactoryRegistry.getConnectorFactory(connectorClassName).orElseThrow(() -> new ConnectorFactoryNotAvailableException(connectorClassName));
        long lastUpdated = System.currentTimeMillis();
        Object connector = factory.create(configurationJsonNode, false, lastUpdated);
        K configuration = connector.getConfiguration();
        ValidationResult validationResult = this.validate((Connector<K>)connector);
        if (validationResult.isValid()) {
            boolean changed;
            if (!connector.isSelectableDirectory()) {
                logger.debug("Checking the directory for Connector {}", (Object)connector.getUniqueId());
                try {
                    DirectoryIdAndName directoryIdAndName = this.prepareDirectory(configuration.getDirectoryId(), connector.getName(), connector.getUniqueId());
                    if (directoryIdAndName.getId() != configuration.getDirectoryId()) {
                        logger.debug("Directory ID for {} is changed from {} to {}", new Object[]{configuration.getName(), configuration.getDirectoryId(), directoryIdAndName.getId()});
                        configuration.setDirectoryId(directoryIdAndName.getId());
                    }
                }
                catch (InvalidOperationException e) {
                    throw new ConfigurationFailedException("Preparing the directory failed", e);
                }
            }
            if (changed = this.saveConfiguration((ConnectorConfiguration)configuration, lastUpdated)) {
                this.toggleSchedule((Connector<?>)connector);
                this.userSyncAuditLogService.connectorUpdated(uniqueId, oldConfiguration, this.loadLastStoredConfiguration(uniqueId));
            }
            return this.getConnectorByUniqueId(uniqueId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Connector {} is not valid: {}", (Object)connector.getUniqueId(), (Object)JSONUtil.asJson((Object)validationResult));
        }
        return new ConnectorAndValidationResult(connector, validationResult);
    }

    @Override
    public DirectoryIdAndName prepareDirectory(long directoryId, @Nonnull String directoryName, @Nonnull String uniqueId) throws InvalidOperationException {
        logger.debug("Preparing directory {} with name {}", (Object)directoryId, (Object)directoryName);
        String uniqueDirectoryName = this.makeDirectoryNameUnique(directoryName);
        AtlasUserDirectory directory = this.directoryAdapter.get(directoryId);
        if (directory == null) {
            try {
                AtlasUserDirectory toCreate = AtlasUserDirectory.builder().name(uniqueDirectoryName).description(uniqueDirectoryName).with("CREATED_BY_CONNECTOR", uniqueId).build();
                AtlasUserDirectory created = this.directoryAdapter.create(toCreate);
                logger.debug("Created new directory {} with name {}", (Object)created.getId(), (Object)created.getName());
                return new DirectoryIdAndName(created.getId(), created.getName());
            }
            catch (DirectoryNameExistsAlreadyException e) {
                throw new ConnectorServiceRuntimeException(e);
            }
        }
        return new DirectoryIdAndName(directory.getId(), directory.getName());
    }

    @Override
    public String makeDirectoryNameUnique(@Nonnull String directoryName) {
        String currentDirectoryName = directoryName;
        while (!this.directoryAdapter.get(currentDirectoryName).isEmpty()) {
            currentDirectoryName = ConnectorServiceImpl.incrementName(currentDirectoryName);
        }
        return currentDirectoryName;
    }

    public static String incrementName(@Nonnull String name) {
        Pattern pattern = Pattern.compile("(.*#)(\\d*)$");
        Matcher matcher = pattern.matcher(name);
        if (!matcher.matches()) {
            return name + "#1";
        }
        return matcher.replaceAll("$1" + (Integer.parseInt(matcher.group(2)) + 1));
    }

    @Override
    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> configure(@Nonnull String uniqueId, @Nonnull K configuration) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException {
        try {
            return this.configure(uniqueId, (K)((Object)this.configToString(configuration)));
        }
        catch (IOException e) {
            throw new ConnectorServiceRuntimeException(e);
        }
    }

    @Override
    public boolean delete(@Nonnull String uniqueId) {
        this.xsrfCheckAvoider.avoidXsrfCheck();
        boolean removed = (Boolean)this.ao.executeInTransaction(() -> {
            block10: {
                block11: {
                    List<AoConnectorConfiguration> configs = this.loadAllConfigs(uniqueId);
                    if (configs.isEmpty()) break block11;
                    try {
                        Object connector = this.getConnectorByUniqueId(uniqueId).getConnector();
                        long directoryId = connector.getConfiguration().getDirectoryId();
                        this.renameDirectoryIfLastConnectorIsDeleted(directoryId, uniqueId);
                        this.schedulerService.unscheduleJob(JobId.of((String)(JOB_ID_BASE + uniqueId)));
                    }
                    catch (ConnectorFactoryNotAvailableException e) {
                        logger.debug("ConnectorFactory is not available, just deleting the configs");
                        for (AoConnectorConfiguration cfg : configs) {
                            this.ao.delete(new RawEntity[]{cfg});
                        }
                    }
                    for (AoConnectorConfiguration cfg : configs) {
                        this.ao.delete(new RawEntity[]{cfg});
                    }
                    break block10;
                    break block10;
                    catch (Exception e2) {
                        logger.warn("loading connector " + uniqueId + " failed, just deleting the configs", (Throwable)e2);
                        for (AoConnectorConfiguration cfg : configs) {
                            this.ao.delete(new RawEntity[]{cfg});
                        }
                        {
                            break block10;
                            catch (Throwable throwable) {
                                for (AoConnectorConfiguration cfg : configs) {
                                    this.ao.delete(new RawEntity[]{cfg});
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                logger.warn("No config found for {}", (Object)uniqueId);
                return false;
            }
            this.connectorStorageManager.removeAll(uniqueId);
            return true;
        });
        if (removed) {
            this.userSyncAuditLogService.connectorRemoved(uniqueId);
        }
        return removed;
    }

    @Override
    @Nonnull
    public <C extends Connector<K>, K extends ConnectorConfiguration> Collection<ConnectorAndValidationResult<C, K>> getConnectors() {
        return (Collection)this.ao.executeInTransaction(() -> {
            List<AoConnectorConfiguration> aoConfigs = this.loadActualAoConnectorConfigs();
            ArrayList ret = new ArrayList(aoConfigs.size());
            for (AoConnectorConfiguration cfg : aoConfigs) {
                try {
                    ConnectorAndValidationResult connectorAndValidationResult = this.loadConnector(cfg, false);
                    ret.add(connectorAndValidationResult);
                }
                catch (ConnectorFactoryNotAvailableException e) {
                    logger.warn("Loading UnavailableConnector, connector factory for {}:{} is not available", (Object)cfg.getUniqueId(), (Object)cfg.getClassName());
                    UnavailableConnectorConfiguration unavailableConnectorConfiguration = new UnavailableConnectorConfiguration(cfg.getUniqueId());
                    try {
                        UnavailableConnector unavailableConnector = new UnavailableConnector(this, this.atlasUserAdapter, unavailableConnectorConfiguration);
                        ret.add(new ConnectorAndValidationResult(unavailableConnector, ValidationResult.create()));
                    }
                    catch (ConfigurationFailedException e2) {
                        logger.error("ConfigurationFailedException while creating UnavailableConnector!", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.warn("Loading connector {} failed", (Object)cfg.getId(), (Object)e);
                }
            }
            return ret;
        });
    }

    private void renameDirectoryIfLastConnectorIsDeleted(long directoryId, @Nonnull String connectorUIDtoBeDeleted) throws DirectoryNotFoundException, InvalidOperationException, DirectoryNameExistsAlreadyException {
        boolean otherConnectorsUseThisDirectory = this.getConnectors().stream().anyMatch(cvr -> {
            Object cfg = cvr.getConnector().getConfiguration();
            return cfg.getDirectoryId() == directoryId && !cfg.getUniqueId().equals(connectorUIDtoBeDeleted);
        });
        if (!otherConnectorsUseThisDirectory) {
            AtlasUserDirectory directoryEntity = this.directoryAdapter.get(directoryId);
            List directoryNames = this.directoryAdapter.getDirectories().stream().map(AtlasUserDirectory::getName).collect(Collectors.toList());
            if (directoryEntity != null && directoryEntity.isAtlasUser()) {
                String directoryName = directoryEntity.getName();
                String newName = directoryName + " DELETED";
                int i = 1;
                while (directoryNames.contains(newName)) {
                    newName = directoryName + " DELETED" + i++;
                }
                this.directoryAdapter.update(AtlasUserDirectory.builder((AtlasUserDirectory)directoryEntity).name(newName).build());
            }
        } else {
            logger.debug("Not renaming directory {}, there is more than one connector using this directory.", (Object)directoryId);
        }
    }

    private List<AoConnectorConfiguration> loadActualAoConnectorConfigs() {
        AoConnectorConfiguration[] allConfigs = (AoConnectorConfiguration[])this.ao.find(AoConnectorConfiguration.class, Query.select().where("CONFIG_VERSION <= ?", new Object[]{2}).order("UNIQUE_ID, ID DESC"));
        HashSet<String> seenUIDs = new HashSet<String>();
        ArrayList<AoConnectorConfiguration> filtered = new ArrayList<AoConnectorConfiguration>();
        for (AoConnectorConfiguration current : allConfigs) {
            if (seenUIDs.contains(current.getUniqueId())) continue;
            seenUIDs.add(current.getUniqueId());
            filtered.add(current);
        }
        return filtered;
    }

    @Nonnull
    private List<AoConnectorConfiguration> loadAllConfigs(@Nonnull String uniqueId) {
        AoConnectorConfiguration[] cfgArray = (AoConnectorConfiguration[])this.ao.find(AoConnectorConfiguration.class, WHERE_UNIQUE_ID_AND_CONFIG_VERSION, new Object[]{uniqueId});
        if (cfgArray == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(cfgArray);
    }

    @Nullable
    private AoConnectorConfiguration loadLastConfig(@Nonnull String uniqueId) {
        AoConnectorConfiguration[] cfgArray = (AoConnectorConfiguration[])this.ao.find(AoConnectorConfiguration.class, Query.select().where(WHERE_UNIQUE_ID_AND_CONFIG_VERSION, new Object[]{uniqueId}).order(ORDER_BY_ID).limit(1));
        if (cfgArray == null || cfgArray.length == 0) {
            return null;
        }
        return cfgArray[0];
    }

    private String getConnectorClassNameForUniqueId(@Nonnull String uniqueId) {
        return (String)this.ao.executeInTransaction(() -> {
            AoConnectorConfiguration cfg = this.loadLastConfig(uniqueId);
            if (cfg != null) {
                return cfg.getClassName();
            }
            return null;
        });
    }

    @Nullable
    private String loadLastStoredConfiguration(@Nonnull String uniqueId) {
        AoConnectorConfiguration[] elements = (AoConnectorConfiguration[])this.ao.executeInTransaction(() -> (AoConnectorConfiguration[])this.ao.find(AoConnectorConfiguration.class, Query.select().where(WHERE_UNIQUE_ID_AND_CONFIG_VERSION, new Object[]{uniqueId}).order(ORDER_BY_ID).limit(1)));
        if (elements == null || elements.length == 0) {
            return null;
        }
        AoConnectorConfiguration aoConnectorConfiguration = elements[0];
        return aoConnectorConfiguration.getConfigurationString();
    }

    @Nonnull
    private <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> getConnectorByUniqueId(@Nonnull String uniqueId, boolean alwaysReload) throws ConnectorNotFoundException, ConnectorUniqueIdNotUniqueException, ConnectorFactoryNotAvailableException, ConfigurationFailedException {
        AoConnectorConfiguration[] elements = (AoConnectorConfiguration[])this.ao.executeInTransaction(() -> (AoConnectorConfiguration[])this.ao.find(AoConnectorConfiguration.class, Query.select().where(WHERE_UNIQUE_ID_AND_CONFIG_VERSION, new Object[]{uniqueId}).order(ORDER_BY_ID).limit(1)));
        if (elements == null || elements.length == 0) {
            throw new ConnectorNotFoundException(uniqueId);
        }
        return this.loadConnector(elements[0], alwaysReload);
    }

    @Override
    public boolean connectorExists(@Nullable String uniqueId) {
        if (uniqueId == null) {
            return false;
        }
        AoConnectorConfiguration[] elements = (AoConnectorConfiguration[])this.ao.executeInTransaction(() -> (AoConnectorConfiguration[])this.ao.find(AoConnectorConfiguration.class, Query.select().where(WHERE_UNIQUE_ID_AND_CONFIG_VERSION, new Object[]{uniqueId}).order(ORDER_BY_ID).limit(1)));
        return elements != null && elements.length > 0;
    }

    @Override
    @Nonnull
    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> getConnectorByUniqueId(@Nonnull String uniqueId) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException {
        return this.getConnectorByUniqueId(uniqueId, false);
    }

    @Override
    @NotNull
    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> reloadConnectorIntoCache(@Nonnull String uniqueId) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException {
        return this.getConnectorByUniqueId(uniqueId, true);
    }

    private boolean saveConfiguration(@Nonnull ConnectorConfiguration connectorConfiguration, long lastUpdated) {
        return (Boolean)this.ao.executeInTransaction(() -> {
            AoConnectorConfiguration[] aoConfigs = (AoConnectorConfiguration[])this.ao.find(AoConnectorConfiguration.class, Query.select().where(WHERE_UNIQUE_ID_AND_CONFIG_VERSION, new Object[]{connectorConfiguration.getUniqueId()}).order(ORDER_BY_ID).limit(1));
            AoConnectorConfiguration aoConnectorConfiguration = null;
            if (aoConfigs != null && aoConfigs.length > 0) {
                aoConnectorConfiguration = aoConfigs[0];
            }
            try {
                String configurationString = this.configToString(connectorConfiguration);
                if (aoConnectorConfiguration != null && ConnectorServiceImpl.checkForEquality(configurationString, aoConnectorConfiguration.getConfigurationString())) {
                    logger.debug("Configuration is not changed, no need to save.");
                    return false;
                }
                this.connectorCache.remove(connectorConfiguration.getUniqueId());
                String sanitizedConfigurationString = this.configToString(connectorConfiguration.sanitize());
                this.ao.create(AoConnectorConfiguration.class, new DBParam[]{new DBParam(CN_LAST_UPDATED, (Object)lastUpdated), new DBParam(CN_CLASS_NAME, (Object)connectorConfiguration.tellConnectorClass().getName()), new DBParam(CN_CONFIGURATION_STRING, (Object)configurationString), new DBParam(CN_SANITIZED_CONFIGURATION_STRING, (Object)sanitizedConfigurationString), new DBParam(CN_NEW, (Object)false), new DBParam(CN_UNIQUE_ID, (Object)connectorConfiguration.getUniqueId()), new DBParam(CN_CONFIG_VERSION, (Object)2), new DBParam(CN_NAME, (Object)connectorConfiguration.getName())});
                if (aoConnectorConfiguration != null && aoConnectorConfiguration.isNew()) {
                    logger.debug("Existing connector configuration has the new-flag set, deleting it");
                    this.ao.delete(new RawEntity[]{aoConnectorConfiguration});
                }
                return true;
            }
            catch (IOException e) {
                throw new ConnectorServiceRuntimeException("Serializing configuration failed", e);
            }
        });
    }

    @Override
    public void toggleSchedule(@Nonnull Connector<?> connector) {
        CronScheduleInfo cronScheduleInfo;
        Object connectorConfiguration = connector.getConfiguration();
        boolean valid = this.validate(connector).isValid();
        boolean doSchedule = connector.getConfiguration().isScheduled();
        JobId jobId = JobId.of((String)(JOB_ID_BASE + connector.getUniqueId()));
        String cronExpression = connectorConfiguration.getCronExpression();
        if (!(valid && doSchedule && this.cronExpressionValidator.isValid(cronExpression))) {
            JobDetails jobDetails = this.schedulerService.getJobDetails(jobId);
            if (jobDetails != null) {
                logger.debug("Unscheduling sync job {}", (Object)jobId);
                this.schedulerService.unscheduleJob(jobId);
            }
            return;
        }
        JobDetails jobDetails = this.schedulerService.getJobDetails(jobId);
        if (jobDetails != null && (cronScheduleInfo = jobDetails.getSchedule().getCronScheduleInfo()) != null && Objects.equals(cronScheduleInfo.getCronExpression(), connectorConfiguration.getCronExpression())) {
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("CONNECTOR_UID", connector.getUniqueId());
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)SyncJobRunner.JOB_RUNNER_KEY).withSchedule(Schedule.forCronExpression((String)cronExpression)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters(parameters);
        try {
            logger.info("Scheduling sync job {} with cron expression {}", (Object)jobId, (Object)connector.getConfiguration().getCronExpression());
            this.schedulerService.scheduleJob(jobId, jobConfig);
        }
        catch (SchedulerServiceException e) {
            logger.error("Scheduling sync job {} failed!", (Object)jobId, (Object)e);
        }
    }

    @Override
    public String createNewUniqueId() {
        return UUID.randomUUID().toString();
    }

    public void copyConfigsFromOldTable() {
        this.ao.executeInTransaction(() -> {
            LegacyAoConnectorConfiguration[] legacyConfigs = (LegacyAoConnectorConfiguration[])this.ao.find(LegacyAoConnectorConfiguration.class);
            if (legacyConfigs == null || legacyConfigs.length == 0) {
                logger.debug("Found no legacy connector configurations");
                return null;
            }
            for (LegacyAoConnectorConfiguration legacyConfig : legacyConfigs) {
                if (legacyConfig.getMigToUID() != null && !legacyConfig.getMigToUID().isEmpty()) {
                    logger.debug("Connector {} has been copied already", (Object)legacyConfig.getName());
                    continue;
                }
                String uniqueId = this.createNewUniqueId();
                String configJson = legacyConfig.getConfigurationString();
                String configJsonWithUniqueId = UserSyncUtils.addUniqueId(configJson, uniqueId);
                String name = legacyConfig.getName();
                this.ao.create(AoConnectorConfiguration.class, new DBParam[]{new DBParam(CN_CLASS_NAME, (Object)legacyConfig.getClassName()), new DBParam(CN_CONFIGURATION_STRING, (Object)configJsonWithUniqueId), new DBParam(CN_LAST_UPDATED, (Object)legacyConfig.getLastUpdated()), new DBParam(CN_NAME, (Object)name), new DBParam(CN_NEW, (Object)legacyConfig.isNew()), new DBParam(CN_SANITIZED_CONFIGURATION_STRING, (Object)legacyConfig.getSanitizedConfigurationString()), new DBParam(CN_CONFIG_VERSION, (Object)0), new DBParam(CN_UNIQUE_ID, (Object)uniqueId)});
                legacyConfig.setMigToUID(uniqueId);
                legacyConfig.save();
                logger.warn("Copied connector {} and added unique id {}", (Object)name, (Object)uniqueId);
                AoSyncStatus[] syncStatuses = (AoSyncStatus[])this.ao.find(AoSyncStatus.class, Query.select().where("CONNECTOR_ID = ?", new Object[]{legacyConfig.getId()}));
                if (syncStatuses != null && syncStatuses.length > 0) {
                    for (AoSyncStatus currentSyncStatus : syncStatuses) {
                        currentSyncStatus.setConnUID(uniqueId);
                        currentSyncStatus.save();
                    }
                    logger.warn("Connector {}: Updated {} sync status entries", (Object)uniqueId, (Object)syncStatuses.length);
                }
                Map<String, String> legacyStorageValues = this.connectorStorageManager.getAllLegacy(legacyConfig.getId());
                for (Map.Entry<String, String> entry : legacyStorageValues.entrySet()) {
                    this.connectorStorageManager.set(uniqueId, entry.getKey(), entry.getValue());
                    logger.warn("Connector {}: Copied data with key {} ", (Object)uniqueId, (Object)entry.getKey());
                }
            }
            return null;
        });
    }

    public void removeOldJobs() {
        logger.debug("Checking for old schedululed jobs...");
        for (JobDetails jobDetails : this.schedulerService.getJobsByJobRunnerKey(SyncJobRunner.JOB_RUNNER_KEY)) {
            JobId jobId = jobDetails.getJobId();
            if (jobId.toString().startsWith(OLD_JOB_ID_BASE)) {
                logger.warn("Unscheduling old job {}", (Object)jobId);
                this.schedulerService.unscheduleJob(jobId);
                continue;
            }
            logger.debug("Keeping job {}", (Object)jobId);
        }
    }

    @Override
    public void initUserSyncConnectors() {
        if (this.initialized.compareAndSet(false, true)) {
            this.copyConfigsFromOldTable();
            this.removeOldJobs();
            ArrayList<JobId> jobIdsFromConnectors = new ArrayList<JobId>();
            logger.debug("Checking status of scheduled jobs");
            for (ConnectorAndValidationResult connectorAndValidationResult : this.getConnectors()) {
                Object connector = connectorAndValidationResult.getConnector();
                try {
                    if (!(connector instanceof UnavailableConnector) && this.saveConfiguration((ConnectorConfiguration)connector.getConfiguration(), System.currentTimeMillis())) {
                        logger.debug("Connector {} with unique id {} was changed during load and the changes are saved now.", (Object)connector.getUniqueId(), (Object)connector.getUniqueId());
                    }
                }
                catch (ConnectorUniqueIdNotUniqueException e) {
                    throw new ConnectorServiceRuntimeException("Unique Id is not unique, that should never happen", e);
                }
                boolean isValid = connectorAndValidationResult.getValidationResult().isValid();
                boolean isScheduled = connector.getConfiguration().isScheduled();
                String cronExpression = connector.getConfiguration().getCronExpression();
                if (!isValid || !isScheduled || !this.cronExpressionValidator.isValid(cronExpression)) continue;
                JobId jobId = JobId.of((String)(JOB_ID_BASE + connector.getUniqueId()));
                jobIdsFromConnectors.add(jobId);
                JobDetails jobDetails = this.schedulerService.getJobDetails(jobId);
                if (jobDetails != null) continue;
                logger.warn("Scheduled sync {} from connector {} was not scheduled.", (Object)jobId, (Object)connector.getUniqueId());
                this.toggleSchedule((Connector<?>)connector);
            }
            for (JobDetails jobDetails : this.schedulerService.getJobsByJobRunnerKey(SyncJobRunner.JOB_RUNNER_KEY)) {
                JobId jobId = jobDetails.getJobId();
                if (!jobIdsFromConnectors.contains(jobId)) {
                    logger.warn("Unscheduling job {}, there is no corresponding Connector", (Object)jobId);
                    this.schedulerService.unscheduleJob(jobId);
                    continue;
                }
                logger.debug("Job {} seems to belong to a scheduled connector, keeping it.", (Object)jobId);
            }
        } else {
            logger.debug("Already initialized. This can happen, if an app called this method from the outside and the plugin enabled event came this.");
        }
    }

    @EventListener
    public void runAfterEnabled(@Nonnull PluginEnabledEvent pluginEnabledEvent) {
        if (Objects.equals(UserSyncPluginProperties.get("pluginkey"), pluginEnabledEvent.getPlugin().getKey())) {
            this.eventPublisher.unregister((Object)this);
            this.initUserSyncConnectors();
        }
    }

    @Override
    public boolean directoryExists(long id) {
        return this.directoryAdapter.exists(id);
    }

    @Override
    public long createDirectory(@Nonnull String name, @Nonnull String description) throws DirectoryNameExistsAlreadyException {
        AtlasUserDirectory directoryEntity = AtlasUserDirectory.builder().name(name).description(description).build();
        AtlasUserDirectory created = this.directoryAdapter.create(directoryEntity);
        return created.getId();
    }

    @Override
    public void renameDirectory(long id, @Nonnull String name, @Nonnull String description) throws DirectoryNotFoundException, DirectoryNameExistsAlreadyException, InvalidOperationException {
        AtlasUserDirectory directory = this.directoryAdapter.get(id);
        boolean changed = false;
        AtlasUserDirectoryBuilder directoryBuilder = AtlasUserDirectory.builder((AtlasUserDirectory)directory);
        if (!Objects.equals(name, directory.getName())) {
            directoryBuilder.name(name);
            changed = true;
        }
        if (!Objects.equals(description, directory.getDescription())) {
            directoryBuilder.description(description);
            changed = true;
        }
        if (changed) {
            this.directoryAdapter.update(directoryBuilder.build());
        }
    }

    @Override
    public List<AtlasUserDirectory> getAllDirectories() {
        return this.directoryAdapter.getDirectories();
    }

    @Override
    public long getFirstWritableDirectoryId() {
        return this.directoryAdapter.getFirstWritableDirectoryId();
    }

    @Override
    public List<AtlasUserDirectory> getOrphanedDirectories() {
        List<Long> usedIds = this.getUsedDirectoryIds();
        List directories = this.directoryAdapter.getAtlasUserDirectories();
        List<AtlasUserDirectory> filteredDirectories = directories.stream().filter(entity -> !usedIds.contains(entity.getId())).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            logger.debug("Unused directories: {}", (Object)filteredDirectories.stream().map(dir -> String.valueOf(dir.getId())).collect(Collectors.joining()));
        }
        return filteredDirectories;
    }

    @Override
    public void deleteOrphanedDirectory(long id) throws InvalidOperationException, DirectoryNotFoundException, AtlasUserOperationFailedException {
        List<AtlasUserDirectory> orphanedDirectories = this.getOrphanedDirectories();
        for (AtlasUserDirectory directoryEntity : orphanedDirectories) {
            if (directoryEntity.getId() != id) continue;
            this.directoryAdapter.delete(id);
            return;
        }
        throw new InvalidOperationException("Directory id " + id + " is no orphaned AtlasUser-directory");
    }

    @Override
    public List<LabelValue<String, String>> getAvailableConnectorNamesAndUniqueIds() {
        logger.debug("Returning available connectors which can sync single users");
        return this.getConnectors().stream().filter(con -> con.getValidationResult().isValid()).filter(con -> con.getConnector().isCanSyncSingleUser()).map(c -> new LabelValue<String, String>(c.getConnector().getName(), c.getUniqueId())).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public String getConnectorUIDforLegacyId(int connectorId) {
        return (String)this.ao.executeInTransaction(() -> {
            LegacyAoConnectorConfiguration legacyConfig = (LegacyAoConnectorConfiguration)this.ao.get(LegacyAoConnectorConfiguration.class, (Object)connectorId);
            if (legacyConfig == null) {
                return null;
            }
            String uid = legacyConfig.getMigToUID();
            if (uid == null || uid.isEmpty()) {
                return null;
            }
            return uid;
        });
    }

    @Override
    public String getApplicationPrefix() {
        return this.applicationPrefix;
    }

    private String configToString(@Nonnull ConnectorConfiguration config) throws IOException {
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)config);
    }

    private <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> loadConnector(@Nonnull AoConnectorConfiguration aoConnectorConfiguration, boolean alwaysReload) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException {
        Optional factoryOpt = this.connectorFactoryRegistry.getConnectorFactory(aoConnectorConfiguration.getClassName());
        if (factoryOpt.isPresent()) {
            Object connector;
            ConnectorFactory factory = factoryOpt.get();
            long lastUpdated = aoConnectorConfiguration.getLastUpdated();
            String uniqueId = aoConnectorConfiguration.getUniqueId();
            ConnectorAndValidationResult<?, ?> connectorAndValidationResult = this.connectorCache.get(uniqueId);
            if (connectorAndValidationResult != null) {
                if (alwaysReload) {
                    logger.debug("alwaysReload is true, reloading connector");
                } else {
                    if (connectorAndValidationResult.getLastUpdated() == lastUpdated) {
                        logger.trace("Connector {}: {} is up to date, no need to reload", (Object)connectorAndValidationResult.getUniqueId(), (Object)connectorAndValidationResult.getConnector().getName());
                        return connectorAndValidationResult;
                    }
                    logger.debug("Connector {}: {} is NOT up to date, reloading", (Object)connectorAndValidationResult.getUniqueId(), (Object)connectorAndValidationResult.getConnector().getName());
                }
            } else {
                logger.debug("Connector {} is not loaded yet.", (Object)uniqueId);
            }
            String connectorConfiguration = aoConnectorConfiguration.getConfigurationString();
            if (connectorConfiguration == null) {
                logger.warn("No configuration stored in AoConnectorConfiguration for id {}, creating an empty config", (Object)uniqueId);
                connector = factory.create(aoConnectorConfiguration.getUniqueId());
            } else {
                connector = factory.create(connectorConfiguration, aoConnectorConfiguration.isNew(), lastUpdated);
            }
            ValidationResult validationResult = this.validate((Connector<K>)connector);
            ConnectorAndValidationResult ret = new ConnectorAndValidationResult(connector, validationResult);
            this.connectorCache.put(ret.getUniqueId(), ret);
            return ret;
        }
        throw new ConnectorFactoryNotAvailableException(aoConnectorConfiguration.getClassName());
    }

    private List<Long> getUsedDirectoryIds() {
        ArrayList<Long> ret = new ArrayList<Long>();
        for (ConnectorAndValidationResult connectorAndValidationResult : this.getConnectors()) {
            ret.add(connectorAndValidationResult.getConnector().getConfiguration().getDirectoryId());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Used directories: {}", (Object)ret.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        return ret;
    }

    @Override
    public ConnectorStorageManager getConnectorStorageManager() {
        return this.connectorStorageManager;
    }

    @Override
    public String getBaseUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
    }

    public static boolean checkForEquality(@Nonnull String config1String, @Nonnull String config2String) throws IOException {
        JsonNode node1 = objectMapper.readTree(config2String);
        JsonNode node2 = objectMapper.readTree(config1String);
        return node1.equals((Object)node2);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.get();
    }

    @Override
    public AtlasUserAdapter getAtlasUserAdapter() {
        return this.atlasUserAdapter;
    }

    @Override
    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    @Override
    public ConnectorFactoryRegistry getConnectorFactoryRegistry() {
        return this.connectorFactoryRegistry;
    }

    @Override
    public AttributeTransformationConfigValidator getAttributeTransformationConfigValidator() {
        return this.attributeTransformationConfigValidator;
    }

    @Override
    @Nonnull
    public Map<String, String> fetchRequiredConnectorGroups(@Nonnull String connectorId, @Nonnull RequiredGroupCheckerHolder requiredGroupCheckerHolder) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException, ConnectorNotFoundException, GeneralSyncException {
        ConnectorAndValidationResult connectorAndValidationResult = this.getConnectorByUniqueId(connectorId);
        Object connector = connectorAndValidationResult.getConnector();
        if (!this.validate((Connector)connector).isValid()) {
            throw new UserSyncRuntimeException("Invalid connector, cannot preview required connector groups.");
        }
        if (!requiredGroupCheckerHolder.hasRequiredGroupsConfigured()) {
            throw new UserSyncRuntimeException("No required group checkers provided, please check your config");
        }
        Set<ConnectorGroup> foundGroups = connector.fetchRequiredConnectorGroups(requiredGroupCheckerHolder, SyncStatusFacade.nullFacade());
        return foundGroups.stream().map(group -> new AbstractMap.SimpleEntry<String, String>(group.getId(), group.getName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private static class ConnectorServiceRuntimeException
    extends RuntimeException {
        ConnectorServiceRuntimeException(String message, Throwable cause) {
            super(message, cause);
        }

        ConnectorServiceRuntimeException(Throwable cause) {
            super(cause);
        }
    }
}

