/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/reset/entityid")
@Component
public class ResetEntityIdRestResource {
    private final RunningConfiguration pluginConfiguration;
    private final PrivilegeChecker privilegeChecker;

    @Autowired
    public ResetEntityIdRestResource(RunningConfiguration pluginConfiguration, PrivilegeChecker privilegeChecker) {
        this.pluginConfiguration = pluginConfiguration;
        this.privilegeChecker = privilegeChecker;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resetEntityId(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        String currentEntityId = this.pluginConfiguration.getEntityId();
        String defaultEntityId = this.pluginConfiguration.getDefaultEntityId();
        if (Objects.equals(currentEntityId, defaultEntityId)) {
            return Response.notModified().cacheControl(Utils.ccNoCache).build();
        }
        ConfigurationData configurationData = this.pluginConfiguration.getConfigurationData();
        configurationData.entityId = defaultEntityId;
        if (this.pluginConfiguration.update(configurationData)) {
            return Response.noContent().cacheControl(Utils.ccNoCache).build();
        }
        return Response.serverError().entity(Utils.createMessageForJson("Updating configuration failed, check log for details")).cacheControl(Utils.ccNoCache).build();
    }
}

