/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira;

import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.SingleLogoutService;
import com.resolution.atlasplugins.samlsso.SingleLogoutServiceException;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.jira.userauth.JiraServiceDeskLogoutHandler;
import com.resolution.atlasplugins.samlsso.servlet.ServletUtil;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.license.LicenseStatus;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.util.boundedregex.BoundedRegex;
import de.resolution.commons.util.boundedregex.TimeoutExceededException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
public class RedirectServiceDeskLoginToSsoFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(RedirectServiceDeskLoginToSsoFilter.class);
    private static final String ALREADY_FILTERED = RedirectServiceDeskLoginToSsoFilter.class.getName() + "_already_filtered";
    private static final String SERVICE_DESK_PREFIX = "/servicedesk/customer/";
    private static final String DESTINATION = "destination";
    private static final String UTF_8 = "UTF-8";
    private static final String LOGOUT = "logout";
    private final SamlSsoService samlSsoService;
    private final RunningConfiguration pluginConfiguration;
    private final LicenseChecker licenseChecker;
    private final SingleLogoutService singleLogoutService;
    private final JiraServiceDeskLogoutHandler logoutHandler;
    private final AuthenticationTrackerRepository trackerRepository;
    private final TemplateRenderer templateRenderer;
    private static final Pattern PORTAL_PATTERN = Pattern.compile("/servicedesk/customer/portal/(\\d+)/user/login");

    @Autowired
    public RedirectServiceDeskLoginToSsoFilter(SamlSsoService samlSsoService, LicenseChecker licenseChecker, RunningConfiguration pluginConfiguration, SingleLogoutService singleLogoutService, AuthenticationTrackerRepository trackerRepository, @ComponentImport TemplateRenderer templateRenderer) {
        this.samlSsoService = samlSsoService;
        this.licenseChecker = licenseChecker;
        this.pluginConfiguration = pluginConfiguration;
        this.singleLogoutService = singleLogoutService;
        this.trackerRepository = trackerRepository;
        this.templateRenderer = templateRenderer;
        this.logoutHandler = new JiraServiceDeskLogoutHandler(samlSsoService, pluginConfiguration);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        LicenseStatus licenseStatus;
        if (req.getAttribute(ALREADY_FILTERED) != null) {
            chain.doFilter(req, res);
            return;
        }
        req.setAttribute(ALREADY_FILTERED, (Object)"yes");
        HttpServletRequest request = (HttpServletRequest)req;
        String requestURI = request.getRequestURI();
        if ((req.getParameter("nosso") != null || req.getParameter("auth_fallback") != null) && this.pluginConfiguration.isNossoEnabled()) {
            logger.debug("found parameter nosso or auth_fallback in request, not redirecting");
            chain.doFilter(req, res);
            return;
        }
        String referer = request.getHeader("referer");
        String loginUrlRegex = ".*/servicedesk/customer/.*/login.*";
        try {
            if (referer != null && BoundedRegex.matches((String)loginUrlRegex, (String)referer, (long)this.samlSsoService.getRegexTimeout())) {
                logger.debug("Referer {} matches {}, not redirecting", (Object)referer, (Object)loginUrlRegex);
                chain.doFilter(req, res);
                return;
            }
        }
        catch (TimeoutExceededException timeoutExceededException) {
            ServletUtil.sendErrorHelper((HttpServletResponse)res, null, null, this.samlSsoService.getRelativeNossoLoginPageUrl(), this.samlSsoService.getRelativeInitiateSSOUrl(), timeoutExceededException, this.pluginConfiguration.getErrorPageTemplate(), this.templateRenderer);
        }
        String string = req.getParameter(DESTINATION);
        if (string != null && string.contains("nosso") && this.pluginConfiguration.isNossoEnabled()) {
            logger.debug("found nosso in destination parameter, not redirecting");
            chain.doFilter(req, res);
            return;
        }
        logger.debug("Nosso is not present");
        String userAgentHeader = request.getHeader("user-agent");
        for (String string2 : this.pluginConfiguration.getNonSsoUserAgents()) {
            if (userAgentHeader == null || !userAgentHeader.contains(string2)) continue;
            logger.trace("Not redirecting, this is a non-sso user agent: {}", (Object)userAgentHeader);
            chain.doFilter(req, res);
            return;
        }
        String destination2 = req.getParameter(DESTINATION);
        if (destination2 != null && !destination2.isEmpty()) {
            for (String nonSsoDestination : this.pluginConfiguration.getNonSsoDestinations()) {
                if (!nonSsoDestination.contains(SERVICE_DESK_PREFIX)) continue;
                String nonSsoDestinationWithoutPrefix = nonSsoDestination.replace(SERVICE_DESK_PREFIX, "");
                try {
                    if (!BoundedRegex.matches((String)nonSsoDestinationWithoutPrefix, (String)destination2, (long)this.samlSsoService.getRegexTimeout())) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Not redirecting, this is a non-sso link url for Service Desk Portal: {}", (Object)StringUtil.sanitize((String)destination2));
                    }
                    chain.doFilter(req, res);
                    return;
                }
                catch (TimeoutExceededException e) {
                    ServletUtil.sendErrorHelper((HttpServletResponse)res, null, null, this.samlSsoService.getRelativeNossoLoginPageUrl(), this.samlSsoService.getRelativeInitiateSSOUrl(), e, this.pluginConfiguration.getErrorPageTemplate(), this.templateRenderer);
                }
            }
        }
        if (this.samlSsoService.isLoggedInUser(request)) {
            logger.debug("There is already a user logged in, nothing to do");
            chain.doFilter(req, res);
            return;
        }
        if (!this.pluginConfiguration.getServiceDeskPortalsToRedirect().isEmpty()) {
            String string3 = RedirectServiceDeskLoginToSsoFilter.readPortalFromURI(requestURI);
            if (string3 == null) {
                logger.warn("Found no portal id in {}, not redirecting", (Object)requestURI);
                chain.doFilter(req, res);
                return;
            }
            if (!this.pluginConfiguration.getServiceDeskPortalsToRedirect().contains(string3)) {
                logger.debug("Portal {} is not listed as portal to redirect, not redirecting.", (Object)string3);
                chain.doFilter(req, res);
                return;
            }
        }
        if (!(licenseStatus = this.licenseChecker.checkLicense()).isLicensed()) {
            logger.error("Not redirecting, license is not valid: {}", (Object)licenseStatus.getMessage());
            chain.doFilter(req, res);
            return;
        }
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpRes = (HttpServletResponse)res;
        if (logger.isDebugEnabled()) {
            logger.debug("Request URL is {}", (Object)httpReq.getRequestURL().append("?").append(httpReq.getQueryString()));
        }
        if (!(this.pluginConfiguration.isRedirectServiceDeskLogin() || httpReq.getParameter(LOGOUT) != null && httpReq.getParameter(LOGOUT).equals("true"))) {
            logger.debug("ServiceDesk login redirection is disabled, not redirecting");
            chain.doFilter(req, res);
            return;
        }
        if (httpReq.getParameter(LOGOUT) != null && httpReq.getParameter(LOGOUT).equals("true")) {
            Cookie[] cookies = httpReq.getCookies();
            if (cookies == null) {
                logger.debug("logout parameter is present, but no cookies are set, assuming this is not a SAML logout, not redirecting");
                chain.doFilter(req, res);
                return;
            }
            Cookie sdCookie = null;
            String sdCookieValue = null;
            for (Cookie cookie : cookies) {
                if (cookie.getName().equals("JiraSDSamlssoLogin")) {
                    sdCookie = cookie;
                    sdCookieValue = sdCookie.getValue();
                    continue;
                }
                if (!cookie.getName().equals("JiraSDSamlssoLoginV2")) continue;
                sdCookie = cookie;
                if (sdCookie.getValue() == null) break;
                sdCookieValue = URLDecoder.decode(sdCookie.getValue(), UTF_8);
                break;
            }
            if (sdCookie != null) {
                logger.debug("SDCOOKIE is present, assuming this is a SAML logout");
                if (sdCookieValue != null) {
                    String[] splitted = sdCookieValue.split("###");
                    if (splitted.length != 4) {
                        if (logger.isErrorEnabled()) {
                            logger.error("Splitted cookie value {} has unexpected length {}, not performing single logout", (Object)StringUtil.sanitize((String)sdCookieValue), (Object)splitted.length);
                        }
                    } else {
                        String sessionIndex = splitted[0];
                        String nameId = splitted[1];
                        String idpId = splitted[2];
                        String trackerid = splitted[3];
                        AuthenticationTracker tracker = (AuthenticationTracker)this.trackerRepository.get(trackerid, true);
                        try {
                            this.singleLogoutService.doServiceManagementSingleLogout(httpReq, httpRes, this.logoutHandler, tracker, sessionIndex, nameId, idpId);
                            return;
                        }
                        catch (SingleLogoutServiceException e) {
                            ServletUtil.sendErrorHelper((HttpServletResponse)res, null, "Single Logout failed", this.samlSsoService.getRelativeNossoLoginPageUrl(), this.samlSsoService.getRelativeInitiateSSOUrl(), e, this.pluginConfiguration.getErrorPageTemplate(), this.templateRenderer);
                        }
                    }
                } else {
                    logger.error("Cookie value is null, not performing single logout");
                }
                Cookie clearCookieUnencoded = new Cookie("JiraSDSamlssoLogin", "");
                clearCookieUnencoded.setMaxAge(0);
                clearCookieUnencoded.setPath("/");
                clearCookieUnencoded.setHttpOnly(true);
                clearCookieUnencoded.setSecure(this.samlSsoService.isHttps());
                httpRes.addCookie(clearCookieUnencoded);
                Cookie clearCookie = new Cookie("JiraSDSamlssoLoginV2", "");
                clearCookie.setMaxAge(0);
                clearCookie.setPath("/");
                clearCookie.setHttpOnly(true);
                clearCookie.setSecure(this.samlSsoService.isHttps());
                httpRes.addCookie(clearCookie);
                String loginPageParam = URLEncoder.encode(this.samlSsoService.getRelativeBaseUrl() + httpReq.getRequestURI() + "?nosso", UTF_8);
                httpRes.setHeader("cache-control", "no-cache, no-store, must-revalidate");
                httpRes.sendRedirect(this.samlSsoService.getRelativeLoggedOutPageUrl() + "?loginurl=" + loginPageParam);
            } else {
                logger.debug("logout parameter is present, not redirecting");
                chain.doFilter(req, res);
            }
        } else {
            boolean absolute;
            String destinationValue = httpReq.getParameter(DESTINATION);
            boolean bl = absolute = httpReq.getParameter("absolute") != null && httpReq.getParameter("absolute").equals("true");
            if (destinationValue == null) {
                logger.debug("No destination given, using /servicedesk/customer/portal/1");
                destination2 = "/servicedesk/customer/portal/1";
            } else {
                destination2 = absolute ? (destinationValue.startsWith("/") ? destinationValue.replaceFirst("^" + this.samlSsoService.getRelativeBaseUrl(), "") : destinationValue.replaceFirst("^" + this.samlSsoService.getAbsoluteBaseUrl(), "")) : (destinationValue.startsWith("/") ? "/servicedesk/customer" + destinationValue : SERVICE_DESK_PREFIX + destinationValue);
            }
            String encodedDestination = destination2;
            try {
                encodedDestination = URLEncoder.encode(destination2, UTF_8);
                if (logger.isDebugEnabled()) {
                    logger.debug("Encoding destination from {} to {}", (Object)StringUtil.sanitize((String)destination2), (Object)StringUtil.sanitize((String)encodedDestination));
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error("URLencoding failed, THIS SHOULD NEVER HAPPEN!", (Throwable)e);
            }
            String redirectDestination = this.samlSsoService.getCanonicalBaseUrl() + "/plugins/servlet/samlsso" + "?redirectTo=" + encodedDestination;
            httpRes.setHeader("cache-control", "no-cache, no-store, must-revalidate");
            logger.debug("Redirecting to SSO: {}", (Object)redirectDestination);
            httpRes.sendRedirect(redirectDestination);
        }
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }

    @Nullable
    public static String readPortalFromURI(String requestURI) {
        Matcher matcher = PORTAL_PATTERN.matcher(requestURI);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }
}

